#pragma once

#include <vector>



namespace lib_geo
{


//! {|S
class BaseFace
{
public:
	BaseFace(void)
		: m_MatIdx(-1)
	{}

	void ClearAdjBuffer(void);

	//! _擾.
	size_t NumVertices(void) const;
	//! OpƂ̎Op`̖擾.
	size_t NumTriangles(void) const;

	// ʒuȊO̗vfĂ邩mF.
	bool HasNormal(void) const;
	bool HasUV(void) const;

	//! vfɈُ킪؂
	bool VerifyElementCounts(void) const;

	bool HasValidMatIdx(void) const { return m_MatIdx != -1; }

	void CopySubTriangle(BaseFace& f, int lvid0, int lvid1, int lvid2) const;

	void FlipIndexBuf(void);

public:
	std::vector<int>  m_VertIds; //!< _CfbNX
	std::vector<int>  m_NormIds; //!< _ɃoChꂽ@CfbNX
	std::vector<int>  m_UVIds;   //!< _ɃoChꂽUVCfbNX

	std::vector<int>  m_AdjEids;

	int               m_MatIdx;  //!< |Šʃ}eACfbNX. w => -1
};


class SubfaceIdx
{
public:
	SubfaceIdx(void) :
		fid(-1),
		subface(-1)
	{
	}
	SubfaceIdx(int fid_, int subface_) :
		fid(fid_),
		subface(subface_)
	{
	}

	void Set(int fid_, int subface_)
	{
		fid = fid_;
		subface = subface_;
	}

	void Reset(void)
	{
		fid = -1;
		subface = -1;
	}

	bool IsValid(void) const
	{
		return (fid != -1 && subface != -1);
	}

public:
	int fid;
	int subface;
};


}
