#pragma once

namespace util
{


//! w|C^NULLłȂdeleteNULL.
template<typename T> inline
void safe_delete( T*& ptr )
{
	if( ptr )
	{
		delete ptr;
		ptr = NULL;
	}
}


//! w|C^NULLłȂΔzƂdeleteNULL.
template<typename T> inline
void safe_delete_array( T*& ptr )
{
	if( ptr )
	{
		delete [] ptr;
		ptr = NULL;
	}
}



//! auto_cast̕⏕@\
template<typename From>
struct auto_cast_t
{
public:
	auto_cast_t(const From& val) : m_val(val) {}

	template<typename To>
	operator To() const
	{
		return static_cast<To>( m_val );
	}

private:
	const From& m_val;
};

//! ϊ̌^X^eBbNLXg
template<typename From>
auto_cast_t<From> auto_cast(const From& i_value)
{
	return auto_cast_t<From>(i_value);
}


}
