#pragma once

#include <vector>

#include <C2/lm/vector3.h>

#include "Mesh/BaseMesh.h"
#include "Shape.h"



namespace lib_geo
{


class SectionSegment : public Segment
{
public:
	SectionSegment(void) :
		Segment(),
		fid(-1)
	{}

public:
	int fid;
};


class CrossSectionUnit
{
public:
	void UpdateParams(const Plane& cut_plane);

private:
	void UpdateLengthRangeCenter(void);
	void UpdateConvexVerts(const Plane& cut_plane);
	void UpdateConvexLength(void);

public:
	std::vector<SectionSegment> m_Segments;
	float                       m_Length;
	lm::vec3f                   m_Center;
	lm::range3f                 m_Range;

	std::vector<lm::vec3f>      m_ConvexVerts;
	float                       m_ConvexLength;
};


}
