#pragma once

#include <vector>
#include <string>

namespace lib_geo
{
namespace util
{

class StringRef
{
public:
	StringRef(void) :
		beg(0),
		end(0)
	{
	}

	StringRef(char* _beg, char* _end) :
		beg(_beg),
		end(_end)
	{
	}

	char* GetBegin(void) { return beg; }
	char* GetEnd(void) { return end; }

	size_t GetLength(void)
	{
		return size_t(end - beg);
	}

	static void ToRefAry(std::string& s, std::vector<util::StringRef>& vs, size_t reserve = 3)
	{
		s.push_back(' ');

		vs.reserve(reserve);

		bool IsInWord = false;
		char* str_begin = NULL;
		for (size_t i = 0; i < s.size(); ++i)
		{
			char* c = &s[i];

			if (IsInWord)
			{
				if (IsNoChar(*c))
				{
					vs.push_back(util::StringRef(str_begin, c));
					IsInWord = false;
				}
			}
			else
			{
				if (!IsNoChar(*c))
				{
					str_begin = c;
					IsInWord = true;
				}
			}
		}

		if (IsInWord)
		{
			char* str_last = &s[s.size() - 1];
			++str_last;
			vs.push_back(util::StringRef(str_begin, str_last));
		}

		for (size_t i = 0; i < vs.size(); ++i)
		{
			char* e = vs[i].GetEnd();
			(*e) = '\0';
		}
	}

private:
	static bool IsNoChar(char c)
	{
		return (c == ' ' || c == '\t' || c == '\n');
	}

private:
	char* beg;
	char* end;
};

}
}
