#include "StdAfx.h"
#include "QIOUtil.h"

#include <QFile>
#include <QTextStream>



namespace qut
{


bool QIOUtil::ReadFileToString(const QString& filename, QString& buf)
{
	buf.clear();

	QFile file(filename);
	if(!file.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;

	{
		QTextStream in(&file);
		while(!in.atEnd())
		{
			QString s = in.readLine();
			buf += s + "\n";
		}
	}

	return true;
}

bool QIOUtil::StringToTextFile(const QString& filename, const QString& buf)
{
	QFile file(filename);
	if(!file.open(QIODevice::WriteOnly | QIODevice::Text))
		return false;

	{
		QTextStream out(&file);
		out << buf;
	}

	return true;
}


}
