#include "StdAfx.h"
#include "GeomTexture.h"



namespace geom
{


void GeomTextureSet::SetTextureUnit(TextureType type, gl::GlTexture* tex)
{
	switch (type)
	{
	case TextureType::Color  : TexColor  = tex; break;
	case TextureType::Normal : TexNormal = tex; break;
	default:
		assert(false);
		break;
	}
}

bool GeomTextureSet::HasActiveColorTexture(void) const
{
	return IsActiveTexture(TexColor);
}

bool GeomTextureSet::HasActiveNormalTexture(void) const
{
	return IsActiveTexture(TexNormal);
}

bool GeomTextureSet::IsActiveTexture(gl::GlTexture* tex) const
{
	if (tex == NULL)
		return false;
	if (!tex->HasTextureObject())
		return false;
	return true;
}

gl::GlTexture* GeomTextureSet::TakeTexture(TextureType type)
{
	gl::GlTexture* tex_buf = NULL;
	if (type == TextureType::Color)
		std::swap(tex_buf, TexColor);
	else if (type == TextureType::Normal)
		std::swap(tex_buf, TexNormal);

	return tex_buf;
}

bool GeomTextureSet::IsChild(const gl::GlTexture* tex) const
{
	if (TexColor == tex)
		return true;
	if (TexNormal == tex)
		return true;

	return false;
}


}
