#include "StdAfx.h"
#include "AppVersion.h"

#include "BuildInfo.h"

#include <QStringList>


bool AppVersion::FromDotSplit(QString version)
{
	QStringList vs = version.split(".");
	if (vs.size() != 4)
		return false;

	Major    = QString(vs[0]).toInt();
	Minor    = QString(vs[1]).toInt();
	BuildNo  = QString(vs[2]).toInt();
	Revision = QString(vs[3]).toInt();
	return true;
}

AppVersion AppVersion::GetCurrent(void)
{
	AppVersion version;
	version.Major    = QString(VERSION_MAJOR).toInt();
	version.Minor    = QString(VERSION_MINOR).toInt();
	version.BuildNo  = QString(BUILD_NUMBER).toInt();
	version.Revision = QString(VCS_REVISION).toInt();
	return version;
}

bool operator<(const AppVersion& a, const AppVersion& b)
{
#define CHECK_VERSION_ELEM(A,B) \
	if (A < B) return true;\
	if (A > B) return false;\

	CHECK_VERSION_ELEM(a.Major, b.Major)
	CHECK_VERSION_ELEM(a.Minor, b.Minor)
	CHECK_VERSION_ELEM(a.BuildNo, b.BuildNo)
	CHECK_VERSION_ELEM(a.Revision, b.Revision)

#undef CHECK_VERSION_ELEM

	return false;
}
