#include <QFile>
#include <QString>
#include <QList>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QStringList>
#include <QUrl>



class DownloadManager: public QObject
{
	Q_OBJECT

public:
	enum State
	{
		NoneState,
		Downloading,
		DownlaodSuc,
		DownloadFail,
	};

private:
	enum Mode
	{
		Mode_None,
		Mode_ToFile,
		Mode_ToBuffer,
	};

public:
	DownloadManager();

	void downloadToBuf(const QUrl &url, QByteArray* buf);
	void downloadToFile(const QUrl &url);
	void downloadToFile(const QUrl &url, const QString &filepath);

	QString saveFileName(const QUrl &url);

	bool saveToDisk(const QString &filename, QIODevice *data);

	State currentState(void) const;

	void WaitWhileDownloading(void);

private:
	bool procResut(QNetworkReply *reply);

public slots:
	void downloadFinished(QNetworkReply *reply);

private:
	QNetworkAccessManager manager;
	QString outFilepath;
	QByteArray* outBuf;

	Mode mode;
	State state;
};
