#include "StdAfx.h"

#include <C2/gl/GlslPhongShader.h>

#include "FormCustomShader.h"
#include "ui_FormCustomShader.h"

#include <Qt5Utility/QIOUtil.h>

#include <QMessageBox>

#include "../PathInfo.h"

#include "Shader/CustomShader.h"

static const char* DEFAULT_SHADER_VERT = "default_shader.vert";
static const char* DEFAULT_SHADER_FRAG = "default_shader.frag";



FormCustomShader::FormCustomShader(QWidget *parent) :
	QMainWindow(parent),
	ui(new Ui::FormCustomShader)
{
	m_ShaderLib = NULL;
	m_ParentWidget = NULL;

	ui->setupUi(this);
}

FormCustomShader::~FormCustomShader()
{
	delete ui;
}

void FormCustomShader::LoadOrSetDefaultCode(void)
{
	QString vert_path = GetDefaultVertFilename();
	QString src_vert;
	if(!qut::QIOUtil::ReadFileToString(vert_path, src_vert))
	{
		src_vert = lib_gl::GlslPhongShader::GetVertShaderCode();
	}
	ui->sourceVert->document()->setPlainText(src_vert);

	QString frag_path =GetDefaultFragFilename();
	QString src_frag;
	if(!qut::QIOUtil::ReadFileToString(frag_path, src_frag))
	{
		src_frag = lib_gl::GlslPhongShader::GetMultiLightFragShaderCode();
	}
	ui->sourceFrag->document()->setPlainText(src_frag);
}

QString FormCustomShader::GetDefaultVertFilename(void) const
{
	return GetShaderDir() + DEFAULT_SHADER_VERT;
}

QString FormCustomShader::GetDefaultFragFilename(void) const
{
	return GetShaderDir() + DEFAULT_SHADER_FRAG;
}

QString FormCustomShader::GetShaderDir(void) const
{
	return PathInfo::GetShaderDirPath();
}

void FormCustomShader::on_actionBuild_triggered()
{
	CustomShader* shader = m_ShaderLib->GetCustomShader();

	m_ParentWidget->makeCurrent();

	ui->textBuildResult->document()->setPlainText("");

	shader->SetFragCode(ui->sourceFrag->document()->toPlainText().toLocal8Bit().data());
	shader->SetVertCode(ui->sourceVert->document()->toPlainText().toLocal8Bit().data());

	QString msg;
	if(!shader->Rebuild())
		msg = "Build failed\n\n";
	else
		msg = "Build successed\n\n";

	msg += "\nVert status\n";
	msg += shader->GetLastVertStatus().c_str();
	msg += "\nFrag status\n";
	msg += shader->GetLastFragStatus().c_str();

	msg += "\nLink status\n";
	msg += shader->GetLastLinkStatus().c_str();

	ui->textBuildResult->document()->setPlainText(msg);

	m_ParentWidget->doneCurrent();

	emit ShaderBuild();
}


void FormCustomShader::keyPressEvent(QKeyEvent *e)
{
	if(e->modifiers() == Qt::ControlModifier)
	{
		if(e->key() == Qt::Key_Q)
		{
			close();
		}
	}
}


void FormCustomShader::SetShaderLibrary(ShaderLibrary* lib)
{
	m_ShaderLib = lib;
}

void FormCustomShader::SetParentWidget(MyGLWidget* widget)
{
	m_ParentWidget = widget;
}

void FormCustomShader::on_actionReloadVert_triggered()
{
	QString vert_path = GetDefaultVertFilename();
	QString src_vert;
	if(!qut::QIOUtil::ReadFileToString(vert_path, src_vert))
	{
		QMessageBox::warning(this, "", "Failed to load : " + vert_path);
		return;
	}
	ui->sourceVert->document()->setPlainText(src_vert);
}

void FormCustomShader::on_actionReloadFrag_triggered()
{
	QString frag_path = GetDefaultFragFilename();
	QString src_frag;
	if(!qut::QIOUtil::ReadFileToString(frag_path, src_frag))
	{
		QMessageBox::warning(this, "", "Failed to load : " + frag_path);
		return;
	}
	ui->sourceFrag->document()->setPlainText(src_frag);
}

void FormCustomShader::on_actionSaveVert_triggered()
{
	QMessageBox::warning(this, "", "Not implement");
	return;

	//QString src = ui->sourceVert->document()->toPlainText();
	//qut::QIOUtil::StringToTextFile(GetDefaultVertFilename(), src);
}

void FormCustomShader::on_actionSaveFrag_triggered()
{
	QMessageBox::warning(this, "", "Not implement");
	return;

	//QString src = ui->sourceFrag->document()->toPlainText();
	//qut::QIOUtil::StringToTextFile(GetDefaultFragFilename(), src);
}

void FormCustomShader::on_actionResetVert_triggered()
{
	QString src_vert = lib_gl::GlslPhongShader::GetVertShaderCode();
	ui->sourceVert->document()->setPlainText(src_vert);
}

void FormCustomShader::on_actionResetFrag_triggered()
{
	QString src_frag = lib_gl::GlslPhongShader::GetMultiLightFragShaderCode();
	ui->sourceFrag->document()->setPlainText(src_frag);
}
