#pragma once

#include <windows.h>
#include <sstream>



namespace lib_gl
{


inline void PlotBooleanState(GLenum pname, const char* param_name, int len)
{
	GLboolean params[16];
	glGetBooleanv(pname, params);

	std::ostringstream s;
	s << param_name << " : ";
	for(int i = 0; i < len; ++i)
	{
		s << (params[i] ? "T" : "F");
	}
	s << std::endl;

	OutputDebugStringA(s.str().c_str());
}


inline void PlotAllBooleanState(void)
{
	PlotBooleanState(GL_ACCUM_ALPHA_BITS, "GL_ACCUM_ALPHA_BITS", 1);
	PlotBooleanState(GL_ACCUM_BLUE_BITS, "GL_ACCUM_BLUE_BITS", 1);
	PlotBooleanState(GL_ACCUM_CLEAR_VALUE, "GL_ACCUM_CLEAR_VALUE", 4);
	PlotBooleanState(GL_ACCUM_GREEN_BITS, "GL_ACCUM_GREEN_BITS", 1);
	PlotBooleanState(GL_ACCUM_RED_BITS, "GL_ACCUM_RED_BITS", 1);
	PlotBooleanState(GL_ALPHA_BIAS, "GL_ALPHA_BIAS", 1);
	PlotBooleanState(GL_ALPHA_BITS, "GL_ALPHA_BITS", 1);
	PlotBooleanState(GL_ALPHA_SCALE, "GL_ALPHA_SCALE", 1);
	PlotBooleanState(GL_ALPHA_TEST, "GL_ALPHA_TEST", 1);
	PlotBooleanState(GL_ALPHA_TEST_FUNC, "GL_ALPHA_TEST_FUNC", 1);
	PlotBooleanState(GL_ALPHA_TEST_REF, "GL_ALPHA_TEST_REF", 1);
	PlotBooleanState(GL_ATTRIB_STACK_DEPTH, "GL_ATTRIB_STACK_DEPTH", 1);
	PlotBooleanState(GL_AUTO_NORMAL, "GL_AUTO_NORMAL", 1);
	PlotBooleanState(GL_AUX_BUFFERS, "GL_AUX_BUFFERS", 1);
	PlotBooleanState(GL_BLEND, "GL_BLEND", 1);
	PlotBooleanState(GL_BLEND_DST, "GL_BLEND_DST", 1);
	PlotBooleanState(GL_BLEND_SRC, "GL_BLEND_SRC", 1);
	PlotBooleanState(GL_BLUE_BIAS, "GL_BLUE_BIAS", 1);
	PlotBooleanState(GL_BLUE_BITS, "GL_BLUE_BITS", 1);
	PlotBooleanState(GL_BLUE_SCALE, "GL_BLUE_SCALE", 1);
	PlotBooleanState(GL_CLIENT_ATTRIB_STACK_DEPTH, "GL_CLIENT_ATTRIB_STACK_DEPTH", 1);
	//PlotBooleanState(GL_CLIP_PLANEi, "GL_CLIP_PLANEi", 1);
	PlotBooleanState(GL_COLOR_ARRAY, "GL_COLOR_ARRAY", 1);
	PlotBooleanState(GL_COLOR_ARRAY_SIZE, "GL_COLOR_ARRAY_SIZE", 1);
	PlotBooleanState(GL_COLOR_ARRAY_STRIDE, "GL_COLOR_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_COLOR_ARRAY_TYPE, "GL_COLOR_ARRAY_TYPE", 1);
	PlotBooleanState(GL_COLOR_CLEAR_VALUE, "GL_COLOR_CLEAR_VALUE", 4);
	PlotBooleanState(GL_COLOR_LOGIC_OP, "GL_COLOR_LOGIC_OP", 1);
	PlotBooleanState(GL_COLOR_MATERIAL, "GL_COLOR_MATERIAL", 1);
	PlotBooleanState(GL_COLOR_MATERIAL_FACE, "GL_COLOR_MATERIAL_FACE", 1);
	PlotBooleanState(GL_COLOR_MATERIAL_PARAMETER, "GL_COLOR_MATERIAL_PARAMETER", 1);
	PlotBooleanState(GL_COLOR_WRITEMASK, "GL_COLOR_WRITEMASK", 4);
	PlotBooleanState(GL_CULL_FACE, "GL_CULL_FACE", 1);
	PlotBooleanState(GL_CULL_FACE_MODE, "GL_CULL_FACE_MODE", 1);
	PlotBooleanState(GL_CURRENT_COLOR, "GL_CURRENT_COLOR", 4);
	PlotBooleanState(GL_CURRENT_INDEX, "GL_CURRENT_INDEX", 1);
	PlotBooleanState(GL_CURRENT_NORMAL, "GL_CURRENT_NORMAL", 3);
	PlotBooleanState(GL_CURRENT_RASTER_COLOR, "GL_CURRENT_RASTER_COLOR", 4);
	PlotBooleanState(GL_CURRENT_RASTER_DISTANCE, "GL_CURRENT_RASTER_DISTANCE", 1);
	PlotBooleanState(GL_CURRENT_RASTER_INDEX, "GL_CURRENT_RASTER_INDEX", 1);
	PlotBooleanState(GL_CURRENT_RASTER_POSITION, "GL_CURRENT_RASTER_POSITION", 4);
	PlotBooleanState(GL_CURRENT_RASTER_POSITION_VALID, "GL_CURRENT_RASTER_POSITION_VALID", 1);
	PlotBooleanState(GL_CURRENT_RASTER_TEXTURE_COORDS, "GL_CURRENT_RASTER_TEXTURE_COORDS", 4);
	PlotBooleanState(GL_CURRENT_TEXTURE_COORDS, "GL_CURRENT_TEXTURE_COORDS", 4);
	PlotBooleanState(GL_DEPTH_BIAS, "GL_DEPTH_BIAS", 1);
	PlotBooleanState(GL_DEPTH_BITS, "GL_DEPTH_BITS", 1);
	PlotBooleanState(GL_DEPTH_CLEAR_VALUE, "GL_DEPTH_CLEAR_VALUE", 1);
	PlotBooleanState(GL_DEPTH_FUNC, "GL_DEPTH_FUNC", 1);
	PlotBooleanState(GL_DEPTH_RANGE, "GL_DEPTH_RANGE", 2);
	PlotBooleanState(GL_DEPTH_SCALE, "GL_DEPTH_SCALE", 1);
	PlotBooleanState(GL_DEPTH_TEST, "GL_DEPTH_TEST", 1);
	PlotBooleanState(GL_DEPTH_WRITEMASK, "GL_DEPTH_WRITEMASK", 1);
	PlotBooleanState(GL_DITHER, "GL_DITHER", 1);
	PlotBooleanState(GL_DOUBLEBUFFER, "GL_DOUBLEBUFFER", 1);
	PlotBooleanState(GL_DRAW_BUFFER, "GL_DRAW_BUFFER", 1);
	PlotBooleanState(GL_EDGE_FLAG, "GL_EDGE_FLAG", 1);
	PlotBooleanState(GL_EDGE_FLAG_ARRAY, "GL_EDGE_FLAG_ARRAY", 1);
	PlotBooleanState(GL_EDGE_FLAG_ARRAY_STRIDE, "GL_EDGE_FLAG_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_FOG, "GL_FOG", 1);
	PlotBooleanState(GL_FOG_COLOR, "GL_FOG_COLOR", 4);
	PlotBooleanState(GL_FOG_DENSITY, "GL_FOG_DENSITY", 1);
	PlotBooleanState(GL_FOG_END, "GL_FOG_END", 1);
	PlotBooleanState(GL_FOG_HINT, "GL_FOG_HINT", 1);
	PlotBooleanState(GL_FOG_INDEX, "GL_FOG_INDEX", 1);
	PlotBooleanState(GL_FOG_MODE, "GL_FOG_MODE", 1);
	PlotBooleanState(GL_FOG_START, "GL_FOG_START", 1);
	PlotBooleanState(GL_FRONT_FACE, "GL_FRONT_FACE", 1);
	PlotBooleanState(GL_GREEN_BIAS, "GL_GREEN_BIAS", 1);
	PlotBooleanState(GL_GREEN_BITS, "GL_GREEN_BITS", 1);
	PlotBooleanState(GL_GREEN_SCALE, "GL_GREEN_SCALE", 1);
	PlotBooleanState(GL_INDEX_ARRAY, "GL_INDEX_ARRAY", 1);
	PlotBooleanState(GL_INDEX_ARRAY_STRIDE, "GL_INDEX_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_INDEX_ARRAY_TYPE, "GL_INDEX_ARRAY_TYPE", 1);
	PlotBooleanState(GL_INDEX_BITS, "GL_INDEX_BITS", 1);
	PlotBooleanState(GL_INDEX_CLEAR_VALUE, "GL_INDEX_CLEAR_VALUE", 1);
	PlotBooleanState(GL_INDEX_LOGIC_OP, "GL_INDEX_LOGIC_OP", 1);
	PlotBooleanState(GL_INDEX_MODE, "GL_INDEX_MODE", 1);
	PlotBooleanState(GL_INDEX_OFFSET, "GL_INDEX_OFFSET", 1);
	PlotBooleanState(GL_INDEX_SHIFT, "GL_INDEX_SHIFT", 1);
	PlotBooleanState(GL_INDEX_WRITEMASK, "GL_INDEX_WRITEMASK", 1);
	//PlotBooleanState(GL_LIGHTi, "GL_LIGHTi", 1);
	PlotBooleanState(GL_LIGHTING, "GL_LIGHTING", 1);
	PlotBooleanState(GL_LIGHT_MODEL_AMBIENT, "GL_LIGHT_MODEL_AMBIENT", 4);
	PlotBooleanState(GL_LIGHT_MODEL_LOCAL_VIEWER, "GL_LIGHT_MODEL_LOCAL_VIEWER", 1);
	PlotBooleanState(GL_LIGHT_MODEL_TWO_SIDE, "GL_LIGHT_MODEL_TWO_SIDE", 1);
	PlotBooleanState(GL_LINE_SMOOTH, "GL_LINE_SMOOTH", 1);
	PlotBooleanState(GL_LINE_SMOOTH_HINT, "GL_LINE_SMOOTH_HINT", 1);
	PlotBooleanState(GL_LINE_STIPPLE, "GL_LINE_STIPPLE", 1);
	PlotBooleanState(GL_LINE_STIPPLE_PATTERN, "GL_LINE_STIPPLE_PATTERN", 1);
	PlotBooleanState(GL_LINE_STIPPLE_REPEAT, "GL_LINE_STIPPLE_REPEAT", 1);
	PlotBooleanState(GL_LINE_WIDTH, "GL_LINE_WIDTH", 1);
	PlotBooleanState(GL_LINE_WIDTH_GRANULARITY, "GL_LINE_WIDTH_GRANULARITY", 1);
	PlotBooleanState(GL_LINE_WIDTH_RANGE, "GL_LINE_WIDTH_RANGE", 2);
	PlotBooleanState(GL_LIST_BASE, "GL_LIST_BASE", 1);
	PlotBooleanState(GL_LIST_INDEX, "GL_LIST_INDEX", 1);
	PlotBooleanState(GL_LIST_MODE, "GL_LIST_MODE", 1);
	PlotBooleanState(GL_LOGIC_OP, "GL_LOGIC_OP", 1);
	PlotBooleanState(GL_LOGIC_OP_MODE, "GL_LOGIC_OP_MODE", 1);
	PlotBooleanState(GL_MAP1_COLOR_4, "GL_MAP1_COLOR_4", 1);
	PlotBooleanState(GL_MAP1_GRID_DOMAIN, "GL_MAP1_GRID_DOMAIN", 2);
	PlotBooleanState(GL_MAP1_GRID_SEGMENTS, "GL_MAP1_GRID_SEGMENTS", 1);
	PlotBooleanState(GL_MAP1_INDEX, "GL_MAP1_INDEX", 1);
	PlotBooleanState(GL_MAP1_NORMAL, "GL_MAP1_NORMAL", 1);
	PlotBooleanState(GL_MAP1_TEXTURE_COORD_1, "GL_MAP1_TEXTURE_COORD_1", 1);
	PlotBooleanState(GL_MAP1_TEXTURE_COORD_2, "GL_MAP1_TEXTURE_COORD_2", 1);
	PlotBooleanState(GL_MAP1_TEXTURE_COORD_3, "GL_MAP1_TEXTURE_COORD_3", 1);
	PlotBooleanState(GL_MAP1_TEXTURE_COORD_4, "GL_MAP1_TEXTURE_COORD_4", 1);
	PlotBooleanState(GL_MAP1_VERTEX_3, "GL_MAP1_VERTEX_3", 1);
	PlotBooleanState(GL_MAP1_VERTEX_4, "GL_MAP1_VERTEX_4", 1);
	PlotBooleanState(GL_MAP2_COLOR_4, "GL_MAP2_COLOR_4", 1);
	PlotBooleanState(GL_MAP2_GRID_DOMAIN, "GL_MAP2_GRID_DOMAIN", 4);
	PlotBooleanState(GL_MAP2_GRID_SEGMENTS, "GL_MAP2_GRID_SEGMENTS", 2);
	PlotBooleanState(GL_MAP2_INDEX, "GL_MAP2_INDEX", 1);
	PlotBooleanState(GL_MAP2_NORMAL, "GL_MAP2_NORMAL", 1);
	PlotBooleanState(GL_MAP2_TEXTURE_COORD_1, "GL_MAP2_TEXTURE_COORD_1", 1);
	PlotBooleanState(GL_MAP2_TEXTURE_COORD_2, "GL_MAP2_TEXTURE_COORD_2", 1);
	PlotBooleanState(GL_MAP2_TEXTURE_COORD_3, "GL_MAP2_TEXTURE_COORD_3", 1);
	PlotBooleanState(GL_MAP2_TEXTURE_COORD_4, "GL_MAP2_TEXTURE_COORD_4", 1);
	PlotBooleanState(GL_MAP2_VERTEX_3, "GL_MAP2_VERTEX_3", 1);
	PlotBooleanState(GL_MAP2_VERTEX_4, "GL_MAP2_VERTEX_4", 1);
	PlotBooleanState(GL_MAP_COLOR, "GL_MAP_COLOR", 1);
	PlotBooleanState(GL_MAP_STENCIL, "GL_MAP_STENCIL", 1);
	PlotBooleanState(GL_MATRIX_MODE, "GL_MATRIX_MODE", 1);
	PlotBooleanState(GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_ATTRIB_STACK_DEPTH, "GL_MAX_ATTRIB_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_CLIP_PLANES, "GL_MAX_CLIP_PLANES", 1);
	PlotBooleanState(GL_MAX_EVAL_ORDER, "GL_MAX_EVAL_ORDER", 1);
	PlotBooleanState(GL_MAX_LIGHTS, "GL_MAX_LIGHTS", 1);
	PlotBooleanState(GL_MAX_LIST_NESTING, "GL_MAX_LIST_NESTING", 1);
	PlotBooleanState(GL_MAX_MODELVIEW_STACK_DEPTH, "GL_MAX_MODELVIEW_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_NAME_STACK_DEPTH, "GL_MAX_NAME_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_PIXEL_MAP_TABLE, "GL_MAX_PIXEL_MAP_TABLE", 1);
	PlotBooleanState(GL_MAX_PROJECTION_STACK_DEPTH, "GL_MAX_PROJECTION_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_TEXTURE_SIZE, "GL_MAX_TEXTURE_SIZE", 1);
	PlotBooleanState(GL_MAX_TEXTURE_STACK_DEPTH, "GL_MAX_TEXTURE_STACK_DEPTH", 1);
	PlotBooleanState(GL_MAX_VIEWPORT_DIMS, "GL_MAX_VIEWPORT_DIMS", 2);
	PlotBooleanState(GL_MODELVIEW_MATRIX, "GL_MODELVIEW_MATRIX", 16);
	PlotBooleanState(GL_MODELVIEW_STACK_DEPTH, "GL_MODELVIEW_STACK_DEPTH", 1);
	PlotBooleanState(GL_NAME_STACK_DEPTH, "GL_NAME_STACK_DEPTH", 1);
	PlotBooleanState(GL_NORMAL_ARRAY, "GL_NORMAL_ARRAY", 1);
	PlotBooleanState(GL_NORMAL_ARRAY_STRIDE, "GL_NORMAL_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_NORMAL_ARRAY_TYPE, "GL_NORMAL_ARRAY_TYPE", 1);
	PlotBooleanState(GL_NORMALIZE, "GL_NORMALIZE", 1);
	PlotBooleanState(GL_PACK_ALIGNMENT, "GL_PACK_ALIGNMENT", 1);
	PlotBooleanState(GL_PACK_LSB_FIRST, "GL_PACK_LSB_FIRST", 1);
	PlotBooleanState(GL_PACK_ROW_LENGTH, "GL_PACK_ROW_LENGTH", 1);
	PlotBooleanState(GL_PACK_SKIP_PIXELS, "GL_PACK_SKIP_PIXELS", 1);
	PlotBooleanState(GL_PACK_SKIP_ROWS, "GL_PACK_SKIP_ROWS", 1);
	PlotBooleanState(GL_PACK_SWAP_BYTES, "GL_PACK_SWAP_BYTES", 1);
	PlotBooleanState(GL_PERSPECTIVE_CORRECTION_HINT, "GL_PERSPECTIVE_CORRECTION_HINT", 1);
	PlotBooleanState(GL_PIXEL_MAP_A_TO_A_SIZE, "GL_PIXEL_MAP_A_TO_A_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_B_TO_B_SIZE, "GL_PIXEL_MAP_B_TO_B_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_G_TO_G_SIZE, "GL_PIXEL_MAP_G_TO_G_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_I_TO_A_SIZE, "GL_PIXEL_MAP_I_TO_A_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_I_TO_B_SIZE, "GL_PIXEL_MAP_I_TO_B_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_I_TO_G_SIZE, "GL_PIXEL_MAP_I_TO_G_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_I_TO_I_SIZE, "GL_PIXEL_MAP_I_TO_I_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_I_TO_R_SIZE, "GL_PIXEL_MAP_I_TO_R_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_R_TO_R_SIZE, "GL_PIXEL_MAP_R_TO_R_SIZE", 1);
	PlotBooleanState(GL_PIXEL_MAP_S_TO_S_SIZE, "GL_PIXEL_MAP_S_TO_S_SIZE", 1);
	PlotBooleanState(GL_POINT_SIZE, "GL_POINT_SIZE", 1);
	PlotBooleanState(GL_POINT_SIZE_GRANULARITY, "GL_POINT_SIZE_GRANULARITY", 1);
	PlotBooleanState(GL_POINT_SIZE_RANGE, "GL_POINT_SIZE_RANGE", 2);
	PlotBooleanState(GL_POINT_SMOOTH, "GL_POINT_SMOOTH", 1);
	PlotBooleanState(GL_POINT_SMOOTH_HINT, "GL_POINT_SMOOTH_HINT", 1);
	PlotBooleanState(GL_POLYGON_MODE, "GL_POLYGON_MODE", 2);
	PlotBooleanState(GL_POLYGON_OFFSET_FACTOR, "GL_POLYGON_OFFSET_FACTOR", 1);
	PlotBooleanState(GL_POLYGON_OFFSET_UNITS, "GL_POLYGON_OFFSET_UNITS", 1);
	PlotBooleanState(GL_POLYGON_OFFSET_FILL, "GL_POLYGON_OFFSET_FILL", 1);
	PlotBooleanState(GL_POLYGON_OFFSET_LINE, "GL_POLYGON_OFFSET_LINE", 1);
	PlotBooleanState(GL_POLYGON_OFFSET_POINT, "GL_POLYGON_OFFSET_POINT", 1);
	PlotBooleanState(GL_POLYGON_SMOOTH, "GL_POLYGON_SMOOTH", 1);
	PlotBooleanState(GL_POLYGON_SMOOTH_HINT, "GL_POLYGON_SMOOTH_HINT", 1);
	PlotBooleanState(GL_POLYGON_STIPPLE, "GL_POLYGON_STIPPLE", 1);
	PlotBooleanState(GL_PROJECTION_MATRIX, "GL_PROJECTION_MATRIX", 16);
	PlotBooleanState(GL_PROJECTION_STACK_DEPTH, "GL_PROJECTION_STACK_DEPTH", 1);
	PlotBooleanState(GL_READ_BUFFER, "GL_READ_BUFFER", 1);
	PlotBooleanState(GL_RED_BIAS, "GL_RED_BIAS", 1);
	PlotBooleanState(GL_RED_BITS, "GL_RED_BITS", 1);
	PlotBooleanState(GL_RED_SCALE, "GL_RED_SCALE", 1);
	PlotBooleanState(GL_RENDER_MODE, "GL_RENDER_MODE", 1);
	PlotBooleanState(GL_RGBA_MODE, "GL_RGBA_MODE", 1);
	PlotBooleanState(GL_SCISSOR_BOX, "GL_SCISSOR_BOX", 4);
	PlotBooleanState(GL_SCISSOR_TEST, "GL_SCISSOR_TEST", 1);
	PlotBooleanState(GL_SHADE_MODEL, "GL_SHADE_MODEL", 1);
	PlotBooleanState(GL_STENCIL_BITS, "GL_STENCIL_BITS", 1);
	PlotBooleanState(GL_STENCIL_CLEAR_VALUE, "GL_STENCIL_CLEAR_VALUE", 1);
	PlotBooleanState(GL_STENCIL_FAIL, "GL_STENCIL_FAIL", 1);
	PlotBooleanState(GL_STENCIL_FUNC, "GL_STENCIL_FUNC", 1);
	PlotBooleanState(GL_STENCIL_PASS_DEPTH_FAIL, "GL_STENCIL_PASS_DEPTH_FAIL", 1);
	PlotBooleanState(GL_STENCIL_PASS_DEPTH_PASS, "GL_STENCIL_PASS_DEPTH_PASS", 1);
	PlotBooleanState(GL_STENCIL_REF, "GL_STENCIL_REF", 1);
	PlotBooleanState(GL_STENCIL_TEST, "GL_STENCIL_TEST", 1);
	PlotBooleanState(GL_STENCIL_VALUE_MASK, "GL_STENCIL_VALUE_MASK", 1);
	PlotBooleanState(GL_STENCIL_WRITEMASK, "GL_STENCIL_WRITEMASK", 1);
	PlotBooleanState(GL_STEREO, "GL_STEREO", 1);
	PlotBooleanState(GL_SUBPIXEL_BITS, "GL_SUBPIXEL_BITS", 1);
	PlotBooleanState(GL_TEXTURE_1D, "GL_TEXTURE_1D", 1);
	PlotBooleanState(GL_TEXTURE_2D, "GL_TEXTURE_2D", 1);
	PlotBooleanState(GL_TEXTURE_COORD_ARRAY, "GL_TEXTURE_COORD_ARRAY", 1);
	PlotBooleanState(GL_TEXTURE_COORD_ARRAY_SIZE, "GL_TEXTURE_COORD_ARRAY_SIZE", 1);
	PlotBooleanState(GL_TEXTURE_COORD_ARRAY_STRIDE, "GL_TEXTURE_COORD_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_TEXTURE_COORD_ARRAY_TYPE, "GL_TEXTURE_COORD_ARRAY_TYPE", 1);
	PlotBooleanState(GL_TEXTURE_ENV_COLOR, "GL_TEXTURE_ENV_COLOR", 4);
	PlotBooleanState(GL_TEXTURE_ENV_MODE, "GL_TEXTURE_ENV_MODE", 1);
	PlotBooleanState(GL_TEXTURE_GEN_Q, "GL_TEXTURE_GEN_Q", 1);
	PlotBooleanState(GL_TEXTURE_GEN_R, "GL_TEXTURE_GEN_R", 1);
	PlotBooleanState(GL_TEXTURE_GEN_S, "GL_TEXTURE_GEN_S", 1);
	PlotBooleanState(GL_TEXTURE_GEN_T, "GL_TEXTURE_GEN_T", 1);
	PlotBooleanState(GL_TEXTURE_MATRIX, "GL_TEXTURE_MATRIX", 16);
	PlotBooleanState(GL_TEXTURE_STACK_DEPTH, "GL_TEXTURE_STACK_DEPTH", 1);
	PlotBooleanState(GL_UNPACK_ALIGNMENT, "GL_UNPACK_ALIGNMENT", 1);
	PlotBooleanState(GL_UNPACK_LSB_FIRST, "GL_UNPACK_LSB_FIRST", 1);
	PlotBooleanState(GL_UNPACK_ROW_LENGTH, "GL_UNPACK_ROW_LENGTH", 1);
	PlotBooleanState(GL_UNPACK_SKIP_PIXELS, "GL_UNPACK_SKIP_PIXELS", 1);
	PlotBooleanState(GL_UNPACK_SKIP_ROWS, "GL_UNPACK_SKIP_ROWS", 1);
	PlotBooleanState(GL_UNPACK_SWAP_BYTES, "GL_UNPACK_SWAP_BYTES", 1);
	PlotBooleanState(GL_VERTEX_ARRAY, "GL_VERTEX_ARRAY", 1);
	PlotBooleanState(GL_VERTEX_ARRAY_SIZE, "GL_VERTEX_ARRAY_SIZE", 1);
	PlotBooleanState(GL_VERTEX_ARRAY_STRIDE, "GL_VERTEX_ARRAY_STRIDE", 1);
	PlotBooleanState(GL_VERTEX_ARRAY_TYPE, "GL_VERTEX_ARRAY_TYPE", 1);
	PlotBooleanState(GL_VIEWPORT, "GL_VIEWPORT", 4);
	PlotBooleanState(GL_ZOOM_X, "GL_ZOOM_X", 1);
	PlotBooleanState(GL_ZOOM_Y, "GL_ZOOM_Y", 1);
}


}
