#pragma once

#include "../graph/RawImage.h"

#include "TextureTypes.h"


namespace lib_gl
{


//! 2DeNX`NX
template<typename T>
class Texture2D : public lib_graph::RawImage<T>
{
public:
	Texture2D(void)
		: lib_graph::RawImage<T>()
	{
		ClearTextureParameters( *this );
	}
	
	Texture2D(size_t num_x, size_t num_y)
		: lib_graph::RawImage<T>( num_x , num_y )
	{
		ClearTextureParameters( *this );
	}

	Texture2D(size_t num_x, size_t num_y, const T& initial_value)
		: lib_graph::RawImage<T>( num_x , num_y , initial_value )
	{
		ClearTextureParameters( *this );
	}

	//! Rs[RXgN^.
	Texture2D(const Texture2D<T>& m) : lib_graph::RawImage<T>( m )
	{
		m_MipmapLevel    = m.m_MipmapLevel;
		m_BorderSize     = m.m_BorderSize;
		m_InternalFormat = m.m_InternalFormat;
		m_PixelFormat    = m.m_PixelFormat;
		m_PixelDataType  = m.m_PixelDataType;
	}

	//! 2DeNX`obt@𐶐
	void Attach( lib_gl::TEXTURE_MODE i_Mode = TEXTURE_NORMAL );

	//! eNX`tH[}bgZbg.
	void SetTexelFormats( GLint i_InternalFormat , GLenum i_PixelFormat , GLenum i_PixelDataType );
	void SetTexelFormats( GLenum i_PixelFormat , GLenum i_PixelDataType );

	//! eNX`p[^̃NA
	void ClearTextureParameters(void);


protected:
	static void ClearTextureParameters( Texture2D<T>& o_texture );

	// eNZ^ɑ΂K؂ȃACg(eNX`1s̃oCg̍ő) ߂.
	// {Iɂ, RGB * byte ̑gݍ킹̂1, ȊO4.
	template<typename T>
	static GLint GetAlignmentLength(void) { return 4; }
	template<>
	static GLint GetAlignmentLength< lib_graph::color3b >(void) { return 1; }


public:
	GLint  m_MipmapLevel;    //!< ~bv}bvx
	GLint  m_BorderSize;     //!< E̕

	GLint  m_InternalFormat; //!< OpenGL̃eNZ`
	GLenum m_PixelFormat;    //!< ̓obt@̃eNZ`
	GLenum m_PixelDataType;  //!< eNZ̊e`l̃f[^^
};


// typedef
typedef lib_gl::Texture2D<lib_graph::color3b> Texture2D3b;
typedef lib_gl::Texture2D<lib_graph::color3f> Texture2D3f;
typedef lib_gl::Texture2D<lib_graph::color3i> Texture2D3i;
typedef lib_gl::Texture2D<lib_graph::color3d> Texture2D3d;
typedef lib_gl::Texture2D<lib_graph::color4b> Texture2D4b;
typedef lib_gl::Texture2D<lib_graph::color4f> Texture2D4f;
typedef lib_gl::Texture2D<lib_graph::color4i> Texture2D4i;
typedef lib_gl::Texture2D<lib_graph::color4d> Texture2D4d;



// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//! OpenGL̃JgeNX`Ɋ蓖Ă.
template<typename T> inline
void Texture2D<T>::Attach( lib_gl::TEXTURE_MODE i_Mode )
{
	// tH[}bgݒ肳Ă邩mF.
	_ASSERTE( m_InternalFormat != 0 );
	if( m_InternalFormat == 0 )
		return;

	_ASSERTE( m_PixelFormat != 0 );
	if( m_PixelFormat == 0 )
		return;

	_ASSERTE( m_PixelDataType != 0 );
	if( m_PixelDataType == 0 )
		return;

	if( i_Mode == TEXTURE_NORMAL )
	{
		glPixelStorei( GL_UNPACK_ALIGNMENT , GetAlignmentLength<T>() );

		glTexImage2D( GL_TEXTURE_2D
	              , m_MipmapLevel
	              , m_InternalFormat
	              , size_x() , size_y()
	              , m_BorderSize
	              , m_PixelFormat , m_PixelDataType
	              , v()
	              );
	}
	else if( i_Mode == TEXTURE_MIPMAP )
	{
		glPixelStorei( GL_UNPACK_ALIGNMENT , GetAlignmentLength<T>() );

		gluBuild2DMipmaps( GL_TEXTURE_2D
		                 , m_InternalFormat
		                 , size_x() , size_y()
		                 , m_PixelFormat , m_PixelDataType
		                 , v()
		                 );
	}
	else
	{
		_ASSERT( false );
	}
}

//! eNX`tH[}bgZbg.
//! @param[in] i_InternalFormat - OpenGLŕێeNŽ^  (GL_RGB,GL_RGBA...)
//! @param[in] i_PixelFormat    - ̃NXŕێeNŽ^  (GL_RGB,GL_RGBA...)
//! @param[in] i_PixelDataType  - P̐Fvf̃f[^^  (GL_UNSIGNED_BYTE...)
template<typename T> inline
void Texture2D<T>::SetTexelFormats( GLint i_InternalFormat , GLenum i_PixelFormat , GLenum i_PixelDataType )
{
	m_InternalFormat = i_InternalFormat;
	m_PixelFormat    = i_PixelFormat;
	m_PixelDataType  = i_PixelDataType;
}

//! eNX`tH[}bgZbg.
//! @param[in] i_PixelFormat   - eNŽ^  (GL_RGB,GL_RGBA...)
//! @param[in] i_PixelDataType - P̐Fvf̃f[^^  (GL_UNSIGNED_BYTE...)
template<typename T> inline
void Texture2D<T>::SetTexelFormats( GLenum i_PixelFormat , GLenum i_PixelDataType )
{
	SetTexelFormats( i_PixelFormat , i_PixelFormat , i_PixelDataType );
}


template<typename T> inline
void Texture2D<T>::ClearTextureParameters(void)
{
	ClearTextureParameters( *this );
}

template<typename T> inline
void Texture2D<T>::ClearTextureParameters( Texture2D<T>& o_texture )
{
	o_texture.m_MipmapLevel    = 0;
	o_texture.m_BorderSize     = 0;

	o_texture.m_InternalFormat = 0;
	o_texture.m_PixelFormat    = 0;
	o_texture.m_PixelDataType  = 0;
}


}
