#pragma once

#include <vector>

#include <C2/lm/vector2.h>
#include <C2/lm/vector3.h>
#include <C2/lm/range3.h>

#include <C2/graph/material.h>



namespace lib_geo
{


class BaseEdge;
class BaseFace;
class VertAdj;
class BaseMesh;



//! {GbW
class BaseEdge
{
public:
	BaseEdge(void)
	{
		m_VertIds[0] = -1;
		m_VertIds[1] = -1;
	}

	virtual void Clear(void);
	virtual void ClearAdjBuffer(void);

	std::pair<int,int> ToIntPair(void) const;


public:
	int               m_VertIds[2];

	std::vector<int>  m_AdjFids;
};


//! {|S
class BaseFace
{
public:
	BaseFace(void)
		: m_MatIdx(-1)
	{}

	virtual void Clear(void);
	virtual void ClearAdjBuffer(void);
	virtual void ClearMatIdx(void);

	//! _擾.
	size_t NumVertices(void) const;
	//! OpƂ̎Op`̖擾.
	size_t NumTriangles(void) const;

	// ʒuȊO̗vfĂ邩mF.
	bool HasNormal(void) const;
	bool HasUV(void) const;

	//! vfɈُ킪؂
	bool VerifyElementCounts(void) const;

	bool HasValidMatIdx(void) const { return m_MatIdx != -1; }


public:
	std::vector<int>  m_VertIds; //!< _CfbNX
	std::vector<int>  m_NormIds; //!< _ɃoChꂽ@CfbNX
	std::vector<int>  m_UVIds;   //!< _ɃoChꂽUVCfbNX

	std::vector<int>  m_AdjEids;

	int               m_MatIdx;  //!< |Šʃ}eACfbNX. w => -1
};


//! _̗אڏ
class VertAdj
{
public:
	VertAdj(void)
	{}

	virtual void ClearAdjBuffer(void);


public:
	std::vector<int>  m_AdjEids;
	std::vector<int>  m_AdjFids;

	lm::vec3f m_NormalAvg;
};


class BasePolyline
{
public:
	void Clear(void);

	void Swap(BasePolyline& pl);

public:
	std::vector<int> m_VertIds;
};


class BaseMaterial : public lib_graph::Material
{
public:
	BaseMaterial(void) : lib_graph::Material() {}
	BaseMaterial(const lib_graph::Material& m) : lib_graph::Material(m) {}

	void operator=(const lib_graph::Material& m)
	{
		(*dynamic_cast<lib_graph::Material*>(this)) = m;
	}

	std::string m_Name;
};


}
