#pragma once

#include <LibGeo/Mesh/BaseMesh.h>
#include <LibGeo/CrossSection.h>

#include <C2/graph/Material.h>
#include <C2/lm/Matrix4.h>

#include <map>

#include "Image/GeomTexture.h"

#include "Transform.h"
#include "PolylineContext.h"

#include "GeomFileFormat.h"
#include "Bone.h"



namespace geom
{


class VertexLinker
{
public:
	VertexLinker(void)
	{
		m_IsLoop = false;
	}

public:
	std::vector<int> m_VertLinks;
	bool             m_IsLoop;
};


class FaceGroup
{
public:
	FaceGroup(void) :
		m_GroupID(-1)
	{
	}

	bool IsEmpty(void) const
	{
		return m_Fids.empty();
	}

	int GetTopFid(void) const
	{
		if(m_Fids.empty())
			return -1;

		return m_Fids.front();
	}

	void ClearGroup(void)
	{
		m_Fids.clear();
		m_GroupID = -1;
	}

public:
	std::vector<int> m_Fids;
	int m_GroupID;
};


class GeomObject
{
public:
	GeomObject(void);

	void ClearObject(void);

	void InitializeBufferCommon(void);

	void CreateAdjBufOnce(void);

	bool HasTexture(void) const
	{
		return !m_Textures.empty();
	}

	const lm::range3f& GetBoundingBox(void) const
	{
		return m_BBox;
	}

	void UpdateBBox(void);

	void FlipFace(void);

	void ClearSelect(void);

	void SwapVertSelect(int vidx);
	void SetVertSelect(int vidx, bool select);
	bool GetVertSelect(int vidx) const;

	void CreateFaceMatGroup(void);

	bool IsFileObject(void) const;

	void UpdateCrossSection(bool SplitGroup, const lib_geo::Plane& cutplane);

	void Triangulate(void);

	bool IsValidMaterialIdx(int idx) const;

	void InitColorTexture(int idx, const std::string& filepath, const std::string& name, const gl::TextureConfig& config);

	GeomTextureSet* GetTextureFromFace(const lib_geo::BaseFace& f);
	GeomTextureSet* GetTexture(const int idx);

	void CreateTextureBuf(size_t size);

	size_t GetNumFaces(void) const
	{
		return m_Mesh.m_Faces.size();
	}

	size_t GetNumVerts(void) const
	{
		return m_Mesh.m_Verts.size();
	}

	const lm::range3f& GetBBox(void) const
	{
		return m_BBox;
	}

private:
	void ClearTexture(void);


public:
	// eReił̃IuWFNg̃CfbNX
	int                                 m_ObjectIndex;
	std::string                         m_Name;

	lib_geo::BaseMesh                   m_Mesh;

	std::string                         m_FilePath;
	geom::GeomFileFormat                m_FileFormat;

	bool                                m_Visible;
	bool                                m_VertexOnlyMode;

	std::map<int, bool>                 m_SelVerts;

	std::map<int, FaceGroup>            m_FaceMatGroup;

	std::vector<VertexLinker>           m_VertLinkers;

	lib_geo::CrossSection               m_CrossSection;
	std::vector<lib_geo::CrossSection>  m_CrossSectionLog;

	PolylineContext                     m_PolylineContext;

	BoneAnimation                       m_BoneAnimation;

private:
	lm::range3f                         m_BBox;

	boost::ptr_vector<GeomTextureSet>   m_Textures;

	boost::ptr_vector<gl::GlTexture>    m_ColorTextureBuf;
};	
	
	



}
