#pragma once

#include <string>
#include <C2/gl/GlslShader.h>

#include "ShaderInterface.h"


class CustomShader : public ShaderInterface
{
public:
	CustomShader(ShaderContext* context) :
		ShaderInterface(context)
	{
	}

	const char* GetShaderName(void)
	{
		return "CustomShader";
	}

	bool Rebuild(void);
	void Release(void);

	virtual void BeginShader(void);
	virtual void EndShader(void);

	void SetVertCode(const char* code);
	void SetFragCode(const char* code);

	const std::string& GetLastLinkStatus(void) const
	{
		return m_Program.GetLastLinkStatus();
	}

	const std::string& GetLastVertStatus(void) const
	{
		return m_LastVertCompileStatus;
	}

	const std::string& GetLastFragStatus(void) const
	{
		return m_LastFragCompileStatus;
	}

private:
	bool CreateVertexShader(lib_gl::GlslShader& shaer);
	bool CreateFragmentShader(lib_gl::GlslShader& shaer);


private:
	std::string m_VertCode;
	std::string m_FragCode;

	std::string m_LastVertCompileStatus;
	std::string m_LastFragCompileStatus;

	lib_gl::GlslProgram m_Program;
};
