#pragma once

#include "../graph/Material.h"
#include "MaterialSetter.h"


namespace lib_gl
{


class Material : public lib_graph::Material
{
public:
	Material(void);
	Material(const lib_graph::Material& mat);

	const Material& operator=(const lib_graph::Material& mat);

public:
	void SetGL( GLenum face_type = GL_FRONT_AND_BACK , bool set_diffuse_to_color = true );
	void GetGL( GLenum face_type = GL_FRONT );
};


class DoublesideMaterial : public lib_graph::DoublesideMaterial
{
	DoublesideMaterial(void);
	DoublesideMaterial(const lib_graph::DoublesideMaterial& mat);

	const DoublesideMaterial& operator=(const lib_graph::DoublesideMaterial& mat);

public:
	void SetGL(void);
	void GetGL(void);
};



inline Material::Material(void)
{
}

inline Material::Material(const lib_graph::Material& mat)
{
	dynamic_cast<lib_graph::Material&>(*this) = mat;
}

inline const Material& Material::operator=(const lib_graph::Material& mat)
{
	dynamic_cast<lib_graph::Material&>(*this) = mat;
	return *this;
}

//! w肵ʂɃ}eAKp
inline void Material::SetGL( GLenum face_type , bool set_diffuse_to_color )
{
	MaterialSetter::SetGL( *this , face_type , set_diffuse_to_color );
}

//! OpenGL̃Jg}eA擾.
//! GL_FRONT_AND_BACK͎擾łȂ̂Œ
inline void Material::GetGL( GLenum face_type )
{
	MaterialSetter::GetGL( *this , face_type );
}



inline DoublesideMaterial::DoublesideMaterial(void)
{
}

inline DoublesideMaterial::DoublesideMaterial(const lib_graph::DoublesideMaterial& mat)
{
	dynamic_cast<lib_graph::DoublesideMaterial&>(*this) = mat;
}

inline const DoublesideMaterial& DoublesideMaterial::operator=(const lib_graph::DoublesideMaterial& mat)
{
	dynamic_cast<lib_graph::DoublesideMaterial&>(*this) = mat;
	return *this;
}

//! w肵ʃ}eAKp
inline void DoublesideMaterial::SetGL(void)
{
	MaterialSetter::SetGL( *this );
}

//! OpenGL̃Jg}eA𗼖ʃ}eAIuWFNgɎ擾.
inline void DoublesideMaterial::GetGL(void)
{
	MaterialSetter::GetGL( *this );
}


}
