#include "StdAfx.h"
#include "QGui.h"

#include <fstream>

#include <QString>
#include <QDir>
#include <QUrl>
#include <QDesktopServices>



void QGui::ShowDirectory(const QString& path)
{
	QString p = QDir::toNativeSeparators(path);

	if(p.length() >= 2 && p[0] == '\\' && p[1] == '\\')
	{
		QDesktopServices::openUrl(p);
	}
	else
	{
		QUrl lu = QUrl::fromLocalFile(p);
		QDesktopServices::openUrl(lu);
	}
}


//! EBhẼCAEgVACY
bool QGui::SaveGUIState(QMainWindow* window, const QString& filename)
{
	QByteArray ba = window->saveState();
	std::ofstream ofs( filename.toLocal8Bit().data() , std::ios::binary );
	if( !ofs.is_open() )
		return false;

	ofs.write( ba.data() , ba.size() );

	return true;
}

//! EBhẼCAEgfVACY
bool QGui::LoadGUIState(QMainWindow* window, const QString& filename)
{
	std::ifstream ifs(filename.toLocal8Bit().data(), std::ios::binary);
	if( !ifs.is_open() )
		return false;

	ifs.seekg( 0 , std::ios::end );
	std::fstream::pos_type pos_end = ifs.tellg();

	ifs.seekg( 0 , std::ios::beg );
	std::fstream::pos_type pos_beg = ifs.tellg();

	size_t stream_size = pos_end - pos_beg;

	QByteArray ba( stream_size , 0 );
	ifs.read( ba.data() , stream_size );

	if( !window->restoreState( ba ) )
		return false;

	return true;
}
