#include "StdAfx.h"
#include "DepthColorShader.h"

#include <C2/util/stream_util.h>


DepthColorShader::DepthColorShader(ShaderContext* context) :
	ShaderInterface(context)
{
}

bool DepthColorShader::Initialize(const std::string& shader_libdir)
{
	lib_gl::GlslShader vert;
	if( !vert.CreateFromFile( GL_VERTEX_SHADER , (shader_libdir + "depth_shader.vert").c_str() ) )
		return false;

	lib_gl::GlslShader frag;
	if( !frag.CreateFromFile( GL_FRAGMENT_SHADER , (shader_libdir + "depth_shader.frag").c_str() ) )
		return false;

	if( !m_Program.Create( vert , frag ) )
		return false;

	return true;
}

void DepthColorShader::Release(void)
{
	m_Program.Release();
}

void DepthColorShader::BeginShader(void)
{
	m_Program.BeginShader();
}

void DepthColorShader::EndShader(void)
{
	m_Program.EndShader();
}

