/* Matroska.h */
/* 2009/05/25 */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

struct QM_TrackVideo {

	INT32  PixelWidth;
	INT32  PixelHeight;
	DOUBLE FrameRate;

}; /* QM_TrackVideo */

typedef struct QM_TrackVideo QM_TrackVideo_t;

struct QM_TrackAudio {

	DOUBLE SamplingFrequency;
	INT32  Channels;
	INT32  BitDepth;

}; /* QM_TrackAudio */

typedef struct QM_TrackAudio QM_TrackAudio_t;

struct QM_Track {

	INT32 TrackNo;
	INT32 TrackType;
	INT32 TrackLacing;

	const char* CodecId;

	INT64 TrackDuration;

	const QM_TrackVideo_t* Video;
	const QM_TrackAudio_t* Audio;

	const VOID* CodecPrivate;
	INT32       CodecPrivateSize;

}; /* QM_Track */

typedef struct QM_Track QM_Track_t;

/* */

struct QM_QuePoint {

	INT64 CueTime;

	INT32 TrackNo;
	INT64 ClusterPos;

}; /* QM_QuePoint */

typedef struct QM_QuePoint QM_QuePoint_t;

/* */

#define QM_FLAGS_KEYFRAME 0x80

struct QM_Block {

	INT64 ClusterTime;

	INT32 Duration;
	INT32 Reference;

	INT32 TrackNo;
	INT32 TimeDelta;

	INT32 Flags;

	const VOID* Payload;
	INT32       Size;

}; /* QM_Block */

typedef struct QM_Block QM_Block_t;

/* */

struct QM_Frame {

	const VOID* Payload;
	INT32       Size;

}; /* QM_Frame */

typedef struct QM_Frame QM_Frame_t;

/* */

struct QM_Reader;

typedef struct QM_Reader QM_Reader_t;

QM_Reader_t* QM_CreateReader(void);

void QM_ReleaseReader(QM_Reader_t* t);

BOOL QM_OpenReader(
	QM_Reader_t* t,
	const WCHAR* path);

BOOL QM_OpenReader_IStream(
	QM_Reader_t* t,
	IStream*     p);

INT64 QM_GetTimeCodeScale(
	QM_Reader_t* t);

DOUBLE QM_GetDuraion(
	QM_Reader_t* t);

INT32 QM_GetTrackCount(
	QM_Reader_t* t);

const QM_Track_t* QM_GetTracks(
	QM_Reader_t* t);

INT32 QM_ReadBlock(
	QM_Reader_t* t,
	QM_Block_t*  block);

BOOL QM_SeekCluster(
	QM_Reader_t* t,
	INT64        pos);

/* */

struct QM_FrameExtractor;

typedef struct QM_FrameExtractor QM_FrameExtractor_t;

QM_FrameExtractor_t* QM_CreateFrameExtractor(void);

void QM_ReleaseFrameExtractor(QM_FrameExtractor_t* t);

BOOL QM_DecodeLacingBlock(
	QM_FrameExtractor_t* t,
	const QM_Block_t*    block);

INT32 QM_ReadFrame(
	QM_FrameExtractor_t* t,
	QM_Frame_t*          frame);

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

