/* BitReader.c */
/* 2009/06/26  */

#include "StdAfx.h"

#include "BitReader.h"

/* */

#pragma warning(disable : 4799)

/* */

void QT_BitReader_C_Initialize(
	BitReader_C_t* t,
	const VOID*    p,
	SIZE_T         size)
{
	t->Cache = 0;

	t->Count = 16;

	t->p   = (const UINT8*)p;
	t->end = t->p + size;
}

/* */

void QT_BitReader_X86_Initialize(
	BitReader_X86_t* t,
	const VOID*      p,
	SIZE_T           size)
{
	t->Cache = 0;

	t->Count = 32;

	t->p   = (const UINT8*)p;
	t->end = t->p + size;
}

/* */

void QT_BitReader_MMX_Initialize(
	BitReader_MMX_t* t,
	const VOID*      p,
	SIZE_T           size)
{
	t->Cache = _mm_setzero_si64();

	t->Count = 32;

	t->p   = (const UINT8*)p;
	t->end = t->p + size;
}

/* */

