/* FrameDecoder.h */
/* 2009/06/29     */

#pragma once

#include "BitReader.h"

#include "MemoryPool.h"

#include "BlockIndex.h"

#include "SetupDecoder.h"

/* QT_FrameHeader */
struct QT_FrameHeader {

	UINT8 Type;

	UINT8 NQIS;
	UINT8 QIS[3];

}; /* QT_FrameHeader */

typedef struct QT_FrameHeader FrameHeader_t;

/* DequantizeMatrix */
struct DequantizeMatrix {

	INT16 Matrix[2][3][64];

}; /* DequantizeMatrix */

typedef struct DequantizeMatrix DequantizeMatrix_t;

/* LoopFilter */
struct LoopFilter {

	INT16 Delta[0x100];

	INT32 Limit;

}; /* LoopFilter */

typedef struct LoopFilter LoopFilter_t;

/* Plane */
struct Plane {

	UINT8* Plane;
	INT32  Pitch;
	INT32  CX;
	INT32  CY;

}; /* Plane */

typedef struct Plane Plane_t;

/* RunLength */
struct RunLength {

	INT32 Bit;
	INT32 Run;

}; /* RunLength */

typedef struct RunLength RunLength_t;

/* MotionVector */
struct MotionVector {

	INT8 X;
	INT8 Y;

}; /* MotionVector */

typedef struct MotionVector MotionVector_t;

/* FrameReconstructor_SSE2 */
struct FrameReconstructor_SSE2 {

	INT16 Matrix[3][2][3][64];

}; /* FrameReconstructor_SSE2 */

typedef struct FrameReconstructor_SSE2 FrameReconstructor_SSE2_t;

/* QT_FrameDecoder */

struct QT_FrameDecoder;

typedef struct QT_FrameDecoder FrameDecoder_t;

struct QT_FrameDecoder {

	const BlockIndex_t* Index;

	const SetupHeader_t* Setup;

	Plane_t  Plane[9];
	Plane_t* Frame[3];

	FrameHeader_t Header;

	DequantizeMatrix_t Dequantize[3];

	FrameReconstructor_SSE2_t* Reconstructor;

	LoopFilter_t Filter;

	INT32 QIndex[3];
	INT32 QCount;

	INT8* SBCoded;

	UINT8* BCoded;

	UINT8* BQI;

	UINT8* MBMode;

	UINT8* BMode;

	MotionVector_t* MV;

	MotionVector_t* MVC;

	INT32 BlocksCoded[3];

	INT8*  DCTRun;
	INT16* DCTCoeff;

	INT16* DC;

	/* */

	INT8*  BRun  [3][64];
	INT16* BCoeff[3][64];

	/* */

	BOOL (*Decode)(FrameDecoder_t*, const VOID*, SIZE_T);

	VOID (*UpdateDequantizeMatrix)(FrameDecoder_t*);

	VOID (*Reconstruct)(FrameDecoder_t*);

}; /* QT_FrameDecoder */

/* */

#define NOT_CODED -32768

/* */

BOOL QT_FrameDecoder_Setup(
	FrameDecoder_t*      t,
	const BlockIndex_t*  index,
	const SetupHeader_t* setup,
	MemoryPool_t*        pool);

BOOL QT_FrameDecoder_DecodeFrame(
	FrameDecoder_t* t,
	const VOID*     p,
	SIZE_T          size);

/* */

