/* SetupDecoder.c */
/* 2009/06/26     */

#include "StdAfx.h"

#include "SetupDecoder.h"

/* */

#pragma warning(disable : 4799)

/* */

static INT32 ilog(UINT32 n)
{
	static const INT32 LOG2_4[16] = { 0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4 };

	if (n < (1U << 14)) {
		if      (n < (1U <<  4)) return  0 + LOG2_4[n      ];
		else if (n < (1U <<  9)) return  5 + LOG2_4[n >>  5];
		else                     return 10 + LOG2_4[n >> 10];

	} else if (n < (1U << 24)) {
		if (n < (1U << 19))      return 15 + LOG2_4[n >> 15];
		else                     return 20 + LOG2_4[n >> 20];

	} else if (n < (1U << 29)) {
		return 25 + LOG2_4[n >> 25];

	} else if (n < (1U << 31)) {
		return 30 + LOG2_4[n >> 30];
	}

	return 0;
}

/* */

/* HuffmanEntry */
struct HuffmanEntry {

	UINT32 Code;
	UINT8  Length;
	UINT8  Token;

}; /* HuffmanEntry */

typedef struct HuffmanEntry HuffmanEntry_t;

static int compare(const void* a, const void* b)
{
	const HuffmanEntry_t* aa = (const HuffmanEntry_t*)a;
	const HuffmanEntry_t* bb = (const HuffmanEntry_t*)b;

	if (aa->Length < bb->Length) {
		return -1;
	}
	if (aa->Length > bb->Length) {
		return 1;
	}

	if (aa->Code < bb->Code) {
		return -1;
	}
	if (aa->Code > bb->Code) {
		return 1;
	}

	return 0;
}

static void Huffman_MakeDecoder(
	HuffmanDecoder_t*     d,
	const HuffmanTable_t* t)
{
	HuffmanEntry_t entries[HUFFMAN_SIZE];

	INT32 i, p, max;
	const HuffmanEntry_t* e;

	d->LookupBits   = 0;
	d->LookupToken  = NULL;
	d->LookupLength = NULL;

	for (i = 0; i < HUFFMAN_SIZE; i++) {
		entries[i].Code   = t->Code[i];
		entries[i].Length = t->Length[i];
		entries[i].Token  = t->Index[i];
	}

	qsort(
		entries,
		HUFFMAN_SIZE,
		sizeof(HuffmanEntry_t),
		compare);

	max = 0;

	p = 0;
	e = entries;
	for (i = 0; i < BITS_COUNT; i++) {
		INT32 len = i + 1;

		INT32 idx = p;

		while (e->Length == len && p < HUFFMAN_SIZE) {
			d->Code [p] = e->Code;
			d->Token[p] = e->Token;

			p++;
			e++;
		}

		if (p - idx > 0) {
			max = len;
			d->Index[i] = idx;
		} else {
			d->Index[i] = -1;
		}

		d->Count[i] = p - idx;
	}

	for (i = max; i < BITS_COUNT; i++) {
		d->Index[i] = -1;
		d->Count[i] = -1;
	}
}

static BOOL Huffman_MakeLookupTable(
	HuffmanDecoder_t*     d,
	const HuffmanTable_t* t,
	MemoryPool_t*         pool,
	INT32                 bits)
{
	INT32 i;

	UINT32 size = 1 << bits;

	d->LookupBits = bits;

	d->LookupToken  = (INT8*)QT_MemoryPool_Allocate(pool, sizeof(INT) * size);
	d->LookupLength = (INT8*)QT_MemoryPool_Allocate(pool, sizeof(INT) * size);

	if (d->LookupToken == NULL || d->LookupLength == NULL) {
		return FALSE;
	}

	memset(d->LookupToken,  0, size);
	memset(d->LookupLength, 0, size);

	for (i = 0; i < HUFFMAN_SIZE; i++) {
		if (t->Length[i] <= bits) {
			INT32 s = bits - t->Length[i];
			INT32 n = 1 << s;

			UINT32 base = t->Code[i] << s;

			INT32 j;
			for (j = 0; j < n; j++) {
				UINT32 idx = base + j;
				d->LookupToken [idx] = t->Index[i];
				d->LookupLength[idx] = t->Length[i];
			}
		}
	}

	return TRUE;
}

/* */

#define ARCH_C

#include "QTheoraArch.h"

#define IdentifyHeader_Decode IdentifyHeader_Decode_C
#define Filter_Decode         Filter_Decode_C
#define Dequantize_Decode     Dequantize_Decode_C
#define Huffman_Decode        Huffman_Decode_C
#define SetupHeader_Decode    SetupHeader_Decode_C

#define QT_SetupDecoderSetupLacing QT_SetupDecoderSetupLacing_C

#include "SetupDecoder_Impl.h"

#undef ARCH_C

/* */

#define ARCH_X86

#include "QTheoraArch.h"

#define IdentifyHeader_Decode IdentifyHeader_Decode_X86
#define Filter_Decode         Filter_Decode_X86
#define Dequantize_Decode     Dequantize_Decode_X86
#define Huffman_Decode        Huffman_Decode_X86
#define SetupHeader_Decode    SetupHeader_Decode_X86

#define QT_SetupDecoderSetupLacing QT_SetupDecoderSetupLacing_X86

#include "SetupDecoder_Impl.h"

#undef ARCH_X86

/* */

#define ARCH_MMX

#include "QTheoraArch.h"

#define IdentifyHeader_Decode IdentifyHeader_Decode_MMX
#define Filter_Decode         Filter_Decode_MMX
#define Dequantize_Decode     Dequantize_Decode_MMX
#define Huffman_Decode        Huffman_Decode_MMX
#define SetupHeader_Decode    SetupHeader_Decode_MMX

#define QT_SetupDecoderSetupLacing QT_SetupDecoderSetupLacing_MMX

#include "SetupDecoder_Impl.h"

#undef ARCH_MMX

/* */

