/* SetupDecoder_Impl.h */
/* 2009/06/26          */

/* */

static BOOL IdentifyHeader_Decode(
	IdentifyHeader_t* t,
	BitReader_t*      d)
{
	INITIATE_BITS

	INT32 hi, lo;

	FETCH_BITS_I(t->Version[0], 8)
	FETCH_BITS_I(t->Version[1], 8)
	FETCH_BITS_I(t->Version[2], 8)

	t->Version[3] = 0;

	if (t->Version[0] != 3 || t->Version[1] != 2) {
		return FALSE;
	}

	FETCH_BITS_I(t->MX, 16)
	FETCH_BITS_I(t->MY, 16)

	FETCH_BITS_I(hi,  8)
	FETCH_BITS_I(lo, 16)
	t->PCX = (hi << 16) | lo;

	FETCH_BITS_I(hi,  8)
	FETCH_BITS_I(lo, 16)
	t->PCY = (hi << 16) | lo;

	FETCH_BITS_I(t->PDX, 8)
	FETCH_BITS_I(t->PDY, 8)

	if (t->MX <= 0 || t->MY <= 0) {
		return FALSE;
	}

	if (t->PCX <= 0 || t->PCX > t->MX * 16) {
		return FALSE;
	}

	if (t->PCY <= 0 || t->PCY > t->MY * 16) {
		return FALSE;
	}

	if (t->PDX > t->MX * 16 - t->PCX) {
		return FALSE;
	}

	if (t->PDY > t->MY * 16 - t->PCY) {
		return FALSE;
	}

	FETCH_BITS_I(hi, 16)
	FETCH_BITS_I(lo, 16)
	t->FRN = (hi << 16) | lo;

	FETCH_BITS_I(hi, 16)
	FETCH_BITS_I(lo, 16)
	t->FRD = (hi << 16) | lo;

	if (t->FRN == 0 || t->FRD == 0) {
		return FALSE;
	}

	FETCH_BITS_I(hi,  8)
	FETCH_BITS_I(lo, 16)
	t->PRN = (hi << 16) | lo;

	FETCH_BITS_I(hi,  8)
	FETCH_BITS_I(lo, 16)
	t->PRD = (hi << 16) | lo;

	if ((t->PRN != 0 || t->PRD != 0) &&
		(t->PRN == 0 || t->PRD == 0)) {
		return FALSE;
	}

	FETCH_BITS_I(t->CS,  8)

	FETCH_BITS_I(hi,  8)
	FETCH_BITS_I(lo, 16)
	t->NOMBR = (hi << 16) | lo;

	FETCH_BITS_I(t->QUAL,     6)
	FETCH_BITS_I(t->KFGSHIFT, 5)
	FETCH_BITS_I(t->PF,       2)

	if (t->PF != 0) { /* 4:2:0 */
		return FALSE;
	}

	FETCH_BITS_I(lo, 3)
	if (lo != 0) {
		return FALSE;
	}

	FINALIZE_BITS

	if (REST_BITS < 0) {
		return FALSE;
	}

	return TRUE;
}

/* */

static BOOL Filter_Decode(
	FilterTable_t* t,
	BitReader_t*   d)
{
	INITIATE_BITS

	INT32 i, bits;

	FETCH_BITS_I(bits, 3)

	for (i = 0; i < 64; i++) {
		FETCH_BITS(t->Limit[i], bits)
	}

	FINALIZE_BITS

	if (REST_BITS < 0) {
		return FALSE;
	}

	return TRUE;
}

/* */

static BOOL Dequantize_Decode(
	DequantizeTable_t* t,
	BitReader_t*       d)
{
	INITIATE_BITS

	INT32 i, j, n;
	INT32 bits;

	/* */

	FETCH_BITS_I(bits, 4) bits++;
	for (i = 0; i < 64; i++) {
		FETCH_BITS(t->ACScale[i], bits)
	}

	FETCH_BITS_I(bits, 4) bits++;
	for (i = 0; i < 64; i++) {
		FETCH_BITS(t->DCScale[i], bits)
	}

	FETCH_BITS_I(n, 9) n++;
	if (n >= 384) {
		return FALSE;
	}

	for (j = 0; j < n; j++) {
		for (i = 0; i < 64; i++) {
			FETCH_BITS_I(t->Matrix[j][i], 8)
		}
	}

	/* */

	bits = ilog(n - 1);

	for (j = 0; j < 2; j++) {
		for (i = 0; i < 3; i++) {
			INT32 nq = 1;
			if (j > 0 || i > 0) {
				FETCH_BITS_I(nq, 1)
			}

			if (nq != 0) {
				INT32 qri = 0;
				INT32 qi  = 0;

				for (; ; ) {
					INT32 x, y;

					FETCH_BITS(x, bits)
					if (x >= n) {
						return FALSE;
					}

					t->Base[j][i][qri] = x;

					if (qi >= 63) {
						break;
					}

					y = ilog(63 - qi);

					FETCH_BITS(x, y) x++;

					t->Size[j][i][qri] = x;

					qri += 1;
					qi  += x;
				}

				if (qi >= 64) {
					return FALSE;
				}

				t->Count[j][i] = qri;

			} else {
				INT32 q, p;

				INT32 x = 0;
				if (j > 0) {
					FETCH_BITS_I(x, 1)
				}

				if (x != 0) {
					q = 0;
					p = i;
				} else {
					q = (3 * j + i - 1) / 3;
					p = (i + 2) % 3;
				}

				t->Count[j][i] = t->Count[q][p];
				memcpy(t->Size[j][i], t->Size[q][p], sizeof(t->Size[0][0]));
				memcpy(t->Base[j][i], t->Base[q][p], sizeof(t->Base[0][0]));
			}
		}
	}

	FINALIZE_BITS

	if (REST_BITS < 0) {
		return FALSE;
	}

	return TRUE;
}

/* */

static BOOL Huffman_Decode(
	HuffmanTable_t* t,
	BitReader_t*    d)
{
	INITIATE_BITS

	INT32 i = 0;

	UINT32 bits = 0;
	INT32  len  = 0;

	for (; ; ) {
		INT32 x;
		FETCH_BITS_I(x, 1)

		if (x == 0) {
			if (len >= 32) {
				return FALSE;
			}

			bits <<= 1;
			len   += 1;

		} else {
			if (i >= HUFFMAN_SIZE) {
				return FALSE;
			}

			t->Code  [i] = bits;
			t->Length[i] = len;

			FETCH_BITS_I(t->Index[i], 5);

			i++;

			for (; ; ) {
				if (len == 0) {
					if (i != HUFFMAN_SIZE) {
						return FALSE;
					}

					FINALIZE_BITS

					if (REST_BITS < 0) {
						return FALSE;
					}

					return TRUE;
				}

				if ((bits & 1) == 0) {
					bits |= 1;
					break;

				} else {
					bits >>= 1;
					len   -= 1;
				}
			}
		}
	}
}

/* */

static BOOL SetupHeader_Decode(
	SetupHeader_t* t,
	MemoryPool_t*  pool,
	BitReader_t*   d)
{
	INT32 i;

	if (!Filter_Decode(
		&(t->Filter),
		d)) {
		return FALSE;
	}

	if (!Dequantize_Decode(
		&(t->Dequantize),
		d)) {
		return FALSE;
	}

	for (i = 0; i < 80; i++) {
		HuffmanTable_t ht;
		HuffmanDecoder_t* hd = t->Huffman + i;

		if (!Huffman_Decode(&ht, d)) {
			return FALSE;
		}

		Huffman_MakeDecoder(hd, &ht);

		if (!Huffman_MakeLookupTable(
			hd,
			&ht,
			pool,
			10)) {
			return FALSE;
		}
	}

	if (REST_BITS < 0) {
		return FALSE;
	}

	return TRUE;
}

/* */

BOOL QT_SetupDecoderSetupLacing(
	IdentifyHeader_t* id,
	SetupHeader_t*    setup,
	MemoryPool_t*     pool,
	BitReader_t*      d)
{
	INITIATE_BITS

	static const char* ID = "theora";

	UINT8 by;
	INT32 i, j, p = 0;
	INT32 sz[3] = { 0 };

	INT32 size = d->end - d->p;

	FETCH_BITS_I(by, 8) p++;
	if (by != 2) {
		return FALSE;
	}

	for (i = 0; i < 2; i++) {
		for (; ; ) {
			FETCH_BITS_I(by, 8) p++;

			sz[i] += by;

			if (by != 0xff) {
				break;
			}
		}
	}

	sz[2] = (size - p) - (sz[0] + sz[1]);
	if (sz[2] <= 0) {
		return FALSE;
	}

	for (i = 0; i < 3; i++) {
		if (sz[i] < 7) {
			return FALSE;
		}

		FETCH_BITS_I(by, 8)
		if (by != 0x80 + i) {
			return FALSE;
		}

		for (j = 0; j < 6; j++) {
			FETCH_BITS_I(by, 8)
			if (by != ID[j]) {
				return FALSE;
			}
		}

		switch (i) {
		case 0: /* ID */
			FINALIZE_BITS

			if (!IdentifyHeader_Decode(
				id,
				d)) {
				return FALSE;
			}

			RESUME_BITS
			break;

		case 1: /* COMM */
			for (j = 0; j < sz[1] - 7; j++) {
				FETCH_BITS_I(by, 8)
			}
			break;

		case 2: /* SETUP */
			FINALIZE_BITS

			if (!SetupHeader_Decode(
				setup,
				pool,
				d)) {
				return FALSE;
			}

			RESUME_BITS
			break;
		}
	}

	FINALIZE_BITS

	if (REST_BITS >= 8) {
		return FALSE;
	}

	return TRUE;
}

/* */

#undef IdentifyHeader_Decode
#undef Filter_Decode
#undef Dequantize_Decode
#undef Huffman_Decode
#undef SetupHeader_Decode

#undef QT_SetupDecoderSetupLacing

/* */

