#!perl
package WWWFormParser;
use utf8;
use strict;
use warnings;
use Encode;
use Carp;
use Data::Dump;
require Exporter;
our $VERSION = "0.0.1";
our @ISA = qw(Exporter);
our @EXPORT = qw(printHTTPHeader exitError URIEscape URIUnescape readCookie setCookie parseForm );
our @EXPORT_OK = qw();


our $debug = 0;
our $now;
our @now;
our $html_header;
our $enc = Encode::find_encoding("utf8");
our $cookie_expire;
our $cookie_path;

sub init($){
	$cookie_path = $_[0];
	$now = time;
	@now = localtime($now); $now[5]+=1900;$now[4]+=1;
	$html_header=1;
	# make cookie_expire
	{
		my @e = gmtime($now + 180*86400 ); $e[5]+=1900;$e[4]+=1;
		$cookie_expire=sprintf( 
			"expires=%s, %02d-%s-%d %02d:%02d:%02d GMT"
			,(qw(Sun Mon Tue Wed Thu Fri Sat))[$e[6]]
			,$e[3],(qw(0 Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec))[$e[4]],$e[5]
			,reverse @e[0..2]
		);
	}
}

sub printHTTPHeader(){
	return if not $html_header;
	print qq(Content-type: text/html; charset=UTF-8\x0d\x0a);
	print qq(\x0d\x0a);
	undef $html_header;
}

sub exitError{
	printHTTPHeader();
	print "<h3>Error:</h3>";
	for(@_){
		local $_=$_;
		s/\&/\&amp;/g;
		s/\</\&lt;/g;
		s/\>/\&gt;/g;
		s/\"/\&quot;/g;
		s/ /\&nbsp;/g;
		s/\n/<br>/g;
		print "<div>$_</div>\n";
	}
	exit;
}

sub URIEscape($){
	my $str = shift;
	utf8::is_utf8($str) and $str = Encode::encode($enc,$str);
	$str =~ s/([^\w\d\_\:\/\-\ .])/'%' . unpack('H2', $1)/eg;
	$str =~ tr/ /+/;
	return $str;
}
sub URIUnescape($){
	my $str = shift;
	$str =~ tr/+/ /;
	$str =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;
	$str = Encode::decode($enc,$str);
	return $str;
}

#############################
# get/set cookie

sub readCookie(){
	my $cookie = {};
	for(split /\s*;\s*/,($ENV{'HTTP_COOKIE'}||'')){
		my($n,$v)=map{URIUnescape($_)} split /=/,$_,2;
		next if not defined $n;
		$cookie->{$n}=$v;
	}
	return $cookie;
}

# クッキー書き込み
sub setCookie($$$;$){
	my ($map,$n,$v,$session_only)=@_;
	$map->{$n}=$v;

	my @h;
	push @h,"$n=".URIEscape($v);
	push @h,"domain=".$ENV{HTTP_HOST};
	push @h,"path=".$cookie_path;
	$session_only or push @h,$cookie_expire;
	$n = join'; ',@h;
	print "Set-Cookie: $n\x0d\x0a";
}

#################################################
# parse application/x-www-form-urlencoded
sub _readUrlencoded($$){
	my($result,$data)=@_;
	for( split /&/,$$data ){
		my($n,$v) = map{
			tr/+/ /;
			s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
			$_;
		} split /=/,$_,2;
		$result->{Encode::decode($enc,$n)} = Encode::decode($enc,$v);
	}
}

# multipart/form-dataを解釈する
sub _readMultipart($$){
	my($result,$rtext)=@_;

	$$rtext =~ /^([^\x00-\x20]+)/ or die "cannot find boundary";
	my $boundary = $1;

	# scan boundary
	my @pos ;
	{
		my $start = 0;
		while( $$rtext =~ /$boundary/g ){
			if($start>0){
				push @pos,[$start,$-[0]-2];
			}
			$start = $+[0]+2;
		}
	}
	for(@pos){
		my($start,$end)=@$_;
		# find end of part header
		my $head_end = index($$rtext,"\x0d\x0a\x0d\x0a",$start);
		if( $head_end !=-1 and $head_end < $end ){
			my @Headers = grep{length} split /\x0d\x0a/,substr($$rtext,$start,$head_end-$start);
			my $body = substr($$rtext,$head_end+4,($end)-($head_end+4));
			my $name;
			my $filename;
			my $ctype;
			for(@Headers){
				if( /Content-Disposition:\s*([^;\s]+)(.*)/ ){
					my ($type,$extra)=($1,$2);
					for(split /\s*;\s*/,$extra){
						next if not length;
						if( /^name="([^"]+)"/ ){
							$name = $1;
						}elsif( /filename="([^"]+)"/ ){
							$filename = $1;
						}
					}
				}elsif( /Content-Type:\s*([^;\s]+)/ ){
					$ctype = $1;
				}
			}
			my $item;
			if( defined $filename ){
				# ベースネームを得る
				$filename =~ /([^\\\/]+)$/  and $filename = $1;
				$result->{Encode::decode($enc,$name)} = {
					'Name'=>$filename,
					'Data'=>\$body,
					'Size'=>length($body),
					'Headers'=>\@Headers,
				};
			}else{
				$result->{Encode::decode($enc,$name)} = Encode::decode($enc,$body);
			}
		}
	}
}

sub parseForm($){
	my($maxdatasize)=@_;
	$maxdatasize ||= 20000;
	my $result = {};

	# read parameter from URL
	my $data = ($ENV{'QUERY_STRING'}||'');
	length($data) and _readUrlencoded($result,\$data);

	if( $ENV{'REQUEST_METHOD'} =~/^POST$/i ){
		# check size of content
		my $left = $ENV{'CONTENT_LENGTH'};
		$left or die "missing content length.\n";
		$left > $maxdatasize and die "too long content length. must be <=$maxdatasize.\n";
		# read content
		binmode(STDIN);
		$data="";
		while($left>0){
			my $delta = read(STDIN,$data,$left,length($data));
			defined($data) or die "read error: $!\n";
			$data or die "read error: unexpected end of content\n";
			$left -= $delta;
		}
		if( $ENV{'CONTENT_TYPE'} =~ m{^multipart/form-data}i ){
			_readMultipart($result,\$data);
		}else{
			_readUrlencoded($result,\$data);
		}
	}
	return $result;
}

#############################################################################


1;
