//----------------------------------------------------------------------
//
//			File:			"ViEditView.cpp"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	r[NX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifdef	WIN32
#include <windows.h>
#endif	//	WIN32
#include <QtGui>
#include "vi.h"
#include "ViEditView.h"
//#include "ViEngine.h"
#include "viCursor.h"
#include <QElapsedTimer>
#include <QDebug>

ViEditView::ViEditView(QWidget *parent)
	: m_mode(CMD), QPlainTextEdit(parent)
{
	m_timer = new QElapsedTimer;
	m_timer->start();
	m_drawText = true;
	m_curNthLine = 0;
#if !USE_EVENT_FILTER
	m_viEngine = 0;
#endif
	connect(this, SIGNAL(cursorPositionChanged()), this, SLOT(onCursorPositionChanged()));
	m_lineNumberArea = new QWidget(this);
	m_lineNumberArea->installEventFilter(this);
	//onLineNumberAreaWidthChanged();
	setFontPointSize(11);
	onFontChanged();
	//setCursorWidth(0);				//	QPlainTextEdit pӂĂJ[\͔\
	onCursorPositionChanged();
}

ViEditView::~ViEditView()
{
}
ViCursor ViEditView::viCursor() const
{
	return ViCursor(textCursor(), m_curNthLine);
}
void ViEditView::setViCursor(const ViCursor &cur)
{
	setTextCursor(cur);
	m_curNthLine = cur.nthLine();
}
void ViEditView::setDrawText(bool b)
{
	m_drawText = b;
	repaint();
}
void ViEditView::focusInEvent ( QFocusEvent * event )
{
	QPlainTextEdit::focusInEvent ( event );
	if( mode() == CMDLINE )
		emit setFocusToCmdLine();
}
#if 0
void ViEditView::mousePressEvent ( QKeyEvent * event )
{
}
#endif
#if !USE_EVENT_FILTER
void ViEditView::keyPressEvent ( QKeyEvent * event )
{
	if( m_viEngine != 0 && m_viEngine->processKeyPressEvent(event) )
		return;
	QPlainTextEdit::keyPressEvent(event);
}
#endif
void ViEditView::resetCursorBlinkTimer()
{
	m_tickCount = m_timer->elapsed();
}
void ViEditView::setMode(Mode mode)
{
	resetCursorBlinkTimer();
	if( mode != m_mode ) {
		m_mode = mode;
		emit modeChanged(mode);
		onCursorPositionChanged();
		viewport()->update();
	}
}

void ViEditView::onFontChanged()
{
	setTabStopWidth(fontMetrics().width('>') * 4);		//	tab 4
	m_lineNumberWidth = fontMetrics().width('8') * 6;
	m_lineNumberAreaWidth = fontMetrics().width('8') * 8;
	setViewportMargins(m_lineNumberAreaWidth, 0, 0, 0);
	updateLineNumberAreaSize();
}
void ViEditView::onCursorPositionChanged()
{
	resetCursorBlinkTimer();
	if( mode() == CMD || mode() == REPLACE ) {
		QTextCursor cur = textCursor();
		cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor);
		QString text = cur.selectedText();
		QChar ch = text.isEmpty() ? QChar(' ') : text[0];
		m_cursorWidth = fontMetrics().width(ch);
		if( !m_cursorWidth )
			m_cursorWidth = fontMetrics().width(QChar(' '));
		//m_cursorWidth = wd;
	} else {
		m_cursorWidth = 1;
	}
	setCursorWidth(m_cursorWidth);
}
void ViEditView::doUndo(int n)
{
	for(int i = 0; i < n; ++i)
		undo();
	viewport()->update();
}
void ViEditView::doRedo(int n)
{
	for(int i = 0; i < n; ++i)
		redo();
	viewport()->update();
}
void ViEditView::doDelete(int from, int to)
{
	QTextCursor cur = textCursor();
	cur.setPosition(from);
	cur.setPosition(to, QTextCursor::KeepAnchor);
	cur.deleteChar();
}
#if 0
//	J[\ʒun폜is𒴂č폜͍sȂj
void ViEditView::doDelete(int n)
{
	QTextCursor cur = textCursor();
	if( !cur.hasSelection() ) {
		const int pos = cur.position();
		int dst;
		if( n > 0 ) {
			cur.movePosition(QTextCursor::EndOfBlock);
			const int endpos = cur.position();
			if( pos == endpos ) return;		//	s x ł͍폜Ȃ
			dst = qMin(pos + n, endpos);	//	n ړ or sʒu
			cur.setPosition(pos);		//	J[\ʒuֈړ
		} else {
			const int blockPos = cur.block().position();
			if( pos == blockPos ) return;	//	sO X ł͍폜Ȃ
			dst = qMax(pos + n, blockPos);	//	n ړ or sʒu
		}
		cur.setPosition(dst, QTextCursor::KeepAnchor);		//	J[\ʒun or sO܂őI
	}
	cur.deleteChar();
#if 0
		for(int i = 0; i < n; ++i)
			cur.deleteChar();
#endif
}
#endif
//	J[\s̒ or Oɋs
void ViEditView::doOpenLine(bool next)
{
	QTextCursor cur = textCursor();
	bool EOFLine = false;
	if( next ) {
		//	done B łȂEOFs̏ꍇɑΉ
		if( cur.block() == cur.document()->lastBlock() ) {
			EOFLine = true;
			cur.movePosition(QTextCursor::EndOfBlock);
		} else {
			cur.movePosition(QTextCursor::NextBlock);
			cur.movePosition(QTextCursor::StartOfBlock);
		}
	} else
		cur.movePosition(QTextCursor::StartOfBlock);
	cur.insertText("\n");
	if( !EOFLine )
		cur.movePosition(QTextCursor::Left);
	setTextCursor(cur);
}
#if 0
//	siCR/LF/CRLFjʒuԂ
int EOLOffset(const QString &text)
{
	int ix = text.length();
	if( ix != 0 ) {
		if( text[ix-1] == 0x0d )
			--ix;
		if( text[ix-1] == 0x0a ) {
			if( ix > 1 && text[ix-2] == 0x0d )
				ix -= 2;
			else
				--ix;
		}
	}
	return ix;
}
inline bool isTabOrSpace(const QChar ch)
{
	return ch == '\t' || ch == ' ';
}
int firstNonBlackCharPos(const QString &text)
{
	int ix = 0;
	while( ix < text.length() && isTabOrSpace(text[ix]) )
		++ix;
	return ix;
}
void moveToFirstNonBlackChar(QTextCursor &cur)
{
	QTextBlock block = cur.block();
	const int blockPos = block.position();
	const QString blockText = block.text();
	if( !blockText.isEmpty() )
		cur.setPosition(blockPos + firstNonBlackCharPos(blockText));
}
void ViEditView::moveCursor(int mv, int n)
{
	resetCursorBlinkTimer();
	QTextCursor cur = textCursor();
	const int pos = cur.position();
	QTextBlock block = cur.block();
	const int blockPos = block.position();
	const QString blockText = block.text();
	bool moved = false;
	switch( mv ) {
	case ViMoveOperation::Up:
		mv = QTextCursor::Up;
		break;
	case ViMoveOperation::Down:
		mv = QTextCursor::Down;
		break;
	case ViMoveOperation::Left:
		n = qMin(n, pos - blockPos);
		mv = QTextCursor::Left;
		break;
	case ViMoveOperation::Right: {
		if( blockText.isEmpty() ) return;		//	EOF I[s̏ꍇ
		const int endpos = blockPos + EOLOffset(blockText) - 1;
		if( pos >= endpos ) return;
		n = qMin(n, endpos - pos);
		mv = QTextCursor::Right;
		break;
	}
	case ViMoveOperation::RightForA:			//	Eړ for a R}h
		if( blockText.isEmpty() ) return;		//	EOF I[s̏ꍇ
		if( pos >= blockPos + EOLOffset(blockText)) return;
		cur.setPosition(pos + 1);
		moved = true;
		break;
	case ViMoveOperation::FirstNonBlankChar:
		cur.setPosition(blockPos + firstNonBlackCharPos(blockText));
		moved = true;
		break;
	case ViMoveOperation::LastChar: {
		int ix = EOLOffset(blockText);
		if( ix != 0 ) --ix;
		cur.setPosition(blockPos + ix);
		moved = true;
		break;
	}
	case ViMoveOperation::NextLine:
		cur.movePosition(QTextCursor::NextBlock, QTextCursor::MoveAnchor, n);
		moveToFirstNonBlackChar(cur);
		moved = true;
		break;
	case ViMoveOperation::PrevLine:
		cur.movePosition(QTextCursor::PreviousBlock, QTextCursor::MoveAnchor, n);
		moveToFirstNonBlackChar(cur);
		moved = true;
		break;
	}
	if( !moved )
		cur.movePosition(static_cast<QTextCursor::MoveOperation>(mv), QTextCursor::MoveAnchor, n);
#if 0
	const int vx = cur.verticalMovementX();
	if( mv == QTextCursor::Up || mv == QTextCursor::Down ) {
		QTextBlock block = cur.block();
		const int blockPos = block.position();
		const QString text = block.text();
		if( !text.isEmpty() ) {
			const int endpos = blockPos + EOLOffset(text) - 1;
			if( cur.position() > endpos )
				cur.setPosition(endpos);
		}
	}
#endif
	setTextCursor(cur);
	//cur.setVerticalMovementX(vx);
}
#endif
#if 0
int ViEditView::lineNumberAreaWidth() const
{
	return 32;
}
void ViEditView::onLineNumberAreaWidthChanged()
{
	setViewportMargins(lineNumberAreaWidth(), 0, 0, 0);
}
void ViEditView::lineNumberAreaPaintEvent(QPaintEvent * event)
{
}
#endif
void ViEditView::makeFontBigger(bool bigger)
{
	int sz = font().pointSize();
	if( bigger )
		++sz;
	else if( !--sz ) return;
	setFontPointSize(sz);
}
void ViEditView::setFontPointSize(int sz)
{
	QFont ft = font();
	ft.setPointSize(sz);
	setFont(ft);
	onFontChanged();
	//emit showMessage(QString(tr("fontSize:%1").arg(sz)));
}
void ViEditView::setFontFamily(const QString &name)
{
	QFont ft = font();
	ft.setFamily(name);
	setFont(ft);
	onFontChanged();
	//emit showMessage(QString(tr("fontSize:%1").arg(sz)));
}
void ViEditView::wheelEvent ( QWheelEvent * event )
{
	Qt::KeyboardModifiers mod = event->modifiers ();
	if( (mod & Qt::ControlModifier) != 0 ) {
		makeFontBigger(event->delta() > 0);
	} else
		QPlainTextEdit::wheelEvent(event);
}
void ViEditView::updateLineNumberAreaSize()
{
	//QRect r = contentsRect();
	QRect r = rect();
	m_lineNumberArea->setGeometry(QRect(r.left(), r.top(), m_lineNumberAreaWidth, r.height()));
}
void ViEditView::resizeEvent(QResizeEvent *event)
{
	QPlainTextEdit::resizeEvent(event);
	updateLineNumberAreaSize();
}
bool ViEditView::eventFilter(QObject *obj, QEvent *event)
{
	if( obj == m_lineNumberArea && event->type() == QEvent::Paint ) {
		drawLineNumbers();
		return true;
	}
	return false;
}

void ViEditView::drawLineNumbers()
{
	//qDebug() << "drawLineNumbers()";
	QPainter painter(m_lineNumberArea);
	painter.setPen(Qt::black);
	QRect ar = m_lineNumberArea->rect();
	painter.fillRect(ar, Qt::lightGray);
#if 0
	painter.drawLine(0, 0, 10, 100);
	painter.drawText(10, 10, "hello");
#endif
#if 1
	//const int ht = fontMetrics().height();
	QTextCursor cur = textCursor();
	QTextBlock block = firstVisibleBlock();
    int lineNumber = block.blockNumber() + 1;
	while( block.isValid() ) {
		cur.setPosition(block.position());
		QRect r = cursorRect(cur);
		int y = r.bottom();
	    //const int y = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
	    //if( y >= ar.bottom() ) break;
		QString number = QString::number(lineNumber);
		painter.drawText(0, r.top(), m_lineNumberWidth, r.height(), Qt::AlignRight, number);
	    if( y >= ar.bottom() ) break;
		++lineNumber;
		block = block.next();
	}
#endif
}

#if 1
void ViEditView::paintEvent(QPaintEvent * event)
{
	//qDebug() << "event->rect() = " << event->rect();
#if 0
	static int cnt = 0;
	static int color = Qt::darkGray;
	QPainter painter(this);
	painter.fillRect(event->rect(), color);
	if( ++color == Qt::transparent ) color = Qt::darkGray;
#endif
	//qDebug() << "ViEditView::paintEvent() " << ++cnt;
#if 1	//DRAW_CURSOR

	if( mode() != CMDLINE ) {
		const int blinkPeriod = 1200;	//	_ŎAPʁFms
		qint64 tc = m_timer->elapsed() - m_tickCount;
		if( tc % blinkPeriod < blinkPeriod / 2 )
			drawCursor();
	}
	//const bool ro = isReadOnly();
	//setReadOnly(true);		//	J[\`֎~ɂ邽
	//setReadOnly(ro);
#endif
	///if( !m_drawText ) return;

#if 1

	drawNewLineEOF();

	///setCursorWidth(0);
	//QPlainTextEdit::paintEvent(event);
	///setCursorWidth(m_cursorWidth);

#if 0
	QTextCursor cur = textCursor();
	cur.movePosition(QTextCursor::End);
	QRect r = cursorRect(cur);
	QPainter painter(viewport());
	painter.setPen(Qt::blue);
	painter.drawText(QPointF(r.left(), r.bottom()), "[EOF]");
#endif

#else
	QPainter painter(viewport());
	//QPainter painter(this);
#if 0
	painter.fillRect(event->rect(), Qt::lightGray);
	QRect viewportRect = viewport()->rect();
	QRect r = rect();
	painter.setPen(Qt::black);
	painter.drawLine(r.x(), r.y(), r.x() + r.width(), r.y() + r.height());
	painter.drawText(10, 10, "hello");
#endif
#endif
#if 1
    QPointF offset(contentOffset());
	QPainter painter(viewport());
	QTextCursor cur = textCursor();
	QTextBlock block = firstVisibleBlock();
	QRect vr = rect();
	//int top = (int) blockBoundingGeometry(block).translated(contentOffset()).top();
	//int bottom = top + (int) blockBoundingRect(block).height();
	//int x = 0;
	//int y = 0;
	while( block.isValid() ) {
		cur.setPosition(block.position());
		QRectF r = cursorRect(cur);
		r = r.translated(QPointF(-4, 0));
		if( r.top() >= vr.bottom() ) break;
		QTextLayout *textLayout = block.layout();
		textLayout->draw(&painter, QPointF(r.left(), r.top()));
		//for(int i = 0; i < textLayout->lineCount; ++i) {
		//	QTextLine textLine = textLine->lineAt(i);
		//}
#if 0
		const QString text = block.text();
		int ix = 0;
		while( ix < text.length() ) {
			if( text[ix] == '\t' )
				++ix;
			else {
				cur.setPosition(block.position() + ix);
				QRect r = cursorRect(cur);
				x = r.left();
				y = r.bottom();
				int nix = text.indexOf('\t', ix);
				if( nix < 0 ) nix = text.length();
				painter.drawText(x, y, text.mid(ix, nix - ix));
				ix = nix;
			}
		}
#endif
#if 0
		cur.setPosition(block.position());
		QRect r = cursorRect(cur);
		x = r.left();
		y = r.bottom();
#endif
#if 0
		QRectF br = blockBoundingGeometry(block).translated(contentOffset());
		x = (int)br.left();
		y = (int)br.top();
		const int ht = blockBoundingRect(block).height();
		qDebug() << "y = " << y << ", ht = " << ht;
#endif
#if 0
		QTextBlock::iterator it;
		for(it = block.begin(); !(it.atEnd()); ++it) {
			QTextFragment textFragment = it.fragment();
			if( textFragment.isValid() ) {
				//qDebug() << currentFragment.text();
				cur.setPosition(textFragment.position());
				QRect r = cursorRect(cur);
				x = r.left();
				y = r.bottom();
				painter.drawText(x, y, textFragment.text());
			}
		}
		//y += ht;
#endif
		block = block.next();
	}
#endif
	m_lineNumberArea->repaint(m_lineNumberArea->rect());
}
#endif
void ViEditView::drawNewLineEOF()
{
	const int bottom = viewport()->rect().height();
	QPainter painter(viewport());
	//painter.setPen(Qt::blue);
	QTextCursor cur = textCursor();
	cur.movePosition(QTextCursor::End);
	const int posEOF = cur.position();
	QTextBlock block = firstVisibleBlock();
	painter.setPen(Qt::lightGray);
	while( block.isValid() ) {
		const int pos = block.position();		//	ubN擪ʒu
		//painter.setPen(Qt::lightGray);
		const QString text = block.text();
#if 1
		for(int ix = 0; ix < text.length(); ++ix) {
#if 0
			//	\Ȃ̂ŃRgAEg 11/03/18
			if( text[ix] == '\t' ) {
				cur.setPosition(pos + ix);
				QRect r = cursorRect(cur);
				painter.drawText(QPointF(r.left(), r.bottom()), ">");
			} else if( text[ix] == QChar(0x3000) ) {	//	Sp󔒂̏ꍇ
				cur.setPosition(pos + ix);
				QRect r = cursorRect(cur);
				r.setWidth(r.width() - 2);
				r.setHeight(r.height() - 2);
				r.setLeft(r.left() + 1);
				r.setTop(r.top() + 1);
				painter.drawRect(r);
			}
#else
			QString str;
			if( text[ix] == '\t' ) str = ">";
			else if( text[ix] == QChar(0x3000 /*L'@'*/) ) str = "[]";		//	Sp󔒂̏ꍇ
			if( !str.isEmpty() ) {
				cur.setPosition(pos + ix);
				QRect r = cursorRect(cur);
				painter.drawText(QPointF(r.left(), r.bottom()), str);
			}
#endif
		}
#else
		int ix = 0;
		while( ix < text.length() ) {
			const int tab = text.indexOf(QRegExp("[\t@]"), ix);
			if( tab < 0 ) break;
			cur.setPosition(pos + tab);
			QRect r = cursorRect(cur);
			painter.drawText(QPointF(r.left(), r.bottom()),
								text[tab] == '\t' ? ">" : "[]");
			ix = tab + 1;
		}
#endif
		cur.setPosition(pos);	//	ubN擪ʒu
		cur.movePosition(QTextCursor::EndOfBlock);		//	ubNړ
		if( cur.position() == posEOF )		//	ŌɉsȂAEOF ꍇ
			break;
		QRect r = cursorRect(cur);
		if( r.top() >= bottom ) break;		//	ʊȌꍇ
		//painter.setPen(Qt::blue);
		painter.drawText(QPointF(r.left(), r.bottom()), "");
		block = block.next();
	}
	cur.movePosition(QTextCursor::End);
	QRect r = cursorRect(cur);
	painter.setPen(Qt::blue);
	painter.drawText(QPointF(r.left(), r.bottom()), "[EOF]");
}
void ViEditView::drawCursor()
{
	//qDebug() << "m_cursorWidth = " << m_cursorWidth;
	QPainter painter(viewport());
	QRectF r = cursorRect();
	//qDebug() << "r = " << r;
    QPointF offset(contentOffset());	//	r[|[g_W
	//qDebug() << "offset = " << offset;
	//r = r.translated(offset);
	r.setWidth(m_cursorWidth);
	switch( mode() ) {
	case CMD:
		r = QRect(r.left(), r.top() + r.height()/2, r.width(), r.height()/2);
		break;
	case REPLACE:
		r = QRect(r.left(), r.top(), r.width(), r.height());
		break;
	case INSERT:
		r.setWidth(1);
		break;
	}
	//qDebug() << painter.hasClipping();
	painter.fillRect(r, Qt::red);
#if 0
	painter.setPen(Qt::transparent);
	painter.setBrush(Qt::red);
	painter.drawRect(r);
#endif
}
const QTextBlock *ViEditView::firstVisibleBlockPtr() const
{
	static QTextBlock temp;
	temp = firstVisibleBlock();
	return &temp;
}
const QTextBlock *ViEditView::lastVisibleBlockPtr() const
{
	static QTextBlock temp;
	temp = firstVisibleBlock();
	const QRect cr = rect();
	QTextCursor cur = textCursor();
	const QTextBlock lastBlock = document()->lastBlock();
	qDebug() << lastBlock.position();
	for(;;) {
		QTextBlock next = temp.next();
		qDebug() << next.position();
		if( next == lastBlock ) {
			if( !next.text().isEmpty() )
				temp = next;
			break;
		}
		if( !next.isValid() ) break;
		cur.setPosition(next.position());
		QRect r = cursorRect(cur);
		if( r.bottom() > cr.bottom() ) break;
		temp = next;
	}
	return &temp;
}
void ViEditView::doJump(int lineNum)
{
	ViCursor cur = viCursor();
	if( cur.movePosition(ViMoveOperation::JumpLine, QTextCursor::MoveAnchor, lineNum) )
		setViCursor(cur);
}
void ViEditView::doVertScroll(int op)
{
	QScrollBar *vScrollBar = verticalScrollBar();
	QTextCursor cur = textCursor();
	const int value = vScrollBar->value();
	const int pageStep = vScrollBar->pageStep();
	switch( op ) {
	case ViScrollOperation::NextPage:
		vScrollBar->setValue(value + pageStep);
		break;
	case ViScrollOperation::PrevPage:
		vScrollBar->setValue(value - pageStep);
		break;
	case ViScrollOperation::NextHalfPage:
		vScrollBar->setValue(value + pageStep / 2);
		break;
	case ViScrollOperation::PrevHalfPage:
		vScrollBar->setValue(value - pageStep / 2);
		break;
	case ViScrollOperation::ExposeBottom:
		vScrollBar->setValue(value + 1);
		break;
	case ViScrollOperation::ExposeTop:
		vScrollBar->setValue(value - 1);
		break;
	default:
		return;
	}
	const int diff = vScrollBar->value() - value;
	if( diff == 0 ) return;
	if( diff > 0 )
		cur.movePosition(QTextCursor::Down, QTextCursor::MoveAnchor, diff);
	else
		cur.movePosition(QTextCursor::Up, QTextCursor::MoveAnchor, -diff);
	setTextCursor(cur);
}
