#pragma once

//----------------------------------------------------------------------
//
//			File:			"ViEditView.h"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	r[NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifndef VIEDITVIEW_H
#define VIEDITVIEW_H

#include <QPlainTextEdit>
#include "vi.h"
//#include "charEncoding.h"

#define		DRAW_CURSOR		1

//class LineNumberArea;
//class ViEngine;
class QElapsedTimer;
class ViCursor;

class ViEditView : public QPlainTextEdit
{
	Q_OBJECT

#if 0	//	vi.h Ɉړ
public:
	enum Mode {
		CMD = 0,
		INSERT,
	};
#endif

public:
	ViEditView(QWidget *parent = 0);
	~ViEditView();

public:
	Mode	mode() const { return m_mode; }
	int		lineNumberAreaWidth() const;
	ViCursor	viCursor() const;
	uchar	charEncoding() const { return m_charEncoding; }
	//int		BOMLength() const { return m_BOMLength; }
	bool	withBOM() const { return m_withBOM; }

public:
	void	setViCursor(const ViCursor &);
#if !USE_EVENT_FILTER
	void	setViEngine(ViEngine *viEngine) { m_viEngine = viEngine; }
#endif
	void	resetCursorBlinkTimer();
	//void	moveCursor(int, int n = 1);
	//void	doDelete(int n = 1);
	void	doDelete(int, int);
	void	doOpenLine(bool next = true);		//	next = false Ȃ΁AOɍsI[v
	void	doUndo(int n = 1);
	void	doRedo(int n = 1);
	void	doJump(int lineNum);
	void	doVertScroll(int);
	void	lineNumberAreaPaintEvent(QPaintEvent *event);
	const QTextBlock *firstVisibleBlockPtr() const;
	const QTextBlock *lastVisibleBlockPtr() const;
	void	processKeyPressEvent(QKeyEvent * event) { keyPressEvent(event); }
	void	setCharEncodeing(uchar ce) { m_charEncoding = ce; }
	//void	setBOMLength(int MOBLength) { m_BOMLength = BOMLength; }
	void	setWithBOM(bool b) { m_withBOM = b; }

public slots:
	void	setDrawText(bool);
	void	setMode(Mode mode);
	void	onCursorPositionChanged();
	void	setFontPointSize(int);
	void	setFontFamily(const QString &);
	void	makeFontBigger(bool);

protected:
	bool	eventFilter(QObject *obj, QEvent *event);
	void	wheelEvent ( QWheelEvent * event );
	void	resizeEvent(QResizeEvent *event);
	void	paintEvent(QPaintEvent * event);
    void	focusInEvent ( QFocusEvent * event );
	//void	mousePressEvent ( QKeyEvent * event );
#if !USE_EVENT_FILTER
	void	keyPressEvent ( QKeyEvent * event );
#endif

	void	onFontChanged();
	void	updateLineNumberAreaSize();

	//void	onLineNumberAreaWidthChanged();
	void	drawNewLineEOF();
	void	drawCursor();
	void	drawLineNumbers();

signals:
	void	modeChanged(Mode);
	void	showMessage(const QString &);
	void	setFocusToCmdLine();

private:
	uchar	m_charEncoding;
	bool	m_withBOM;
	//int		m_BOMLength;
	bool	m_drawText;
	Mode	m_mode;
#if !USE_EVENT_FILTER
	ViEngine	*m_viEngine;
#endif
	QWidget	*m_lineNumberArea;
	int		m_lineNumberAreaWidth;
	int		m_lineNumberWidth;
	int		m_cursorWidth;
	int		m_curNthLine;			//	J[\s in Block for j k
	qint64	m_tickCount;			//	^C}[l
	QElapsedTimer	*m_timer;		//	^C}[IuWFNg
};

#if 0
class LineNumberArea : public QWidget
{
public:
	LineNumberArea(ViEditView *editor)
		: m_editor(editor), QWidget(editor) {}

public:
	QSize sizeHint() const
	{ return QSize(m_editor->lineNumberAreaWidth(), 0); }

protected:
	void paintEvent(QPaintEvent *event)
	{ m_editor->lineNumberAreaPaintEvent(event); }

private:
	ViEditView	*m_editor;
};
#endif
#endif // VIEDITVIEW_H
