//----------------------------------------------------------------------
//
//			File:			"ViEngine.cpp"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	viGWNX
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QtGui>
#include "vi.h"
#include "ViEngine.h"
#include "ViEditView.h"
#include "viCursor.h"

ViEngine::ViEngine(QObject *parent)
	: m_noInsModeAtImeOpenStatus(false), m_mode(CMD), m_editor(0)
	, m_redoRecording(false), m_redoing(false), m_redoRepeatCount(0)
	, m_noRepeatCount(false), m_joinPrevEditBlock(false)
	, m_moveByLine(false)
	, m_cmdPrefix(0), m_cdyCmd(0)	//(0)
	, m_repeatCount(0), m_repeatCount2(0), QObject(parent)
{
    QSettings settings;
    m_exCommands = settings.value("recentExCmdList").toStringList();
}

ViEngine::~ViEngine()
{

}
void ViEngine::setEditor(ViEditView *editor)
{
	m_editor = editor;
#if USE_EVENT_FILTER
	m_editor->installEventFilter(this);
#endif
}
void ViEngine::setMode(Mode mode, ushort subMode)
{
	if( mode != m_mode ) {
		const bool fromCMDLINE = m_mode == CMDLINE;
		m_mode = mode;
		m_noInsModeAtImeOpenStatus = true;
		emit modeChanged(mode, subMode);
		m_noInsModeAtImeOpenStatus = false;
		if( fromCMDLINE )
			m_editor->setFocus();
	}
}
#if 1
bool ViEngine::eventFilter(QObject *obj, QEvent *event)
{
	if( obj == m_editor ) {
		if( event->type() == QEvent::KeyPress ) {
			return processKeyPressEvent(static_cast<QKeyEvent *>(event));
#if 0
			switch( mode() ) {
			case CMD:
				return cmdModeKeyPressEvent(static_cast<QKeyEvent *>(event));	//	R}h[h̏ꍇ̏
			case INSERT:
				return insModeKeyPressEvent(static_cast<QKeyEvent *>(event));	//	}[h̏ꍇ̏
			}
#endif
		//		}EXNbNĂȂ 11/02/12
		//} else if( event->type() == QEvent::MouseButtonPress ) {
		//	m_redoRecording = false;
		}
	}
	return false;
}
#else
bool ViEngine::processKeyPressEvent( QKeyEvent * event )
{
	switch( mode() ) {
	case CMD:
		return cmdModeKeyPressEvent(event);	//	R}h[h̏ꍇ̏
	case INSERT:
		return insModeKeyPressEvent(event);	//	}[h̏ꍇ̏
	}
	return false;
}
#endif

void ViEngine::printCursorPosition()
{
	QString mess;
	QTextCursor cur = m_editor->textCursor();
	QTextBlock block = cur.block();
	if( block.isValid() ) {
		mess = QString(tr("pos = %1 block.length() = %2 textLen = %3"))
				.arg(cur.position()).arg(block.length()).arg(block.text().length());
	} else
		mess = tr("block is NOT valid.");
	emit showMessage(mess);
}

//	s擪̋󔒗ނ͍폜
//	Osɋ󔒗ނꍇ̂݁Ap󔒂}
void ViEngine::doJoin(int n)
{
	ViCursor cur = m_editor->textCursor();
	int pos = cur.position();
	cur.beginEditBlock();
	do {
		QTextBlock block = cur.block();
		QTextBlock next = block.next();
		if( !next.isValid() ) break;
		cur.setPosition(pos = block.position() + block.text().length());
		cur.setPosition(next.position(), QTextCursor::KeepAnchor);
		cur.movePosition(ViMoveOperation::FirstNonBlankChar, QTextCursor::KeepAnchor);
		QChar lastChar;
		if( !block.text().isEmpty() )
			lastChar = block.text().at(block.text().length() - 1);
		if( lastChar == ' ' || lastChar == '\t' )
			cur.deleteChar();
		else
			cur.insertText(" ");
		//cur.movePosition(QTextCursor::Right);	//	󔒈ʒuɈړ
	} while( --n > 1 );		//	2J ܂ł͂P񂾂join
	cur.endEditBlock();
	cur.setPosition(pos);	//	Ō̋󔒈ʒuɈړ
	m_editor->setTextCursor(cur);
}
bool ViEngine::doShiftRight(QTextCursor &cur, int n)
{
	int pos = cur.position();
	cur.beginEditBlock();
	QTextBlock block = cur.block();
	do {
		cur.setPosition(block.position());
		cur.insertText("\t");
		if( !--n ) break;
		block = block.next();
	} while( block.isValid() );
	cur.setPosition(pos);
	moveCursor(cur, ViMoveOperation::FirstNonBlankChar);
	m_editor->setTextCursor(cur);
	cur.endEditBlock();
	m_editor->viewport()->update();
	return true;
}
bool ViEngine::doShiftLeft(QTextCursor &cur, int n)
{
	int pos = cur.position();
	cur.beginEditBlock();
	QTextBlock block = cur.block();
	do {
		const QString text = block.text();
		if( text.length() != 0 ) {
			int ix = 0;
			if( text[0] == '\t' ) ix = 1;
			else
				while( ix < 4 && ix < text.length() && text[ix] == ' ' )
					++ix;
			if( ix != 0 ) {
				cur.setPosition(block.position());
				cur.setPosition(block.position() + ix, QTextCursor::KeepAnchor);
				cur.deleteChar();
			}
		}
		if( !--n ) break;
		block = block.next();
	} while( block.isValid() );
	cur.setPosition(pos);
	moveCursor(cur, ViMoveOperation::FirstNonBlankChar);
	m_editor->setTextCursor(cur);
	cur.endEditBlock();
	m_editor->viewport()->update();
	return true;
}

int ViEngine::repeatCount() const
{
	int rc2 = !m_repeatCount2 ? 1 : m_repeatCount2;
	if( !m_repeatCount ) {
		if( m_redoing && m_redoRepeatCount != 0 )
			return m_redoRepeatCount;
		return rc2;
	}
	return m_repeatCount * rc2;
}
//	block  n s̐擪ʒuԂ
int nLinesPosition(QTextCursor cur, int n)
{
	QTextBlock block = cur.block();
	while( --n >= 0 ) {
		block = block.next();
		if( !block.isValid() ) {
			cur.movePosition(QTextCursor::End);
			return cur.position();
		}
	}
	return block.position();
}
void ViEngine::doViCommand(const QString &text)
{
	for(int ix = 0; ix < text.length(); ++ix)
		doViCommand(text[ix]);
}
/**
	@return		R}hƂďꍇ true
*/
bool ViEngine::doViCommand(const QChar &qch)
{
	ushort ch = qch.unicode();
	int op = 0;
	switch( ch ) {
	case 'F' - '@':
		op = ViScrollOperation::NextPage;
		break;
	case 'B' - '@':
		op = ViScrollOperation::PrevPage;
		break;
	case 'D' - '@':
		op = ViScrollOperation::NextHalfPage;
		break;
	case 'U' - '@':
		op = ViScrollOperation::PrevHalfPage;
		break;
	case 'E' - '@':
		op = ViScrollOperation::ExposeBottom;
		break;
	case 'Y' - '@':
		op = ViScrollOperation::ExposeTop;
		break;
	}
	if( op != 0 ) {
		m_editor->doVertScroll(op);
		return true;
	}
	if( mode() == INSERT || mode() == REPLACE ) {
		//	done A insModeKeyPressEvent() ̕Əʉ
		if( qch.unicode() == 0x1b ) {	//	Esc
			QTextCursor cur = m_editor->textCursor();
			if( m_redoRecording ) {
				//	}ɃJ[\ړĂȂJԂ񐔎w肪ꍇ́Ac񐔕̕}
#if 1
				//	R ̏ꍇłAQڈȍ~͑}invi Ɠdlj
				for(int i = 1; i < m_insCount; ++i) {
					if( m_redoCmd == "o" || m_redoCmd == "O" )
						cur.insertText("\n");
					cur.insertText(m_insertedText);
				}
#else
				if( mode() == INSERT ) {
					for(int i = 1; i < m_insCount; ++i) {
						if( m_redoCmd == "o" || m_redoCmd == "O" )
							cur.insertText("\n");
						cur.insertText(m_insertedText);
					}
				} else {
					for(int i = 1; i < m_insCount; ++i) {
						cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor,
											m_insertedText.length());
						cur.insertText(m_insertedText);
					}
				}
#endif
			}
			moveCursor(cur, ViMoveOperation::Left);
			m_editor->setTextCursor(cur);
			m_editor->setOverwriteMode(false);
			m_joinPrevEditBlock = false;
			m_redoRecording = false;
			m_insCount = 0;
			setMode(CMD);
		} else {
			if( ch == 0x08 ) {		//	BackSpace
				if( !m_insertedText.isEmpty() )
					m_insertedText = m_insertedText.left(m_insertedText.length() - 1);
				return false;
			} else if( ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t' ) {
				m_redoRecording = false;
				m_joinPrevEditBlock = false;
			} else
				m_insertedText += qch;
			QTextCursor cur = m_editor->textCursor();
			if( mode() == REPLACE && !cur.atBlockEnd() )
				cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor);
			if( m_joinPrevEditBlock ) {
				cur.joinPreviousEditBlock();
				cur.insertText(qch);
				cur.endEditBlock();
			} else {
				cur.insertText(qch);
			}
		}
		return true;
	}
	m_cmdString += qch;
	//showMessage(m_cmdString);
	if( !m_noRepeatCount ) {
		if( !m_cdyCmd ) {
			if( ch == '0' && m_repeatCount != 0 || ch >= '1' && ch <= '9' ) {
				m_repeatCount = m_repeatCount * 10 + (ch - '0');
				emit showMessage(m_cmdString);
				return true;
			}
		} else {
			if( ch >= '0' && ch <= '9' ) {
				m_repeatCount2 = m_repeatCount2 * 10 + (ch - '0');
				emit showMessage(m_cmdString);
				return true;
			}
		}
	}
	//bool rc = true;
	ViCursor cur = m_editor->viCursor();
	QTextBlock block = cur.block();
	bool toUpdateRedoCmd = false;
	bool cursorMoved = false;
	bool toInsertMode = false;
	bool toReplaceMode = false;
	bool toYankByLine = false;
	bool findInLineForward = false;		//	f t or (; ,) őO
	int toMovePos = -1;
	int delFrom = -1;
	int delTo = -1;
	int yankFrom = -1;
	int yankTo = -1;

	if( m_cmdPrefix != 0 ) {
		switch( m_cmdPrefix ) {
		case 'g':
			if( ch == 'g' ) {
				cursorMoved = cur.movePosition(ViMoveOperation::JumpLine);
				m_moveByLine = true;
			}
			break;
		case 'r': {
			QString t;
			for(int i = repeatCount(); --i >= 0; ) {
				if( !cur.atBlockEnd() )
					cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, 1);
				t += ch;
			}
			if( t.isEmpty() )	//	sʒuɂꍇ
				cur.insertText(QString(ch));
			else
				cur.insertText(t);
			break;
		}
		case '>':
			if( ch == '>' ) {
				doShiftRight(cur, repeatCount());
				m_redoCmd = ">>";
				m_redoRepeatCount = repeatCount();
			}
			break;
		case '<':
			if( ch == '<' ) {
				cursorMoved = doShiftLeft(cur, repeatCount());
				m_redoCmd = "<<";
				m_redoRepeatCount = repeatCount();
			}
			break;
		case ']':
			if( ch == ']' )
				cursorMoved = moveCursor(cur, ViMoveOperation::NextBeginBlock, repeatCount());
			break;
		case '[':
			if( ch == '[' )
				cursorMoved = moveCursor(cur, ViMoveOperation::PrevBeginBlock, repeatCount());
			break;
		case 'f':
		case 'F':
		case 't':
		case 'T':
			m_lastFTCmd = m_cmdPrefix;		//	}b`邩ǂɊ֌WȂL^
			m_lastFTChar = qch;
			cursorMoved = moveCursorFindInLine(cur, m_cmdPrefix, qch, repeatCount());
			break;
		case 'Z':
			if( ch == 'Z' ) {
				emit save(QString());
				emit closeView(m_editor);
			}
			break;
		}
	} else if( m_cdyCmd != 0 && m_cdyCmd == ch ) {
		switch( ch ) {
		case 'c':		//	cc
			m_editor->doDelete(cur.block().position(), nLinesPosition(cur, repeatCount()));
			m_editor->doOpenLine(/*next = */false);
			cur = m_editor->textCursor();
			toInsertMode = true;
			toUpdateRedoCmd = true;
			m_repeatCount = 1;		//	JԂ񐔂͍폜s
			//delFrom = cur.position();
			//delTo = block.position() + block.text().length();
			break;
		case 'd':		//	dd
			delFrom = cur.block().position();
			delTo = nLinesPosition(cur, repeatCount());
			toYankByLine = true;		//	for m_yankByLine;
			break;
		case 'y':		//	yy
			yankFrom = cur.block().position();
			yankTo = nLinesPosition(cur, repeatCount());
			toYankByLine = true;		//	for m_yankByLine;
			break;
		}
	} else {
		const bool cdy = m_cdyCmd != 0;
		switch( ch ) {
		case 'f':
		case 'F':
		case 't':
		case 'T':
		case ']':
		case '[':
		case 'g':
		case 'r':
		case 'Z':
			m_noRepeatCount = true;
			//	ɃX[
		case '>':
		case '<':
			m_cmdPrefix = ch;
			emit showMessage(m_cmdString);
			return true;
		case 'c':
		case 'd':
		case 'y':
			m_cdyCmd = ch;
			m_cdyPos = cur.position();
			emit showMessage(m_cmdString);
			return true;
		case ';':
			if( m_lastFTChar != QChar() ) {
				findInLineForward = m_lastFTCmd == 'f' || m_lastFTCmd == 't';
				cursorMoved = moveCursorFindInLine(cur, m_lastFTCmd, m_lastFTChar, repeatCount());
			}
			break;
		case ',':
			if( m_lastFTChar != QChar() ) {
				findInLineForward = m_lastFTCmd == 'F' || m_lastFTCmd == 'T';
				const ushort cmd = m_lastFTCmd ^ 'F' ^ 'f';		//	f,F t,T ]
				cursorMoved = moveCursorFindInLine(cur, cmd, m_lastFTChar, repeatCount());
			}
			break;
		case '0':
			cursorMoved = moveCursor(cur, QTextCursor::StartOfBlock);
			break;
		case '^':
			cursorMoved = moveCursor(cur, ViMoveOperation::FirstNonBlankChar);
			break;
		case '$':
			cursorMoved = moveCursor(cur, ViMoveOperation::LastChar, 1, cdy);
			break;
		case '%':
			cursorMoved = moveCursor(cur, ViMoveOperation::MatchParen);
			break;
		case '}':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextBlankLine, repeatCount());
			m_moveByLine = true;
			break;
		case '{':
			cursorMoved = moveCursor(cur, ViMoveOperation::PrevBlankLine, repeatCount());
			m_moveByLine = true;
			break;
		case 'H': 
			cursorMoved = moveCursor(cur, ViMoveOperation::TopOfView, repeatCount(),
										cdy, m_editor->firstVisibleBlockPtr());
			m_moveByLine = true;
			break;
		case 'L': 
			cursorMoved = moveCursor(cur, ViMoveOperation::BottomOfView, repeatCount(),
										cdy, m_editor->lastVisibleBlockPtr());
			m_moveByLine = true;
			break;
		case 'M': {
			const int n = (m_editor->firstVisibleBlockPtr()->blockNumber() + 
							cdy, m_editor->lastVisibleBlockPtr()->blockNumber()) / 2 + 1;
			cursorMoved = cur.movePosition(ViMoveOperation::JumpLine, QTextCursor::MoveAnchor, n);
			m_moveByLine = true;
			break;
		}
		case 'G':
			if( !m_repeatCount )
				cursorMoved = moveCursor(cur, ViMoveOperation::LastLine);
			else
				cursorMoved = cur.movePosition(ViMoveOperation::JumpLine, QTextCursor::MoveAnchor, repeatCount());
			m_moveByLine = true;
			break;
		case '/':
		case '?':
		case ':':
			//m_cmdString = qch;
			m_message.clear();
			setMode(CMDLINE, ch);	//	: ꂽex[h
			break;
		case 'a':
			cursorMoved = moveCursor(cur, ViMoveOperation::RightForA);
			toInsertMode = true;
			break;
		case 'i':
			toInsertMode = true;
			break;
		case 'A':
			cursorMoved = moveCursor(cur, QTextCursor::EndOfBlock);
			toInsertMode = true;
			break;
		case 'I':
			cursorMoved = moveCursor(cur, ViMoveOperation::FirstNonBlankChar);
			toInsertMode = true;
			break;
#if 1
		case 'o':
		case 'O':
			//cur.beginEditBlock();
			m_joinPrevEditBlock = true;
			m_editor->doOpenLine(/*next=*/ch == 'o');
			cur = m_editor->textCursor();
			//cur.endEditBlock();
			toInsertMode = true;
			break;
#else
		case 'o':
			//	done C undo\ɂ
			cur.beginEditBlock();
			//m_editor->setTextCursor(cur);
			m_joinPrevEditBlock = true;
			m_editor->doOpenLine();
			//m_editor->viewport()->update();
			cur = m_editor->textCursor();
			cur.endEditBlock();
			toInsertMode = true;
			break;
		case 'O':
			//	done C undo\ɂ
			cur.beginEditBlock();
			m_joinPrevEditBlock = true;
			m_editor->doOpenLine(/*next = */false);
			cur = m_editor->textCursor();
			cur.endEditBlock();
			toInsertMode = true;
			break;
#endif
		case 'S':
			//	done C undo\ɂ
			m_editor->doDelete(cur.block().position(), nLinesPosition(cur, repeatCount()));
			m_editor->doOpenLine(/*next = */false);
			cur = m_editor->textCursor();
			toInsertMode = true;
			toUpdateRedoCmd = true;
			m_repeatCount = 1;		//	JԂ񐔂͍폜s
			break;
		case 'R':
			toReplaceMode = true;
			break;
		case 0x08:		//	BackSpace
		case 'h':
			cursorMoved = cur.movePosition(ViMoveOperation::Left, QTextCursor::MoveAnchor, repeatCount());
			break;
		case ' ':
		case 'l':
			cursorMoved = cur.movePosition(ViMoveOperation::Right, QTextCursor::MoveAnchor, repeatCount());
			break;
		case 'k':
			cursorMoved = cur.movePosition(ViMoveOperation::Up, QTextCursor::MoveAnchor, repeatCount());
			break;
		case 'j':
			cursorMoved = cur.movePosition(ViMoveOperation::Down, QTextCursor::MoveAnchor, repeatCount());
			break;
		case 'b':
			cursorMoved = cur.movePosition(ViMoveOperation::PrevWord, QTextCursor::MoveAnchor, repeatCount());
			break;
		case 'e':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextWordEnd, repeatCount(), cdy);
			break;
		case 'w':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextWord, repeatCount(), cdy);
			break;
		case 'B':
			cursorMoved = moveCursor(cur, ViMoveOperation::PrevSSWord, repeatCount());
			break;
		case 'E':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextSSWordEnd, repeatCount(), cdy);
			break;
		case 'W':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextSSWord, repeatCount(), cdy);
			break;
		case '\r':		//	Enter
		case '+':
			cursorMoved = moveCursor(cur, ViMoveOperation::NextLine, repeatCount());
			break;
		case '-':
			cursorMoved = moveCursor(cur, ViMoveOperation::PrevLine, repeatCount());
			break;
		case 'n':
			cursorMoved = doFindNext(cur, repeatCount());
			break;
		case 'N':
			cursorMoved = doFindNext(cur, repeatCount(), /*reverse=*/true);
			break;
		case 'J':
			doJoin(repeatCount());
			toUpdateRedoCmd = true;
			break;
		case 'C':
			toInsertMode = true;
			//	ɃX[
		case 'D': {
			delFrom = cur.position();
			//const QTextBlock block = cur.block();
			delTo = block.position() + block.text().length();
			toUpdateRedoCmd = true;
			break;
		}
		case 's':
			toInsertMode = true;
			delFrom = cur.position();
			moveCursor(cur, ViMoveOperation::RightForA, repeatCount());
			delTo = cur.position();
			m_repeatCount = 1;		//	<l>s text Esc  text 𐔒l񐔑}܂悤
			break;
		case 'x':
			delFrom = cur.position();
			moveCursor(cur, ViMoveOperation::RightForA, repeatCount());
			delTo = cur.position();
			break;
		case 'X':
			delTo = cur.position();
			moveCursor(cur, ViMoveOperation::Left, repeatCount());
			delFrom = cur.position();
			break;
		case 'Y':		//	sN
			yankFrom = cur.block().position();
			yankTo = nLinesPosition(cur, repeatCount());
			toYankByLine = true;
			break;
		case 'p':		//	J[\EsɃy[Xg
			if( m_yankBuffer.isEmpty() ) break;
			if( m_yankByLine ) {
				if( block.next().isValid() )
					cur.setPosition(block.next().position());
				else if( !block.text().isEmpty() ) {
					//	łȂEOFs̏ꍇ
					cur.movePosition(QTextCursor::End);
					cur.insertText("\n");
				}
			} else {
				if( !cur.atBlockEnd() )
					cur.movePosition(QTextCursor::Right);
			}
			toMovePos = cur.position();
			cur.insertText(yankText());
			cur.setPosition(toMovePos);
			m_editor->setTextCursor(cur);
			break;
		case 'P':		//	J[\ʒuEsOɃy[Xg
			if( m_yankBuffer.isEmpty() ) break;
			if( m_yankByLine )
				cur.setPosition(block.position());
			toMovePos = cur.position();
			cur.insertText(yankText());
			cur.setPosition(toMovePos);
			m_editor->setTextCursor(cur);
			break;
		case '~':		//	p啶u
			cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, repeatCount());
			if( cur.hasSelection() ) {
				QString text = cur.selectedText();
				for(int i = 0; i < text.length(); ++i) {
					if( text[i].isUpper() )
						text[i] = text[i].toLower();
					else if( text[i].isLower() )
						text[i] = text[i].toUpper();
				}
				cur.insertText(text);
			}
			break;
		case 'u':
			m_editor->doUndo(repeatCount());
			break;
		case 'U':
			m_editor->doRedo(repeatCount());
			break;
		case '.':
			if( !m_redoCmd.isEmpty() ) {
				m_redoing = true;
				doViCommand(m_redoCmd);
				m_redoing = false;
			}
			break;
		case ('G' - '@'):
			printCursorPosition();
			break;
		case 0x1b:		//	Esc
			emit showMessage("CMD");
			break;
		default:
			//rc = false;
			break;
		}
	}
	if( cursorMoved ) {
		//if( m_cdyCmd && (ch == 'e' || ch == 'E') )
		//	cur.movePosition(QTextCursor::Right);
		switch( m_cdyCmd ) {
		case 'c':
			m_joinPrevEditBlock = true;
			toInsertMode = true;
			//	ɃX[
		case 'd':
			delFrom = m_cdyPos;
			delTo = cur.position();
			if( m_cmdPrefix == 'f' || m_cmdPrefix == 't' || findInLineForward )
				++delTo;
			if( delFrom > delTo ) {		//	擪Ɉړꍇ
				int t = delFrom;
				delFrom = delTo;
				delTo = t;
			}
			break;
		case 'y':
			yankFrom = m_cdyPos;
			yankTo = cur.position();
			if( m_cmdPrefix == 'f' || m_cmdPrefix == 't' || findInLineForward )
				++yankTo;
			if( yankFrom > yankTo ) {		//	擪Ɉړꍇ
				int t = yankFrom;
				yankFrom = yankTo;
				yankTo = t;
			}
			break;
		default:
			m_editor->setViCursor(cur);
			//qDebug() << "cur.position() = " << cur.position();
		}
	}
	if( (delFrom >= 0 && delFrom < delTo || toUpdateRedoCmd || toInsertMode)
		&& !m_redoing )
	{
		//	.(repeat command) ׂ̈ɕҏWR}hL^
		if( m_cdyCmd )
			m_redoCmd = QChar(m_cdyCmd);
		else
			m_redoCmd = QString();
		if( m_cmdPrefix != 0 )
			m_redoCmd += QChar(m_cmdPrefix);
		m_redoCmd += qch;
		m_redoRepeatCount = repeatCount();
	}
	if( m_cdyCmd )
		m_repeatCount = m_repeatCount2 = 1;
	if( yankFrom >= 0 && yankFrom < yankTo ) {
		//	undone R delete ̏ꍇƏʉ
		cur.setPosition(yankFrom);
		cur.setPosition(yankTo, QTextCursor::KeepAnchor);
		m_yankByLine = m_moveByLine || toYankByLine;
		m_yankBuffer = cur.selectedText();
	}
	if( delFrom >= 0 && delFrom < delTo ) {
		if( m_moveByLine ) {
			//QTextCursor cur = m_editor->textCursor();
			cur.setPosition(delFrom);
			delFrom = cur.block().position();
			cur.setPosition(delTo);
			QTextBlock block = cur.block();
			//if( cur.position() != block.position() ) { //	delTo sł͂Ȃꍇ
				if( block.next().isValid() )
					delTo = block.next().position();
				else
					delTo = block.position() + block.text().length();
			//}
		}
		cur.setPosition(delFrom);
		cur.setPosition(delTo, QTextCursor::KeepAnchor);
		m_yankByLine = m_moveByLine || toYankByLine;
		m_yankBuffer = cur.selectedText();
		if( m_joinPrevEditBlock ) {
			cur.beginEditBlock();
			cur.deleteChar();
			cur.endEditBlock();
			m_editor->setTextCursor(cur);
		} else {
			cur.deleteChar();
		}
		//	폜ɉsʒuɂꍇ̓J[\ړ
		QTextCursor cur = m_editor->textCursor();
		const QTextBlock block = cur.block();
		if( !toInsertMode && block.text().length() != 0 &&
			cur.position() == block.position() + block.text().length() )
		{
			cur.setPosition(cur.position() - 1);
			m_editor->setTextCursor(cur);
		}
	}
	if( toInsertMode ) {
		//if( m_joinPrevEditBlock )
		//	cur.beginEditBlock();
		m_insCount = repeatCount();
		if( !m_redoing ) {
			m_redoRecording = true;
			m_insertedText.clear();
			setMode(INSERT);
			m_editor->viewport()->update();		//	ʗ𖳂
		} else {
			if( !m_insertedText.isEmpty() ) {
				for(int c = ch != 's' ? repeatCount() : 1; c > 0; --c)
					cur.insertText(m_insertedText);
			}
			moveCursor(cur, ViMoveOperation::Left);
			m_editor->setTextCursor(cur);
		}
	}
	if( toReplaceMode ) {
		m_insCount = repeatCount();
		if( !m_redoing ) {
			m_redoRecording = true;
			m_insertedText.clear();
			m_editor->setOverwriteMode(true);
		} else {
			//	undone B R[fBO
		}
		setMode(REPLACE);
		m_editor->viewport()->update();		//	ʗ𖳂
	}
	m_noRepeatCount = false;
	m_moveByLine = false;
	m_cmdPrefix = 0;
	m_cdyCmd = 0;
	m_repeatCount = 0;
	m_repeatCount2 = 0;
	m_cmdString.clear();
	m_message.clear();
	//showMessage(" ");
	if( !m_cmdString.isEmpty() )
		emit showMessage(m_cmdString);
	return true;
}
QString ViEngine::yankText() const
{
	QString text = m_yankBuffer;
	for(int i = repeatCount(); --i > 0; )
		text += m_yankBuffer;
	return text;
}
bool viCtrlCmd[] = 
{
	false,	//	Ctrl + @
	false,	//	Ctrl + A
	true,	//	Ctrl + B
	false,	//	Ctrl + C
	true,	//	Ctrl + D
	true,	//	Ctrl + E
	true,	//	Ctrl + F
	true,	//	Ctrl + G
	true,	//	Ctrl + H	BackSpace
	true,	//	Ctrl + I	TAB
	false,	//	Ctrl + J
	false,	//	Ctrl + K
	false,	//	Ctrl + L
	true,	//	Ctrl + M	Enter
	false,	//	Ctrl + N
	false,	//	Ctrl + O
	false,	//	Ctrl + P
	false,	//	Ctrl + Q
	false,	//	Ctrl + R
	false,	//	Ctrl + S
	false,	//	Ctrl + T
	true,	//	Ctrl + U
	false,	//	Ctrl + V
	false,	//	Ctrl + W
	false,	//	Ctrl + X
	true,	//	Ctrl + Y
	false,	//	Ctrl + Z
	true,	//	Ctrl + [	Esc
	false,	//	Ctrl + \ 
	false,	//	Ctrl + ]
	false,	//	Ctrl + ^
	false,	//	Ctrl + _
};
bool ViEngine::processKeyPressEvent( QKeyEvent * event )
{
	const QString text = event->text();
	//	J[\ړL[AHome, End, PageUP, PageDown ɂ͕R[h͊UĂȂ̂ŁA
	//	text ͋ɂȂ
	if( !text.isEmpty() ) {
		if( event->key() == Qt::Key_Delete )	//	Delete L[ɂ͕R[hUĂ
			return false;		
		ushort code = text[0].unicode();
		//qDebug() << "code = " << code;
		//	done R e[uĔ
#if 0
		if( code < 0x20 && code != 'G'-'@' && code != '\t' && code != '\r' &&
			code != 'F' - '@' && code != 'B' - '@' && 
			code != 'D' - '@' && code != 'U' - '@' && 
			code != 'E' - '@' && code != 'Y' - '@' && 
			code != '\n' && code != 0x1b )
#endif
		if( code < 0x20 && !viCtrlCmd[code] )
		{
			return false;		//	ʂ̃Rg[R[h͒ʏ폈
		}
		return doViCommand(text[0]);
		//return true;
	} else if( m_redoRecording ) {
		m_redoRecording = false;
		m_joinPrevEditBlock = false;
	}
	return false;
}

void ViEngine::doExCommand(const QString &text)
{
	if( text.isEmpty() ) return;
	m_exCommands.removeOne(text);		//	d폜
	m_exCommands.push_back(text);
	while( m_exCommands.count() > 100 )
		m_exCommands.pop_front();
    QSettings settings;
    settings.setValue("recentExCmdList", m_exCommands);
	int ix = 0;
	getLineNumbers(text, ix);
	bool exclamation;
	QString cmdText = getExCommand(text, ix, exclamation);
	QString param = text.mid(ix);
	if( cmdText.isEmpty() ) {	//	wsɃWv
		if( m_lineNum2 < 0 ||
			m_lineNum2 > m_editor->document()->lastBlock().blockNumber() + 1)
		{
			return;		//	sԍ͈͊Ȍꍇ
		}
		if( !m_lineNum2 )		//	:0 ͍ŏ̍sɃWv
			m_lineNum2 = 1;
		ViCursor cur = m_editor->textCursor();
		cur.movePosition(ViMoveOperation::JumpLine, QTextCursor::MoveAnchor, m_lineNum2);
		m_editor->setTextCursor(cur);
		return;
	}
	//	undone B if-elseif `FCxȂAe[uhuɏ
	if( cmdText == "set" ) {
		doSet(param);
	} else if( cmdText == "delete" || cmdText == "del" || cmdText == "d" ) {
		doDelete();
	} else if( cmdText == "s" || cmdText == "subst" || cmdText == "substitute" ) {
		if( !m_nLineNum )	//	͈͎w薳̏ꍇ
			doSubst(param, m_curLineNum, m_curLineNum);
		else if( m_nLineNum == 1 )
			doSubst(param, m_lineNum2, m_lineNum2);
		else
			doSubst(param, m_lineNum1, m_lineNum2);
	} else if( cmdText == "quit" || cmdText == "q" ) {
		//if( exclamation )	//	!t̏ꍇ͋N[Y
		//	m_editor->document()->setModified(false);
		emit closeView(m_editor, exclamation);
	} else if( cmdText == "QUIT" || cmdText == "Q" ) {
		emit closeAllViews(exclamation);
	} else if( cmdText == "edit" || cmdText == "e" ) {
		emit open(param);
	} else if( cmdText == "write" || cmdText == "w" ) {
		emit save(param);
	} else if( cmdText == "writequit" || cmdText == "wq" ) {
		emit save(param);
		emit closeView(m_editor);
	} else if( cmdText == "pwd" ) {
		emit showMessage(m_message = QDir::currentPath());
	} else if( cmdText == "cd" ) {
		if( param.isEmpty() )
			QDir::setCurrent(QDir::homePath());
		else {
			QDir dir(param);
			QDir::setCurrent(dir.path());
		}
		emit showMessage(m_message = QDir::currentPath());
	} else if( cmdText == "cls" ) {
		emit clearOutput();
	} else if( cmdText == "test" ) {
		emit testViCommands(param);
	}
	//setMode(CMD);
}
void ViEngine::doSet(const QString &text)
{
	if( text.isEmpty() || text == "all" ) {
		printSettings();
		return;
	}
	int ix = text.indexOf('=');
	if( ix >= 0 ) {
		doSet(text.left(ix), text.mid(ix+1));
	}
}
void ViEngine::doSet(const QString &key, const QString &value)
{
	QString v = value;
	if( value.length() >= 2 && value[0] == '"' && value[value.length() - 1] == '"' )
		v = value.mid(1, value.length() - 2);
	//bool fontChanged = false;
	//QFont font = m_editor->font();
	if( !key.compare("fontSize", Qt::CaseInsensitive) ||
		!key.compare("font", Qt::CaseInsensitive) && v.toInt() != 0 )
	{
		m_editor->setFontPointSize(v.toInt());
		//fontChanged = true;
	} else if( !key.compare("fontFamily", Qt::CaseInsensitive) ||
				!key.compare("fontName", Qt::CaseInsensitive) ||
				!key.compare("font", Qt::CaseInsensitive) )
	{
		m_editor->setFontFamily(v);
		//fontChanged = true;
	}
#if 0
	if( fontChanged ) {
		m_editor->setFont(font);
		//m_editor->
	}
#endif
}

void ViEngine::doDelete()
{
	if( !m_nLineNum )
		m_lineNum1 = m_lineNum2 = m_curLineNum;
	else if( m_nLineNum == 1 )
		m_lineNum1 = m_lineNum2;
	if( !m_lineNum1 ) m_lineNum1 = 1;
	if( m_lineNum1 > m_lineNum2 ) return;
	QTextCursor cur = m_editor->textCursor();
	QTextBlock block1 = m_editor->document()->findBlockByNumber(m_lineNum1 - 1);
	cur.setPosition(block1.position());
	int pos;
	QTextBlock block2 = m_editor->document()->findBlockByNumber(m_lineNum2 - 1);
	if( block2.next().isValid() )
		pos = block2.next().position();
	else
		pos = block2.position() + block2.text().length();
	cur.setPosition(pos, QTextCursor::KeepAnchor);
	//	undone C "[a-z] Nobt@wΉ
	m_yankBuffer = cur.selectedText();
	m_yankByLine = true;
	cur.deleteChar();
}

//	ú͈F[first, last]
void ViEngine::doSubst(const QString &param, int first, int last)
{
	if( param.isEmpty() ) {
		return;
	}
	QString before;
	QString after;
	bool global;
	if( !parseSubstCmd(param, before, after, global) ) {
		showMessage("usage: <range>s[ubst]/before/after/[g]");
		return;
	}
	//qDebug() << QString("before = '%1', after = '%2'").arg(before).arg(after);
	QTextCursor cur = m_editor->textCursor();
	cur.beginEditBlock();
	QRegExp rex(before);
	QTextBlock block = m_editor->document()->findBlockByNumber(first - 1);
	while( first <= last && block.isValid() ) {
		for(int k = 0;;) {
			int ix = rex.indexIn(block.text(), k);
			if( ix < 0 ) break;
			cur.setPosition(block.position() + ix);
			cur.setPosition(block.position() + ix + rex.matchedLength(), QTextCursor::KeepAnchor);
			cur.insertText(after);
			if( !global ) break;
			k = ix + after.length();
		}
		++first;
		block = block.next();
	}
	cur.endEditBlock();
	m_editor->setTextCursor(cur);
}
bool ViEngine::parseSubstCmd(const QString &text,
								QString &before, QString &after, bool &bGlobal)
{
	QChar sep = text[0];
	int ix = text.indexOf(sep, 1);
	if( ix < 0 ) return false;
	before = text.mid(1, ix - 1);
	bGlobal = false;
	int ix2 = text.indexOf(sep, ix + 1);
	if( ix2 < 0 ) {
		after = text.mid(ix + 1);
	} else {
		after = text.mid(ix + 1, ix2 - ix - 1);
		for(int i = ix2 + 1; i < text.length(); ++i) {
			if( text[i] == 'g' )
				bGlobal = true;
			else
				return false;
		}
	}
	return true;
}
void ViEngine::doFind(const QString &regexpText, bool forward)
{
	setMode(CMD);
	QRegExp rex(regexpText);
	if( !rex.isValid() ) {
		emit showMessage(tr("invalid regexp."));
		return;
	}
	QTextCursor cur = m_editor->textCursor();
	if( moveCursorFind(cur, rex, forward) ) {
		m_findString = regexpText;
		m_findForward = forward;
		m_editor->setTextCursor(cur);
	}
	emit regexpSearched(regexpText);
}
bool ViEngine::doFindNext(QTextCursor &cur, int nth, bool revers)
{
	if( m_findString.isEmpty() )
		return false;
	QRegExp rex(m_findString);
	if( !rex.isValid() ) {
		emit showMessage(tr("invalid regexp."));
		return false;
	}
	const bool forward = !revers ? m_findForward : !m_findForward;
	return moveCursorFind(cur, rex, forward, nth);
}

void ViEngine::onImeOpenStatusChanged()
{
	if( mode() == CMD && !m_noInsModeAtImeOpenStatus )
		setMode(INSERT);
}

void ViEngine::printSettings()
{
	QFont font = m_editor->font();
	doOutput("fontFamily=\"" + font.family() + "\"\n");
	doOutput(QString("fontSize=%1pt\n").arg(font.pointSize()));
}

QString ViEngine::getExCommand(const QString &text, int &ix, bool &exclamation)
{
	QString exCommand;
	while( ix < text.length() && text[ix].isLetterOrNumber() )
		exCommand += text[ix++];
	if( (exclamation = ix < text.length() && text[ix] == '!') )
		++ix;
	while( ix < text.length() && (text[ix] == ' ' || text[ix] == '\t') )
		++ix;
	return exCommand;
}

/*

	<range> ::= <lineNumber> | <range> {','|';'} <lineNumber>
	<lineNumber> ::= <digits> | '.' | '$'

*/
void ViEngine::getLineNumbers(const QString &text, int &ix)
{
	if( m_editor == 0 )
		m_curLineNum = 1;
	else {
		const QTextCursor cur = m_editor->textCursor();
		const QTextBlock block = cur.block();
		m_curLineNum = block.blockNumber() + 1;
	}
	if( ix < text.length() && text[ix] == '%' ) {
		++ix;
		m_nLineNum = 2;
		m_lineNum1 = 1;
		QTextBlock block = m_editor->document()->lastBlock();
		m_lineNum2 = block.blockNumber() + 1;
		if( m_lineNum2 > 1 && block.text().isEmpty() )
			--m_lineNum2;
		return;
	}
	m_lineNum1 = m_lineNum2 = m_nLineNum = 0;
	ix = 0;
	int lineNumber;
	while( getAddSubTerm(text, ix, lineNumber) ) {
		++m_nLineNum;
		m_lineNum1 = m_lineNum2;
		m_lineNum2 = lineNumber;
		if( ix >= text.length() ) break;
		QChar ch = text[ix];
		if( ch == ';' )
			m_curLineNum = m_lineNum2;
		else if( ch != ',' )
			break;
		++ix;
	}
}
bool ViEngine::getAddSubTerm(const QString &text, int &ix, int &value)
{
	value = 0;
	if( ix >= text.length() ) return false;
	QChar op;
	if( (op = text[ix]) == '+' || op == '-' )
		value = m_curLineNum;	//	+2 Ƃ -3 Ƃ̗l . ȗꂽꍇ
	else
		if( !getLineNumber(text, ix, value) ) return false;
	while( ix < text.length() && ((op = text[ix]) == '+' || op == '-') ) {
		++ix;
		int term = 0;
		if( !getLineNumber(text, ix, term) ) return false;
		if( op == '+' )
			value += term;
		else
			value -= term;
	}
	return true;
}
bool ViEngine::getLineNumber(const QString &text, int &ix, int &lineNumber)
{
	lineNumber = 0;
	if( ix >= text.length() ) return false;
	if( text[ix] == '.' ) {
		++ix;
		lineNumber = m_curLineNum;
		return true;
	}
	if( text[ix] == '$' ) {
		++ix;
		if( m_editor == 0 ) return 1;
		QTextBlock block = m_editor->document()->lastBlock();
		lineNumber = block.blockNumber() + 1;
		if( lineNumber > 1 && block.text().isEmpty() )
			--lineNumber;
		return true;
	}
	if( !text[ix].isDigit() ) return false;
	while( ix < text.length() && text[ix].isDigit() )
		lineNumber = lineNumber * 10 + (text[ix++].unicode() - '0');
	return true;
}
