#pragma once

//----------------------------------------------------------------------
//
//			File:			"mainwindow.h"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include "vi.h"

class ViEditView;
class ViEngine;
class QLineEdit;
class QPlainTextEdit;
class QAction;

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
    MainWindow(const QString &fileName, QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public:
	const QStringList &findStrings() const { return m_findStrings; }

public slots:
	void	onImeOpenStatusChanged();
	void	onModeChanged(Mode, ushort=0);
	void	cmdLineTextChanged(const QString & text);
	void	cmdLineReturnPressed();
	void	cmdLineCursorPositionChanged(int, int);
	void	setFocusToCmdLine();
	void	showMessage(const QString & text);
	void	closeView(ViEditView*, bool = false);
	void	closeAllViews(bool = false);
	void	open(const QString &);
	void	save(const QString &);
    void	openRecentFile();
	void	doOutput(const QString &);
	void	clearOutput();
	void	testViCommands(const QString &fileName);
	void	doJump(int lineNum);
	void	onRegexpSearced(const QString &);

protected:
	bool	eventFilter(QObject *obj, QEvent *event);
	QString	findCommand(const QStringList cmds, const QString text, bool);
	void	closeEvent(QCloseEvent *event);

	void	init();
	void	createActions();
	void	createMenus();
	void	createToolBars();
	void	createDockWindows();	void	readSettings();
	void	writeSettings();

    void	setCurrentFile(const QString &fileName);
    void	updateWindowTitle();
    void	updateCurFile();
	bool	maybeSave();
	bool	saveFile(const QString &fileName, bool = true);
	void	loadFile(const QString &fileName, int lineNum = 1);
    MainWindow	*findMainWindow(const QString &fileName);
    void	updateRecentFileActions();
    QString strippedName(const QString &fullFileName);

private slots:
	void	newFile();
	void	open();
	bool	save();
	bool	saveAs();
	//void	closeAll();
    void	documentWasModified(bool = true);
    void	showAboutDlg();

private:
	QString	m_curFile;
	bool	m_isUntitled;
	bool	m_isModified;
	QStringList	m_findStrings;		//	iK\j񗚗

	ViEditView	*m_editor;
	ViEngine	*m_viEngine;
	QLineEdit	*m_cmdLineEdit;
	QString		m_cmdText;			//	QLineEdit Ɏۂɓ͂ꂽeLXg
	QPlainTextEdit	*m_output;

	QAction *newAct;
	QAction *openAct;
	QAction *saveAct;
	QAction *saveAsAct;
	QAction *closeAllAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *undoAct;
    QAction *redoAct;

    QAction *aboutAct;

	//QAction		*m_drawTextAct;

	int		m_exCmdsIx;

    QAction *separatorMRUAct;
    enum { MaxRecentFiles = 10 };
    QAction *recentFileActs[MaxRecentFiles];
};

#endif // MAINWINDOW_H
