//----------------------------------------------------------------------
//
//			File:			"viCursor.cpp"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	viJ[\ړ֐
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#include <QtGui>
#include "viCursor.h"

#if 0
//	siCR/LF/CRLFjʒuԂ
int EOLOffset(const QString &text)
{
	int ix = text.length();
	if( ix != 0 ) {
		if( text[ix-1] == 0x0d )
			--ix;
		if( text[ix-1] == 0x0a ) {
			if( ix > 1 && text[ix-2] == 0x0d )
				ix -= 2;
			else
				--ix;
		}
	}
	return ix;
}
#endif
inline bool isTabOrSpace(const QChar ch)
{
	return ch == '\t' || ch == ' ';
}
int firstNonBlankCharPos(const QString &text)
{
	int ix = 0;
	while( ix < text.length() && isTabOrSpace(text[ix]) )
		++ix;
	return ix;
}
void moveToFirstNonBlankChar(QTextCursor &cur)
{
	QTextBlock block = cur.block();
	const int blockPos = block.position();
	const QString blockText = block.text();
	if( !blockText.isEmpty() )
		cur.setPosition(blockPos + firstNonBlankCharPos(blockText));
}
bool gotoNextWord(QTextCursor &cur, int n, bool cdy)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	^Cvǂݔ΂
		if( ix < text.length() && !isTabOrSpace(text[ix]) ) {
			uchar cat = getCharType(text[ix++]);
			//QChar::Category cat = text[ix++].category();
			while( ix < text.length() && !isTabOrSpace(text[ix]) && getCharType(text[ix]) == cat )
				++ix;
		}
		//	󔒗ނǂݔ΂
		while( ix == text.length() || isTabOrSpace(text[ix]) ) {
			if( ix == text.length() ) {
				if( cdy && !n )	//	cdy OuĂꍇ́AŌ̉s̓XLbvȂ
					break;
				block = block.next();
				if( !block.isValid() ) {
					cur.setPosition(blockPos + ix);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = 0;
			} else
				++ix;
		}
	}
	cur.setPosition(blockPos + ix);
	return true;
}
bool gotoPrevWord(QTextCursor &cur, int n)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	ЂƂO̕󔒗 or sȂ當擪Ɉړ
		while( !ix || isTabOrSpace(text[ix-1]) ) {
			if( !ix ) {
				block = block.previous();
				if( !block.isValid() ) {
					cur.setPosition(blockPos);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = text.length();
			} else
				--ix;
		}
		//	ЂƂO̕^Cv and 󔒗ނɂȂ܂ or s܂œǂݔ΂
		if( ix > 0 && !isTabOrSpace(text[ix-1]) ) {
			uchar cat = getCharType(text[--ix]);
			while( ix > 0 && !isTabOrSpace(text[ix-1]) && getCharType(text[ix-1]) == cat )
				--ix;
		}
	}
	cur.setPosition(blockPos + ix);
	return true;
}
bool gotoNextWordEnd(QTextCursor &cur, int n, bool cdy)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	̕󔒗 or sȂ當Ɉړ
		while( ix + 1 >= text.length() || isTabOrSpace(text[ix+1]) ) {
			if( ix + 1 >= text.length() ) {
				block = block.next();
				if( !block.isValid() ) {
					cur.setPosition(blockPos);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = 0;
				if( ix < text.length() && !isTabOrSpace(text[ix]) )
					break;
			} else
				++ix;
		}
		//	̕󔒗ނɂȂ܂ or s܂œǂݔ΂
		if( ix + 1 < text.length() && !isTabOrSpace(text[ix+1]) ) {
			uchar cat = getCharType(text[++ix]);
			while( ix + 1 < text.length() && !isTabOrSpace(text[ix+1]) && getCharType(text[ix+1]) == cat )
				++ix;
		}
	}
	if( cdy ) ++ix;
	cur.setPosition(blockPos + ix);
	return true;
}
bool gotoNextSSWord(QTextCursor &cur, int n, bool cdy)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	󔒗ނ܂œǂݔ΂
		while( ix < text.length() && !isTabOrSpace(text[ix]) )
			++ix;
		//	󔒗ނǂݔ΂
		while( ix == text.length() || isTabOrSpace(text[ix]) ) {
			if( ix == text.length() ) {
				if( cdy && !n )	//	cdy OuĂꍇ́AŌ̉s̓XLbvȂ
					break;
				block = block.next();
				if( !block.isValid() ) {
					cur.setPosition(blockPos + ix);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = 0;
			} else
				++ix;
		}
	}
	cur.setPosition(blockPos + ix);
	return true;
}
bool gotoPrevSSWord(QTextCursor &cur, int n)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	ЂƂO̕󔒗 or sȂ當擪Ɉړ
		while( !ix || isTabOrSpace(text[ix-1]) ) {
			if( !ix ) {
				block = block.previous();
				if( !block.isValid() ) {
					cur.setPosition(blockPos);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = text.length();
			} else
				--ix;
		}
		//	ЂƂO̕󔒗ނɂȂ܂ or s܂œǂݔ΂
		while( ix > 0 && !isTabOrSpace(text[ix-1]) )
			--ix;
	}
	cur.setPosition(blockPos + ix);
	return true;
}
/**
	NextSSWord  PrevSSWord Ώ̓Ił͂ȂA
	 PrevSSWord  NextSSWordEnd Ώ̓I
*/
bool gotoNextSSWordEnd(QTextCursor &cur, int n, bool cdy)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString text = block.text();
	int ix = cur.position() - blockPos;
	while( --n >= 0 ) {
		//	̕󔒗 or sȂ當Ɉړ
		while( ix + 1 >= text.length() || isTabOrSpace(text[ix+1]) ) {
			if( ix + 1 >= text.length() ) {
				block = block.next();
				if( !block.isValid() ) {
					cur.setPosition(blockPos);
					return true;
				}
				blockPos = block.position();
				text = block.text();
				ix = 0;
				if( ix < text.length() && !isTabOrSpace(text[ix]) )
					break;
			} else
				++ix;
		}
		//	̕󔒗ނɂȂ܂ or s܂œǂݔ΂
		while( ix + 1 < text.length() && !isTabOrSpace(text[ix+1]) )
			++ix;
	}
	if( cdy ) ++ix;
	cur.setPosition(blockPos + ix);
	return true;
}

/**
*/
bool gotoBeginBlock(QTextCursor &cur, bool forward, int n)
{
	QTextBlock block = cur.block();
	if( !block.isValid() ) return false;
	int lastPos = block.position();
	while( --n >= 0 ) {
		for(;;) {
			block = forward ? block.next() : block.previous();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
			const QString text = block.text();
			if( !text.isEmpty() && text[0] == '{' )
				break;
		}
	}
	cur.setPosition(lastPos);
	return true;
}
#if 1
bool gotoBlankLine(QTextCursor &cur, bool forward, int n)
{
	QTextBlock block = cur.block();
	if( !block.isValid() ) return false;
	int lastPos = block.position();
	while( --n >= 0 ) {
		//	sǂݔ΂
		while( block.text().length() == 0 ) {
			block = forward ? block.next() : block.previous();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
		//	s܂œǂݔ΂
		while( block.text().length() != 0 ) {
			block = forward ? block.next() : block.previous();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
	}
	cur.setPosition(lastPos);
	return true;
}
#else
bool gotoNextBlankLine(QTextCursor &cur, int n)
{
	QTextBlock block = cur.block();
	if( !block.isValid() ) return false;
	int lastPos = block.position();
	while( --n >= 0 ) {
		//	sǂݔ΂
		while( EOLOffset(block.text()) == 0 ) {
			block = block.next();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
		//	s܂œǂݔ΂
		while( EOLOffset(block.text()) != 0 ) {
			block = block.next();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
	}
	cur.setPosition(lastPos);
	return true;
}
bool gotoPrevBlankLine(QTextCursor &cur, int n)
{
	QTextBlock block = cur.block();
	if( !block.isValid() ) return false;
	int lastPos = block.position();
	while( --n >= 0 ) {
		//	sǂݔ΂
		while( EOLOffset(block.text()) == 0 ) {
			block = block.previous();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
		//	s܂œǂݔ΂
		while( EOLOffset(block.text()) != 0 ) {
			block = block.previous();
			if( !block.isValid() ) {
				cur.setPosition(lastPos);
				return true;
			}
			lastPos = block.position();
		}
	}
	cur.setPosition(lastPos);
	return true;
}
#endif
bool gotoMatchParen(QTextCursor &cur)
{
	QTextBlock block = cur.block();
	int blockPos = block.position();
	QString blockText = block.text();
	int ix = cur.position() - blockPos;
	bool forward = true;
	QChar paren, dst;
	while( ix < blockText.length() ) {
		if( blockText[ix] == '{' ) { paren = '{'; dst = '}'; break; }
		if( blockText[ix] == '(' ) { paren = '('; dst = ')'; break; }
		if( blockText[ix] == '[' ) { paren = '['; dst = ']'; break; }
		if( blockText[ix] == '}' ) { paren = '}'; dst = '{'; forward = false; break; }
		if( blockText[ix] == ')' ) { paren = ')'; dst = '('; forward = false; break; }
		if( blockText[ix] == ']' ) { paren = ']'; dst = '['; forward = false; break; }
		++ix;
	}
	if( paren == QChar() ) return false;
	int count = 1;
	if( forward ) {
		for(;;) {
			while( ++ix < blockText.length() ) {
				if( blockText[ix] == paren )
					++count;
				else if( blockText[ix] == dst && !--count ) {
					cur.setPosition(blockPos + ix);
					return true;
				}
			}
			block = block.next();
			if( !block.isValid() )
				break;
			blockPos = block.position();
			blockText = block.text();
			ix = -1;
		}
	} else {
		for(;;) {
			while( --ix >= 0 ) {
				if( blockText[ix] == paren )
					++count;
				else if( blockText[ix] == dst && !--count ) {
					cur.setPosition(blockPos + ix);
					return true;
				}
			}
			block = block.previous();
			if( !block.isValid() )
				break;
			blockPos = block.position();
			blockText = block.text();
			ix = blockText.length();
		}
	}
	return false;
}
/**
	@return		J[\ړꍇ true

	㉺ړ̓ubN擪̂ψʂۑB
		cur.block().layout().lineAt()  QTextLine 擾A
		QTextLine::cursorToX(int) : qreal xψʎ擾A
		QTextLine::xToCursor ( qreal x ) : int łψʁJ[\ʒu擾
	
*/
bool moveCursor(QTextCursor &cur, //int &x,
				int mv, int n,
				bool cdy,		//	{c|d|y} OuĂ
				const QTextBlock *visibleBlock)
{
	const int pos = cur.position();
	QTextBlock block = cur.block();
	const int blockPos = block.position();
	const QString blockText = block.text();
	switch( mv ) {
	case ViMoveOperation::Up:
		mv = QTextCursor::Up;
		break;
	case ViMoveOperation::Down:
		mv = QTextCursor::Down;
		break;
	case ViMoveOperation::Left:
		n = qMin(n, pos - blockPos);
		mv = QTextCursor::Left;
		break;
	case ViMoveOperation::Right: {
		if( blockText.isEmpty() ) return false;		//	s or EOF I[s̏ꍇ
		const int endpos = blockPos + blockText.length() - 1;
		//const int endpos = blockPos + EOLOffset(blockText) - 1;
		if( pos >= endpos ) return false;
		n = qMin(n, endpos - pos);
		mv = QTextCursor::Right;
		break;
	}
	case ViMoveOperation::RightForA: {			//	Eړ for a R}h
		if( blockText.isEmpty() ) return false;		//	s or EOF I[s̏ꍇ
		const int endpos = blockPos + blockText.length();
		//const int endpos = blockPos + EOLOffset(blockText);
		if( pos >= endpos ) return false;
		n = qMin(n, endpos - pos);
		mv = QTextCursor::Right;
		break;
#if 0
		if( pos >= blockPos + EOLOffset(blockText)) return false;
		cur.setPosition(pos + 1);
		return true;
#endif
	}
	case ViMoveOperation::FirstNonBlankChar:
		cur.setPosition(blockPos + firstNonBlankCharPos(blockText));
		return true;
	case ViMoveOperation::LastChar: {
		int ix = blockText.length();
		//int ix = EOLOffset(blockText);
		if( !cdy && ix != 0 ) --ix;
		cur.setPosition(blockPos + ix);
		cur.setVerticalMovementX(-1);
		return true;
	}
	case ViMoveOperation::NextWord:
		return gotoNextWord(cur, n, cdy);
	case ViMoveOperation::PrevWord:
		return gotoPrevWord(cur, n);
	case ViMoveOperation::NextWordEnd:
		return gotoNextWordEnd(cur, n, cdy);
	case ViMoveOperation::NextSSWord:
		return gotoNextSSWord(cur, n, cdy);
	case ViMoveOperation::PrevSSWord:
		return gotoPrevSSWord(cur, n);
	case ViMoveOperation::NextSSWordEnd:
		return gotoNextSSWordEnd(cur, n, cdy);
	case ViMoveOperation::NextLine:
		cur.movePosition(QTextCursor::NextBlock, QTextCursor::MoveAnchor, n);
		moveToFirstNonBlankChar(cur);
		return true;
	case ViMoveOperation::PrevLine:
		cur.movePosition(QTextCursor::PreviousBlock, QTextCursor::MoveAnchor, n);
		moveToFirstNonBlankChar(cur);
		return true;
	case ViMoveOperation::MatchParen:
		return gotoMatchParen(cur);
	case ViMoveOperation::NextBlankLine:
		return gotoBlankLine(cur, /*forward=*/true, n);
	case ViMoveOperation::PrevBlankLine:
		return gotoBlankLine(cur, /*forward=*/false, n);
	case ViMoveOperation::NextBeginBlock:
		return gotoBeginBlock(cur, /*forward=*/true, n);
	case ViMoveOperation::PrevBeginBlock:
		return gotoBeginBlock(cur, /*forward=*/false, n);
	case ViMoveOperation::TopOfView:
		block = *visibleBlock;
		while( --n > 0 ) {
			QTextBlock next = block.next();
			if( !next.isValid() ) break;
			block = next;
		}
		cur.setPosition(block.position() + firstNonBlankCharPos(block.text()));
		return true;
	case ViMoveOperation::BottomOfView:
		block = *visibleBlock;
		while( --n > 0 ) {
			QTextBlock next = block.previous();
			if( !next.isValid() ) break;
			block = next;
		}
		cur.setPosition(block.position() + firstNonBlankCharPos(block.text()));
		return true;
	case ViMoveOperation::JumpLine:
		block = block.document()->findBlockByNumber(n - 1);
		//block.setLineCount(n);
		if( block.isValid() ) {
			cur.setPosition(block.position() + firstNonBlankCharPos(block.text()));
			return true;
		}
		//	ɃX[
	case ViMoveOperation::LastLine:
		cur.movePosition(QTextCursor::End);
		block = cur.block();
		if( block.text().isEmpty() 			//	EOFs̏ꍇ
			&& block.previous().isValid() )		//	Os݂ꍇ
		{
			block = block.previous();
		}
		cur.setPosition(block.position() + firstNonBlankCharPos(block.text()));
		return true;
	}
	cur.movePosition(static_cast<QTextCursor::MoveOperation>(mv), QTextCursor::MoveAnchor, n);
	return true;
}

bool moveCursorFindInLine(QTextCursor &cur, ushort cmd, const QChar &qch, int n)
{
	QTextBlock block = cur.block();
	QString text = block.text();
	int ix = cur.position() - block.position();
	while( --n >= 0 ) {
		for(;;) {
			if( cmd == 'f' || cmd == 't' ) {
				if( ix == text.length() )
					return false;	//	nԖڂ̕oȂꍇ̓J[\ړȂ
				++ix;
			} else {
				if( !ix )
					return false;	//	nԖڂ̕oȂꍇ̓J[\ړȂ
				--ix;
			}
			if( text[ix] == qch )
				break;
		}
	}
	if( cmd == 't' )
		--ix;
	else if( cmd == 'T' )
		++ix;
	cur.setPosition(block.position() + ix);
	return true;
}

int moveCursorFindForward(const QRegExp &rex, QTextBlock &block, int ix, int &nth, int limit)
{
	for(;;) {
		int i = rex.indexIn(block.text(), ix);
		if( i >= 0 ) {
			if( !--nth ) {
				int pos = i + block.position();
				if( limit < 0 || pos <= limit ) {		//	J[\ʒuɈĖ߂ĂꍇOK
					return pos;
				} else
					return -1;
			}
			ix = i + 1;
		} else {
			ix = 0;
			block = block.next();
			if( !block.isValid() || limit >= 0 && block.position() > limit )
				return -1;
		}
	}
}
int moveCursorFindBackward(const QRegExp &rex, QTextBlock &block, int ix, int &nth, int limit)
{
	int i;
	for(;;) {
		if( ix >= 0 && (i = rex.lastIndexIn(block.text(), ix)) >= 0 ) {	//	ix = -1 w肷ƍŌォ猟Ă܂
			if( !--nth ) {
				int pos = i + block.position();
				if( limit < 0 || pos >= limit ) {		//	J[\ʒuɈĖ߂ĂꍇOK
					return pos;
				} else
					return -1;
			}
			ix = i - 1;
		} else {
			block = block.previous();
			if( !block.isValid() || limit >= 0 && block.position() < limit )
				return -1;
			ix = block.text().length();
		}
	}
}
bool moveCursorFind(QTextCursor &cur, const QRegExp &rex, bool forward, int nth)
{
	QTextBlock block = cur.block();
	int curPos = cur.position();
	int ix = curPos - block.position();
	int pos;
	if( forward ) {
		++ix;
		if( (pos = moveCursorFindForward(rex, block, ix, nth, -1)) >= 0 ) {
			cur.setPosition(pos);
			return true;
		}
		//	͖܂łɌȂA擪猟
		block = block.document()->firstBlock();
		ix = 0;
		if( (pos = moveCursorFindForward(rex, block, ix, nth, curPos)) >= 0 ) {
			cur.setPosition(pos);
			return true;
		}
	} else {
		--ix;
		if( (pos = moveCursorFindBackward(rex, block, ix, nth, -1)) >= 0 ) {
			cur.setPosition(pos);
			return true;
		}
		//	͐擪܂łɌȂA猟
		block = block.document()->lastBlock();
		ix = block.text().length();
		if( (pos = moveCursorFindBackward(rex, block, ix, nth, curPos)) >= 0 ) {
			cur.setPosition(pos);
			return true;
		}
	}
	return false;
}

//----------------------------------------------------------------------
static uchar sbCharTypeTbl[] = {
/* 0 */	CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER,
		CT_OTHER, CT_SPACE, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER,
/* 1 */	CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER,
		CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER, CT_OTHER,
/* 2 */	CT_SPACE, CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,		//	  ! " # $ % & '
		CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,		//	( ) * + , - . /
/* 3 */	CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	0 CT_ALNUM 2 3 4 5 6 7
		CT_ALNUM, CT_ALNUM, CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,		//	8 9 : ; < = > ?
/* 4 */	CT_SYM,   CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	@ A B C D E F G
		CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	H I J K L M N O
/* 5 */	CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	P Q R S T U V W
		CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_ALNUM,		//	X Y Z [ \ ] ^ _
/* 6 */	CT_SYM,   CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	` a b c d e f g
		CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	h i j k l m n o
/* 7 */	CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_ALNUM,		//	p q r s t u v w
		CT_ALNUM, CT_ALNUM, CT_ALNUM, CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,   CT_SYM,		//	x y z { | } ~
};

uchar getCharType(QChar ch)
{
	const ushort code = ch.unicode();
	if( code < 0x80 )
		return sbCharTypeTbl[code];
	if( code <= 0xa0 ) return CT_OTHER;
	if( code <= 0xbf ) return CT_SYM;
	if( code <= 0x2af ) return CT_ALNUM;
	if( code <= 0x36f ) return CT_GREEK;
	if( code >= 0x3040 && code < 0x30a0 ) return CT_HIRA;
	if( code >= 0x30a0 && code < 0x3100 ) return CT_KANA;
	if( code >= 0x4e00 && code < 0xa000 ) return CT_KANJI;
	return CT_SYM;
}

//----------------------------------------------------------------------
ViCursor::ViCursor()
	: m_nthLine(0)
{
}
ViCursor::ViCursor(const ViCursor &cur)
	: QTextCursor(cur), m_nthLine(cur.m_nthLine)
{
}
ViCursor::ViCursor(const QTextCursor &cur, int nthLine)
	: QTextCursor(cur), m_nthLine(nthLine)
{
}
#if 0
bool ViCursor::movePosition(MoveOperation operation, MoveMode mode, int n)
{
	return QTextCursor::movePosition(operation, mode, n);
}
#endif

bool ViCursor::movePosition(
				int mv,			//	ړ
				MoveMode mode,	//	AJ[ړ or L[v
				int n,			//	JԂ
				bool cdy,		//	{c|d|y} OuĂ
				const QTextBlock *visibleBlock)		//	ʍŏs or ŉs
{
#if 0
	if( mv < Left ) {
		QTextCursor::movePosition(mv
	}
#endif
	const int pos = QTextCursor::position();
	QTextBlock block = QTextCursor::block();
	const int blockPos = block.position();
	const QString blockText = block.text();
	switch( mv ) {
	case ViMoveOperation::Up:
		for(int i = 0; i < n; ++i) {
			if( !block.previous().isValid() ) break;
			block = block.previous();
		}
		//if( !(block = block.previous()).isValid() ) return false;
		moveXAtNthLine(block);
		//QTextCursor::movePosition(QTextCursor::Up, QTextCursor::MoveAnchor, n);
		if( !cdy ) moveLeftIfEndOfLine();
		return true;
	case ViMoveOperation::Down:
		for(int i = 0; i < n; ++i) {
			if( !block.next().isValid() ) break;
			block = block.next();
		}
		//if( !(block = block.next()).isValid() ) return false;
		moveXAtNthLine(block);
		//QTextCursor::movePosition(QTextCursor::Down, QTextCursor::MoveAnchor, n);
		if( !cdy ) moveLeftIfEndOfLine();
		return true;
	case ViMoveOperation::Left:
		n = qMin(n, pos - blockPos);
		mv = QTextCursor::Left;
		break;
	case ViMoveOperation::Right: {
		if( blockText.isEmpty() ) return false;		//	s or EOF I[s̏ꍇ
		const int endpos = blockPos + blockText.length() - 1;
		if( pos >= endpos ) return false;
		n = qMin(n, endpos - pos);
		mv = QTextCursor::Right;
		break;
	}
	case ViMoveOperation::JumpLine:
		block = block.document()->findBlockByNumber(n - 1);
		if( block.isValid() ) {
			setPosition(block.position() + firstNonBlankCharPos(block.text()));
			return true;
		}
		//	ɃX[
	case ViMoveOperation::LastLine:
		QTextCursor::movePosition(QTextCursor::End);
		block = QTextCursor::block();
		if( block.text().isEmpty() 			//	EOFs̏ꍇ
			&& block.previous().isValid() )		//	Os݂ꍇ
		{
			block = block.previous();
		}
		setPosition(block.position() + firstNonBlankCharPos(block.text()));
		return true;
	case ViMoveOperation::PrevWord:
		return gotoPrevWord(*this, n);
	case ViMoveOperation::FirstNonBlankChar:
		setPosition(blockPos + firstNonBlankCharPos(blockText), mode);
		return true;
	}
	QTextCursor::movePosition(static_cast<QTextCursor::MoveOperation>(mv), mode, n);
	//QTextLayout layout = block().layout();
	//QTextLine textLine = QTextCursor::block().layout()->lineForTextPosition(position());
	//m_nthLine = textLine.lineNumber();
	calcNthLine();
	qDebug() << "lineNumber = " << m_nthLine;

	return true;
}

void ViCursor::moveXAtNthLine(const QTextBlock &block)
{
	int x = verticalMovementX();
	const QTextLayout *layout = block.layout();
	if( x < 0 ||		//	$ ̏ꍇ -1 ZbgĂ
		m_nthLine >= layout->lineCount() )
	{
		setPosition(block.position() + block.text().length());
	} else {
		QTextLine textLine = layout->lineAt(m_nthLine);
		setPosition(block.position() + textLine.xToCursor(x));
	}
	setVerticalMovementX(x);	//	VerticalMovementX ̒lωĂ̂ōĐݒ
}

int ViCursor::calcNthLine()
{
#if 1
	const QTextLayout *layout = QTextCursor::block().layout();
	const QTextLine textLine = layout->lineForTextPosition(positionInBlock());
	return m_nthLine = textLine.lineNumber();
#else
	const int pos = position();
	const QTextLayout *layout = QTextCursor::block().layout();
	for(int i = 0; i < layout->lineCount(); ++i) {
		const QTextLine textLine = layout->lineAt(i);
		if( pos < textLine.textStart() + textLine.textLength() )
			return m_nthLine = i;
	}
	return m_nthLine = 0;
#endif
}

void ViCursor::moveLeftIfEndOfLine()
{
	QTextBlock block = QTextCursor::block();
	const int length = block.text().length();
	if( length != 0 && position() == block.position() + length ) {
		const int x = verticalMovementX();	//	x ψقۑ
		QTextCursor::movePosition(QTextCursor::Left);
		setVerticalMovementX(x);
	}
}
