/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.date.jodatime;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springmodules.validation.util.condition.date.jodatime.AbstractInstantCondition;

public class IsAfterInstantCondition
extends AbstractInstantCondition {
    private ReadableInstant earlier;

    public IsAfterInstantCondition(ReadableInstant earlier) {
        this.earlier = earlier;
    }

    public IsAfterInstantCondition(Date earlier) {
        this.earlier = new DateTime(earlier.getTime());
    }

    public IsAfterInstantCondition(Calendar earlier) {
        this.earlier = new DateTime(earlier.getTimeInMillis(), DateTimeZone.forTimeZone((TimeZone)earlier.getTimeZone()));
    }

    protected boolean checkInstant(ReadableInstant instant) {
        return this.earlier.isBefore(instant);
    }

    public ReadableInstant getEarlier() {
        return this.earlier;
    }
}

