/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class DefaultArchiveRemover
implements ArchiveRemover {
    final FileNamePattern fileNamePattern;
    final RollingCalendar rc;
    int maxHistory;
    int periodOffset;
    final boolean parentClean;

    public DefaultArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        this.fileNamePattern = fileNamePattern;
        this.rc = rc;
        this.parentClean = this.computeParentCleaningFlag(fileNamePattern);
    }

    boolean computeParentCleaningFlag(FileNamePattern fileNamePattern) {
        Converter<Object> p;
        DateTokenConverter dtc = fileNamePattern.getDateTokenConverter();
        if (dtc.getDatePattern().indexOf(47) != -1) {
            return true;
        }
        for (p = fileNamePattern.headTokenConverter; p != null && !(p instanceof DateTokenConverter); p = p.getNext()) {
        }
        while (p != null) {
            String s;
            if (p instanceof LiteralConverter && (s = p.convert(null)).indexOf(47) != -1) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    public void clean(Date now) {
        Date date2delete = this.rc.getRelativeDate(now, this.periodOffset);
        String filename = this.fileNamePattern.convert(date2delete);
        File file2Delete = new File(filename);
        if (file2Delete.exists() && file2Delete.isFile()) {
            file2Delete.delete();
            if (this.parentClean) {
                this.removeFolderIfEmpty(file2Delete.getParentFile(), 0);
            }
        }
    }

    void removeFolderIfEmpty(File dir, int recursivityCount) {
        if (recursivityCount >= 3) {
            return;
        }
        if (dir.isDirectory() && FileFilterUtil.isEmptyDirectory(dir)) {
            dir.delete();
            this.removeFolderIfEmpty(dir.getParentFile(), recursivityCount + 1);
        }
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        this.periodOffset = -maxHistory - 1;
    }
}

