/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    private boolean contextRelative = false;
    private boolean http10Compatible = true;
    private boolean exposeModelAttributes = true;
    private String encodingScheme;

    public RedirectView() {
    }

    public RedirectView(String url) {
        super(url);
    }

    public RedirectView(String url, boolean contextRelative) {
        super(url);
        this.contextRelative = contextRelative;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
    }

    public RedirectView(String url, boolean contextRelative, boolean http10Compatible, boolean exposeModelAttributes) {
        super(url);
        this.contextRelative = contextRelative;
        this.http10Compatible = http10Compatible;
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setHttp10Compatible(boolean http10Compatible) {
        this.http10Compatible = http10Compatible;
    }

    public void setExposeModelAttributes(boolean exposeModelAttributes) {
        this.exposeModelAttributes = exposeModelAttributes;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer targetUrl = new StringBuffer();
        if (this.contextRelative && this.getUrl().startsWith("/")) {
            targetUrl.append(request.getContextPath());
        }
        targetUrl.append(this.getUrl());
        if (this.exposeModelAttributes) {
            String enc = this.encodingScheme;
            if (enc == null) {
                enc = request.getCharacterEncoding();
            }
            if (enc == null) {
                enc = "ISO-8859-1";
            }
            this.appendQueryProperties(targetUrl, model, enc);
        }
        this.sendRedirect(request, response, targetUrl.toString(), this.http10Compatible);
    }

    protected void appendQueryProperties(StringBuffer targetUrl, Map model, String encodingScheme) throws UnsupportedEncodingException {
        String fragment = null;
        int anchorIndex = targetUrl.indexOf("#");
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean first = this.getUrl().indexOf(63) < 0;
        Iterator entries = this.queryProperties(model).entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = entry.getKey().toString();
            Object rawValue = entry.getValue();
            Iterator<Object> valueIter = null;
            valueIter = rawValue != null && rawValue.getClass().isArray() ? Arrays.asList(ObjectUtils.toObjectArray(rawValue)).iterator() : (rawValue instanceof Collection ? ((Collection)rawValue).iterator() : Collections.singleton(rawValue).iterator());
            while (valueIter.hasNext()) {
                Object value = valueIter.next();
                if (first) {
                    targetUrl.append('?');
                    first = false;
                } else {
                    targetUrl.append('&');
                }
                String encodedKey = this.urlEncode(key, encodingScheme);
                String encodedValue = value != null ? this.urlEncode(value.toString(), encodingScheme) : "";
                targetUrl.append(encodedKey).append('=').append(encodedValue);
            }
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected Map queryProperties(Map model) {
        LinkedHashMap result = new LinkedHashMap();
        Iterator it = model.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            Map.Entry entry = it.next();
            String key = entry.getKey().toString();
            if (!this.isEligibleProperty(key, value = entry.getValue())) continue;
            result.put(key, value);
        }
        return result;
    }

    protected boolean isEligibleProperty(String key, Object value) {
        if (value == null) {
            return false;
        }
        if (this.isEligibleValue(value)) {
            return true;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            if (coll.isEmpty()) {
                return false;
            }
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (this.isEligibleValue(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEligibleValue(Object value) {
        return value != null && BeanUtils.isSimpleValueType(value.getClass());
    }

    protected String urlEncode(String input, String encodingScheme) throws UnsupportedEncodingException {
        return input != null ? URLEncoder.encode(input, encodingScheme) : null;
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
        if (http10Compatible) {
            response.sendRedirect(response.encodeRedirectURL(targetUrl));
        } else {
            response.setStatus(303);
            response.setHeader("Location", response.encodeRedirectURL(targetUrl));
        }
    }
}

