/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.controllers;

/**
 * Rabbit BTS用インターフェース
 */
public interface IController {
	/**
	 * CSRFセーフなアクセスならtrueをセット
	 * 
	 * @param csrfSafe
	 *            falseなら危険なアクセスなので更新処理は禁止
	 */
	public void setCsrfSafe(boolean csrfSafe);

	/**
	 * 処理完了時までにisCsrfChecked()を呼び出していない場合false.
	 * 
	 * @return the csrfChecked
	 */
	public boolean isCsrfChecked();
}
