/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.dao.jdo;

import java.util.Collection;

import jp.sourceforge.rabbitBTS.dao.AccountDao;
import jp.sourceforge.rabbitBTS.models.Account;

/**
 *
 */
public class AccountDaoImpl extends GenericDaoJdo<Account, Long> implements
		AccountDao {

	public AccountDaoImpl() {
		super(Account.class);
	}

	public Account findAccountByEmail(String email) {
		final Collection<Account> c = getJdoTemplate().find(Account.class,
				"email == e", "String e", new Object[] { email });
		if (c.isEmpty()) {
			return null;
		} else {
			return c.iterator().next();
		}
	}

	public Account findAccountByNickName(String nickName) {
		final Collection<Account> c = getJdoTemplate().find(Account.class,
				"nickName == n", "String n", new Object[] { nickName });
		if (c.isEmpty()) {
			return null;
		} else {
			return c.iterator().next();
		}
	}

}
