/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * foCXւ̕o
 * $Id: rbtDevice.c 12 2012-07-11 17:45:33Z xeerda $
 *****************************************************************************/
#include "rbtDevice.h"

RBTOS_DeviceT *devCon;

unsigned char fCritical = 0;


enum VALFLAG {
	VAL_XMODE	= (1 << 0), 	/* 16ił̕\w蒆 			 */
	VAL_ZERO	= (1 << 1), 	/* w莞C󂢂󔒂0Ŗ߂	 */
	VAL_LENGTH	= (1 << 2), 	/* wL 						 */
	VAL_NUMMODE = (1 << 3), 	/* w萔lǂݎ蒆 			 */
	VAL_LONG	= (1 << 4),
	VAL_HEX		= (1 << 5),
};

#define VS_OUTPUT_PRINTF_BUFFSIZE	9


typedef struct _OUTBUFF {
	RBTOS_DeviceT *dd;
	signed char index;
	unsigned char nLength;
	unsigned char vflag;
	char fPrevCR;
	char buff[VS_OUTPUT_PRINTF_BUFFSIZE];
	char numstr[12];
} OUTBUFF;
//static OUTBUFF obuf;
static const char NUMCHAR[] = "0123456789ABCDEF";
RBTOS_LockT lockPrint = RBTOS_INITIALIZED_LOCK_VALUE;



int dev_getchar(RBTOS_DeviceT *dd)
{
	unsigned char c;
	dd->d_read((char*) &c, 1);
	return c;
}

void dev_putchar(RBTOS_DeviceT *dd, char c)
{
	dd->d_write(&c, 1);
}

void dev_putwchar(RBTOS_DeviceT *dd, RBTOS_WCHAR_T c)
{
	unsigned char buff[3];
	int len = 1;
 	if (c < 0x80) {
		buff[0] = c;
	} else if (c < 0x800) {
		buff[0] = (c >> 6) | 0xC0;
		buff[1] = (c & 0x3F) | 0x80;
		len = 2;
	} else {
		buff[0] = (c >> 12) | 0xE0;
		buff[1] = ((c >> 6) & 0x3F) | 0x80;
		buff[2] = (c & 0x3F) | 0x80;
		len = 3;
	}
	dd->d_write((char*) buff, len);
}


int dev_putstring(RBTOS_DeviceT *dd, const char *msg)
{
	int len = strlen(msg);
	return dd->d_write(msg, len);
}


static void xCvtPutChar(OUTBUFF *obuf, char c)
{
	if (obuf->index == VS_OUTPUT_PRINTF_BUFFSIZE) {
		obuf->dd->d_write(obuf->buff, obuf->index);
		obuf->index = 0;
	}
	if (c == '\r') {
		obuf->fPrevCR = 1;
	} else {
		if (c == '\n') {
			if (!obuf->fPrevCR) {
				obuf->buff[obuf->index++] = '\r';
				if (obuf->index == VS_OUTPUT_PRINTF_BUFFSIZE) {
					obuf->dd->d_write(obuf->buff, obuf->index);
					obuf->index = 0;
				}
			}
		}
		obuf->fPrevCR = 0;
	}
	obuf->buff[obuf->index++] = c;
}

static void xCvtPutWchar(OUTBUFF *obuf, RBTOS_WCHAR_T c)
{
	if (obuf->index == VS_OUTPUT_PRINTF_BUFFSIZE) {
		obuf->dd->d_write(obuf->buff, obuf->index);
		obuf->index = 0;
	}
	if (c == '\r') {
		obuf->fPrevCR = 1;
	} else {
		if (c == '\n') {
			if (!obuf->fPrevCR) {
				obuf->buff[obuf->index++] = '\r';
				if (obuf->index == VS_OUTPUT_PRINTF_BUFFSIZE) {
					obuf->dd->d_write(obuf->buff, obuf->index);
					obuf->index = 0;
				}
			}
		}
		obuf->fPrevCR = 0;
	}
	if (c < 0x80) {
		obuf->buff[obuf->index++] = c;
	} else if (c < 0x800) {
		if ((VS_OUTPUT_PRINTF_BUFFSIZE - obuf->index) < 2) {
			obuf->dd->d_write(obuf->buff, obuf->index);
			obuf->index = 0;
		}
		obuf->buff[obuf->index++] = (c >> 6) | 0xC0;
		obuf->buff[obuf->index++] = (c & 0x3F) | 0x80;
	} else {
		if ((VS_OUTPUT_PRINTF_BUFFSIZE - obuf->index) < 3) {
			obuf->dd->d_write(obuf->buff, obuf->index);
			obuf->index = 0;
		}
		obuf->buff[obuf->index++] = (c >> 12) | 0xE0;
		obuf->buff[obuf->index++] = ((c >> 6) & 0x3F) | 0x80;
		obuf->buff[obuf->index++] = (c & 0x3F) | 0x80;
	}
}


static void xCvtPutWstring(OUTBUFF *obuf, RBTOS_WCHAR_T *msg)
{
	for (; *msg != '\0'; msg++) {
		xCvtPutWchar(obuf, *msg);
	}
}

static void xCvtPutString(OUTBUFF *obuf, const char *msg)
{
	for (; *msg != '\0'; msg++) {
		xCvtPutChar(obuf, *msg);
	}
}

static void xZeroChkWrite(OUTBUFF *obuf)
{
	if (obuf->vflag & VAL_LENGTH) {
		signed char len = obuf->nLength - strlen(obuf->numstr);
		if (len > 0) {
			char c = (obuf->vflag & VAL_ZERO) ? '0' : ' ';
			for (; len > 0; len--) {
				xCvtPutChar(obuf, c);
			}
		}
	}
	xCvtPutString(obuf, obuf->numstr);
}


/**
 * lẘ(10 ܂16) ŕɕϊ.
 * @param value l
 * @param str o͂镶ւ̃|C^
 */
static void xToNumString(unsigned long value, char *str, unsigned char vflag)
{
	unsigned long maxvalue;
	unsigned radix = 10;
	if ((vflag & VAL_HEX) == 0) {
		maxvalue = 1000000000ul;
	} else {
		maxvalue = 268435456ul;
		radix = 16;
	}
	while (maxvalue > value) {
		maxvalue = maxvalue / radix;
	}
	if (maxvalue == 0) {
		*str++ = '0';
	} else {
		do {
			*str++ = NUMCHAR[value / maxvalue];
			value = value % maxvalue;
			maxvalue = maxvalue / radix;
		} while (maxvalue != 0);
	}
	*str = '\0';
}

/**
 * t 32 rbg 10 iɕϊ.
 * @param lvalue ϊ鐔lw.
 */
static void xToDecNumString(long lvalue, char *numstr, unsigned char vflag)
{
	if (lvalue < 0) {
		numstr[0] = '-';
		xToNumString(~((unsigned long) lvalue) + 1, numstr + 1, vflag);
	} else {
		xToNumString((unsigned long) lvalue, numstr, vflag);
	}
}


/**
 * Ȉ printf
 */
void dev_vfprintf(RBTOS_DeviceT *dd, const char *msg, va_list ap)
{
	unsigned char c;
	OUTBUFF obuf;
	
	obuf.dd = dd;
	obuf.fPrevCR = 0;
	obuf.nLength = 0;
	obuf.vflag = 0;
	obuf.index = 0;
	
	while((c = (unsigned char) *msg++) != '\0') {
		if ((obuf.vflag & VAL_XMODE) == 0) {
			if (c == '%') {
				obuf.vflag = VAL_XMODE;
			} else {
				xCvtPutChar(&obuf, c);
				obuf.vflag = 0;
			}
		} else {
			switch (c) {
			case 'd':
			case 'i':
				xToDecNumString((obuf.vflag & VAL_LONG)
							   ? va_arg(ap, long) : (long) va_arg(ap, int), obuf.numstr, obuf.vflag);
				xZeroChkWrite(&obuf);
				obuf.vflag = 0;
				break;
				
			case 'p':
				obuf.vflag |= VAL_LONG;
			case 'X':
			case 'x':
				obuf.vflag |= VAL_HEX;
			case 'u':
				xToNumString((obuf.vflag & VAL_LONG)
							? va_arg(ap, unsigned long) : (unsigned long) va_arg(ap, unsigned),
							obuf.numstr, obuf.vflag);
				xZeroChkWrite(&obuf);
				obuf.vflag = 0;
				break;
				
			case 'c':
				xCvtPutChar(&obuf, va_arg(ap, unsigned));
				obuf.vflag = 0;
				break;
			
			case 'S':
				xCvtPutWstring(&obuf, va_arg(ap, RBTOS_WCHAR_T*));
				obuf.vflag = 0;
				break;
			
			case 's':
				xCvtPutString(&obuf, va_arg(ap, char*));
				obuf.vflag = 0;
				break;
				
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				if ((obuf.vflag & VAL_NUMMODE) == 0) {
					if (c == '0') {
						obuf.vflag |= VAL_ZERO;
					} else {
						obuf.nLength = (unsigned char) (c - '0');
						obuf.vflag |= (VAL_NUMMODE | VAL_LENGTH);
					}
				} else {
					obuf.nLength = obuf.nLength * 10 + (unsigned char ) (c - '0');
				}
				break;
				
			case 'l':
				obuf.vflag |= VAL_LONG;
				break;
				
			default:
				xCvtPutChar(&obuf, c);
				obuf.vflag = 0;
				break;
			}
		}
	}
	if (obuf.index != 0) {
		dd->d_write(obuf.buff, obuf.index);
	}
}


void dev_printf(RBTOS_DeviceT *dd, const char *msg, ...)
{
	va_list ap;
	va_start(ap, msg);
	dev_vfprintf(dd, msg, ap);
	va_end(ap);
}


// Ȉ printf
void con_printf(const char *msg, ...)
{
	va_list ap;
	va_start(ap, msg);

	if (fCritical == 0) {
		RBTOS_Lock_enter(&lockPrint);
	}

	dev_vfprintf(devCon, msg, ap);

	if (fCritical == 0) {
		RBTOS_Lock_leave(&lockPrint);
	}
	va_end(ap);
}

void err_printf(const char *msg, ...)
{
	va_list ap;
	va_start(ap, msg);

	if (fCritical == 0) {
		RBTOS_Lock_enter(&lockPrint);
	}
	devCon->d_write(ERROR_COLOR, 5);
	dev_vfprintf(devCon, msg, ap);
	devCon->d_write(NORMAL_COLOR, 5);

	if (fCritical == 0) {
		RBTOS_Lock_leave(&lockPrint);
	}
	va_end(ap);
}

int con_getchar(void)
{
	return dev_getchar(devCon);
}

void con_putchar(char c)
{
	dev_putchar(devCon, c);
}

void con_putwchar(RBTOS_WCHAR_T c)
{
	dev_putwchar(devCon, c);
}

int con_putstring(const char *msg)
{
	return dev_putstring(devCon, msg);
}

int con_avail(void)
{
	return devCon->d_avail();
}


int _con_assert(const char *s, const char *fname, const char *funcname, int line)
{
	RBTOS_disable();
	fCritical = 1;
	err_printf("assertion failed: %s, file: %s, function: %s, line: %d\n",
			   s, fname, funcname, line);
	while (1) {
	}
}
