/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * RBTOS jR[h
 * $Id: rbtos.c 29 2012-11-17 18:28:25Z xeerda $
 *****************************************************************************/
#include "rbtos.h"
#if (RBTOS_CONF_HAVE_DEVICE != 0)
  #include "rbtDevice.h"
  #include "rbtUART.h"
#endif /* RBTOS_CONF_HAVE_DEVICE */

// JgXbh
RBTOS_ThreadT *pCurThread;

// s\XbhXg
RBTOS_ThreadT *lsActvThreads;

// ҋ@ԂŁCԌo߂ŕAXbhXg
RBTOS_ThreadT *lsTmWaitThreads;

// ݂̃eBbNl
unsigned long RBTOS_dwCurTick;
// dwNextWkupTick ݒ肵Ƃ̃eBbNl
static unsigned long dwPrevTick;


// Main Xbh
static RBTOS_ThreadT MainThread;

// AChXbh
static RBTOS_ThreadT IdleThread;

// AChXbh̃X^bN̈
static RBTOS_STACK_ELEM_T IdleStack[256];

static void xAddToActiveThreadList(RBTOS_ThreadT *pTask);
static void xIdleThreadFunc(void *arg);
static void xThreadEntry(void *arg, void (*funcThread)(void *arg));
static void xThreadDestroy(void);

void RBTOS_IssueSoftInt0(void);

/*****************************************************************************
 * ֐
 *****************************************************************************/
void RBTOS_initialize(void)
{
	// Timer3 C1ms Ɋ悤ݒ.
	// 1x64xN/40000000 = 0.001s
	// N = 0.001 x 40000000 / 64 =  625
	#define MYTIMER_TICK		625
	OpenTimer3(T3_ON | T3_SOURCE_INT | T3_PS_1_64, MYTIMER_TICK);
    ConfigIntTimer3(T3_INT_ON | T3_INT_PRIOR_2);
	
	mConfigIntCoreSW0(CSW_INT_ON | CSW_INT_PRIOR_2 | CSW_INT_SUB_PRIOR_0);
	
	// Main Xbh̐ݒ
	memset(&MainThread, 0, sizeof(RBTOS_ThreadT));
	MainThread.bPriority = RBTOS_CONF_MAIN_PRIORITY;
	MainThread.strName = "MAIN";
	lsActvThreads= &MainThread;
	pCurThread = &MainThread;
	
	RBTOS_Thread_create(&IdleThread, xIdleThreadFunc, 0, 255, 
						IdleStack, sizeof(IdleStack),
						"IDLE");
}

void __ISR(_CORE_SOFTWARE_0_VECTOR, ipl2) CoreSoftwareInt0Handler(void);

// ^C} 3
void __ISR(_TIMER_3_VECTOR, ipl2) Timer3HandlerWrapper(void);

/*****************************************************************************
 * ^C} 3  (XbhXPW[)
 *****************************************************************************/
void Timer3Handler(void)
{
	unsigned long cur_tick;
	unsigned long passing_ticks;
	RBTOS_ThreadT **pp;
	RBTOS_ThreadT *p;
	
	mT3ClearIntFlag();
	cur_tick = RBTOS_dwCurTick = RBTOS_dwCurTick + 1;
	
	if (cur_tick & 0x100) {
		mPORTBSetBits(BIT_0);
	} else {
		mPORTBClearBits(BIT_0);
	}
	
	if (lsTmWaitThreads == NULL) {
		return; // Ԍo߂ŊXbh͖
	}
	
	passing_ticks = cur_tick - dwPrevTick;
	if (lsTmWaitThreads->dwSleepTick > passing_ticks) {
		return; // ͂莞Ԍo߂ŊXbh͖
	}
	
	pp = &lsTmWaitThreads;
	while ((p = *pp) != NULL) {
		RBTOS_EventT *evt;
		if (p->dwSleepTick > passing_ticks) {
			break;
		}
		
		// ̃Xbh (p) ͍Ŋ.
		// Ȃ̂ŁCANeBuXgɒǉ.
		*pp = p->pLstNext;
		xAddToActiveThreadList(p);
		
		evt = p->pEvent;
		if (evt != NULL) {
			// ̃XbhCxg҂ԂȂCCxg҂LZ.
			RBTOS_ThreadT **qq;
			for (qq = &evt->pWaitingList; *qq != NULL; qq = &(*qq)->pObjNext) {
				if (*qq == p) {
					*qq = p->pObjNext;
					break;
				}
			}
			p->pObjNext = NULL;
			p->pEvent = NULL;
		}
	}
	
	while ((p = *pp) != NULL) {
		// ̃Xbh (p) ́C͊Ȃ.
		p->dwSleepTick -= passing_ticks;
		pp = &p->pLstNext;
	}
	dwPrevTick = cur_tick;
}

/*****************************************************************************
 * ʕb擾
 * `[ibv̒ZԂ̏̑xprz肵Ă܂.
 *  ^C~OɂĂ͕smȒlԂƂ܂.
 *****************************************************************************/
unsigned long getTickUs(void)
{
	IEC0bits.T3IE = 0;											// 
	unsigned long tick = RBTOS_dwCurTick * 1000 + (TMR3 >> 1);
	IEC0bits.T3IE = 1;											// L
	return tick;
}


/*****************************************************************************
 * Xbh̍쐬ƊJn
 *****************************************************************************/
RBTOS_ThreadT *RBTOS_Thread_create(RBTOS_ThreadT *pnew,
								   void (*func)(void *),
								   void *arg, unsigned char pri,
								   void *stack, size_t stacksize,
								   const char *threadname)
{
	memset(pnew, 0, sizeof(RBTOS_ThreadT));
	pnew->bPriority = pri;
	pnew->strName = threadname;
	pnew->pStack = (RBTOS_STACK_ELEM_T*) stack;
	pnew->pStackEnd = (RBTOS_STACK_ELEM_T*) ((unsigned char*) stack + stacksize);
	
	RBTOS_STACK_ELEM_T *p = pnew->pStackEnd - 32 - 2;
	pnew->pLastSP = p;
	
	p[11] = 0x00100001; // CP0_STATUS
	p[12] = (RBTOS_STACK_ELEM_T) arg;
	p[13] = (RBTOS_STACK_ELEM_T) func;
	p[10] = (RBTOS_STACK_ELEM_T) xThreadEntry;
	p[9] = Get_GP();
	
	RBTOS_disable();
	
	xAddToActiveThreadList(pnew);
	
	// 쐬XbhCJgXbhDxȂ΁C
	// 쐬Xbhɐ؂ւ.
	if (pnew->bPriority < pCurThread->bPriority) {
		RBTOS_IssueSoftInt0();
	}
	RBTOS_enable();
	return pnew;
}


/*****************************************************************************
 * X[v
 * dwMillis = 0 ͎s̈ڏ.
 *****************************************************************************/
void RBTOS_Thread_sleep(unsigned long ticks)
{
	RBTOS_disable();
	RBTOS_ThreadT *cur = pCurThread;
	RBTOS_ThreadT *next = cur->pLstNext;
	RBTOS_assert(cur == lsActvThreads);
	RBTOS_assert(cur->pEvent == NULL);
	if (ticks == 0) {
		if (next != NULL) {
			lsActvThreads = next;
			xAddToActiveThreadList(cur);
			RBTOS_IssueSoftInt0();
		}
	} else {
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *p;
		unsigned long cur_tick = RBTOS_dwCurTick;
		
		lsActvThreads = next;
		
		if (lsTmWaitThreads == NULL) {
			dwPrevTick = cur_tick;
		} else {
			unsigned long passing_ticks = cur_tick - dwPrevTick;
			ticks += passing_ticks;
			if (ticks < passing_ticks) {
				ticks = 0xFFFFFFFFUL;
			}
		}
		pp = &lsTmWaitThreads;
		while (1) {
			p = *pp;
			if ((p == NULL) || (ticks < p->dwSleepTick)) {
				break;
			}
			pp = &p->pLstNext;
		}
		*pp = cur;
		cur->dwSleepTick = ticks;
		cur->pLstNext = p;
		RBTOS_IssueSoftInt0();
	}
	RBTOS_enable();
}


/*****************************************************************************
 * XbhGg
 * (Main, AChXbhȊÓjׂẴXbh̊Jn֐
 *****************************************************************************/
static void xThreadEntry(void *arg, void (*funcThread)(void *arg))
{
	funcThread(arg);
	xThreadDestroy();
}


/*****************************************************************************
 * JgXbh OS 菜.
 * Xbh֐IɌĂ΂.
 *****************************************************************************/
static void xThreadDestroy(void)
{
	RBTOS_ThreadT *cur;
	RBTOS_ThreadT *next;
	RBTOS_ThreadT **pp;
	
	
	RBTOS_disable();
	
	// Jg^XNANeBu^XNXg菜.
	RBTOS_assert(pCurThread == lsActvThreads);
	cur = pCurThread;
	next = cur->pLstNext;
    lsActvThreads = next;
    
	// JgXbh̎ɗDx̍Xbhɐ؂ւ.
	RBTOS_IssueSoftInt0();
	RBTOS_enable();
}


/*****************************************************************************
 * bN
 *****************************************************************************/
void RBTOS_Lock_enter(RBTOS_LockT *lock)
{
	RBTOS_disable();
	RBTOS_ThreadT *cur = pCurThread;
	RBTOS_assert(cur == lsActvThreads);
	if (lock->owner == NULL) {
		// NbNĂȂꍇCJgXbhL҂ɂďI.
		lock->owner = cur;
	} else if (lock->owner == cur) {
		// JgXbhL҂̏ꍇCbNJEg +1 ďI.
		lock->bCount++;
	} else {
		// JgXbhANeBuXg菜
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *p;
		RBTOS_ThreadT *next = cur->pLstNext;
		lsActvThreads = next;
		cur->pLstNext = NULL;
		
		pp = &lock->pWaitingList;
		while (1) {
			p = *pp;
			if ((p == NULL) || (cur->bPriority < p->bPriority)) {
				break;
			}
			pp = &p->pObjNext;
		}
		*pp = cur;
		cur->pObjNext = p;
		
		RBTOS_IssueSoftInt0();
	}
	RBTOS_enable();
}

void RBTOS_Lock_leave(RBTOS_LockT *lock)
{
	RBTOS_disable();
	RBTOS_assert(pCurThread == lsActvThreads);
	RBTOS_assert(pCurThread == lock->owner);
	if (lock->bCount != 0) {
		lock->bCount--;
	} else {
		RBTOS_ThreadT *next = lock->pWaitingList;
		lock->owner = next;
		if (next != NULL) {
			lock->pWaitingList = next->pObjNext;
			next->pObjNext = NULL;
			xAddToActiveThreadList(next);
			if (pCurThread != lsActvThreads) {
				RBTOS_IssueSoftInt0();
			}
		}
	}
	RBTOS_enable();
}

/*****************************************************************************
 * Cxg
 *****************************************************************************/

// Cxg҂
int RBTOS_Event_wait(RBTOS_EventT *pevent, unsigned long ticks)
{
	RBTOS_ThreadT *cur;
	RBTOS_ThreadT *next;
	RBTOS_ThreadT **pp;
	RBTOS_ThreadT *p;
	RBTOS_disable();
	if (pevent->fSignaled) {
		// CxgVOiԂȂ΁CVOiԂNAďI.
		pevent->fSignaled = 0;
		RBTOS_enable();
		return 0;
	}
	// ANeBuXg菜
	cur = pCurThread;
	RBTOS_assert(cur == lsActvThreads);
	next = cur->pLstNext;
	lsActvThreads = next;
	
	pp = &pevent->pWaitingList;
	while (1) {
		p = *pp;
		if ((p == NULL) || (cur->bPriority < p->bPriority)) {
			break;
		}
		pp = &p->pObjNext;
	}
	*pp = cur;
	cur->pObjNext = p;
	
	if (ticks == 0) {
		cur->pLstNext = NULL;
	} else {
		unsigned long cur_tick = RBTOS_dwCurTick;
		if (lsTmWaitThreads == NULL) {
			dwPrevTick = cur_tick;
		} else {
			unsigned long passing_ticks = cur_tick - dwPrevTick;
			ticks += passing_ticks;
			if (ticks < passing_ticks) {
				ticks = 0xFFFFFFFFUL;
			}
		}
		pp = &lsTmWaitThreads;
		while (1) {
			p = *pp;
			if ((p == NULL) || (ticks < p->dwSleepTick)) {
				break;
			}
			pp = &p->pLstNext;
		}
		*pp = cur;
		cur->pLstNext = p;
	}
	cur->dwSleepTick = ticks;
	cur->fIsTimedOut = 1;
	cur->pEvent = pevent;
	RBTOS_IssueSoftInt0();
	RBTOS_enable();
	return cur->fIsTimedOut;
}

// CxgZbg
void iRBTOS_Event_set(RBTOS_EventT *pevent)
{
	RBTOS_disable();
	RBTOS_ThreadT *p = pevent->pWaitingList;
	
	if (p == NULL) {
		// Cxg҂ĂXbhȂCVOiԂɂďI.
		pevent->fSignaled = 1;
		RBTOS_enable();
		return;
	}
	pevent->pWaitingList = NULL;
	pevent->pWaitingList = NULL;
	do {
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *next = p->pObjNext;
		
		if (p->dwSleepTick != 0) {
			for (pp = &lsTmWaitThreads; *pp != NULL; pp = &(*pp)->pLstNext) {
				if (*pp == p) {
					*pp = p->pLstNext;
					break;
				}
			}
		}
		p->pObjNext = NULL;
		p->pLstNext = NULL;
		p->pEvent = NULL;
		p->fIsTimedOut = 0;
		xAddToActiveThreadList(p);
		
		p = next;
	} while (p != NULL);
	RBTOS_enable();
}


// CxgZbg
void RBTOS_Event_set(RBTOS_EventT *pevent)
{
	iRBTOS_Event_set(pevent);
	if (pCurThread != lsActvThreads) {
		RBTOS_IssueSoftInt0();
	}
}


static void xIdleThreadFunc(void *arg)
{
	while (1) {
		PowerSaveIdle();
	}
}

static void xAddToActiveThreadList(RBTOS_ThreadT *pTask)
{
	// ANeBuXĝׂꏊɑ}o^.
	RBTOS_ThreadT **pp = &lsActvThreads;
	while (1) {
		RBTOS_ThreadT *p = *pp;
		if ((p == NULL) || (p->bPriority > pTask->bPriority)) {
			pTask->pLstNext = p;
			*pp = pTask;
			break;
		}
		pp = &p->pLstNext;
	}
}
