#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import os.path
import xml.dom.minidom

import rec10d

path = str(os.path.dirname(os.path.abspath(__file__))) + "/"

def chadd(bctype, ontv, chtxt, ch, csch):#すべて文字列
    """
    ChannelDBに指定したデータを追加する
    bctype:放送種別,bs/cs/te10などが入る。
    番組表データがbs,csは一括でとれるためbs,cs内で区別はなし
    te(地上波)は各チャンネルごとに設定する必要があるためteに
    チャンネルの数字を足したものにする
    """
    rec10d.rec10db.add_epg_ch(bctype, ontv, chtxt, ch, csch, u"2009-04-01 00:00:00")
def chlistadd(cl):
    if len(cl)>0:
        for c in cl:
            chadd(c[0],c[1],c[2],c[3],c[4])
def new_chdata(bs,cs):
    rec10d.rec10db.new_epg_ch()
    chlistadd(getChList(os.path.join(path,"chlist.xml")))
    if bs==1:
        #bs放送の設定　全国共通のはず
        chlistadd(getChList(os.path.join(path,"chlist_bs.xml")))
    if cs==1:
        #CS放送(スカパーe2)主に基本パックには言ってるものを中心に
        chlistadd(getChList(os.path.join(path,"chlist_cs.xml")))
def new_chdata_all():
    new_chdata(1,1)
    #チャンネルの設定
    #chadd(u'放送種別',u'ontvコード(ontvのサイトなどで調べられる)',u'略称(何でもよい)',u'チャンネル(物理チャンネル)',u'CS放送の場合の内訳')

    #地上波の設定　東京都(筆者は東京で受信していないため正しいかどうか分かりません)

def getChList(xmlpath):
    dom=xml.dom.minidom.parse(file(xmlpath))
    chlist=[]
    for ch in dom.getElementsByTagName('channel'):
        bctype=ch.getAttribute("bctype")
        chd=ch.getAttribute("ch")
        csch=ch.getAttribute("csch")
        chtxt=ch.getAttribute("chtxt")
        ontv=ch.getAttribute("ontvcode")
        chlist.append([bctype,ontv,chtxt,chd,csch])
    return chlist
if __name__ == "__main__":
    new_chdata()