#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import commands
import datetime
import os
import re
import shutil
import time

import chdb
import configreader
import status
import ts2x264
import tv2ts
import recdblist
global Bitrate_SD
global Bitrate_HD
global Bitrate_FHD
global Bitrate_Short
global Bitrate_LowHD
Bitrate_SD = 1250
Bitrate_HD = 3750
Bitrate_LowHD = 2500
Bitrate_FHD = 5000
Bitrate_Short = 1250
#Bitrate_Tall = 2500
#Bitrate_Grande = 3750
#Bitrate_Venti = 5000
def timetv2b25(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル
    """
    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tnow = datetime.datetime.now()
    wt = bt-tnow
    waitt = wt.seconds-5
    time.sleep(waitt)
    tnow = datetime.datetime.now()
    dt = et-tnow
    rectime = dt.seconds-10
    rectime = str(rectime)
    tv2ts.tv2b25ts(tsout + ".ts.b25", chdb.chtxtsearch(chtxt)['ch'], rectime)
def b252ts(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル(自動的にtitle.b25 title.tsと名前がつきます。)
    """
    #status.setB25Decoding(status.getB25Decoding() + 1)
    status.changeB25Decoding(1)
    try:
        tv2ts.b252ts(pout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'])
        tsout = pout
        aviin = pout + ".ts"
        dualaudio = 0
        pentaaudio = 0
        if re.search("5", opt):
            pentaaudio = 1
        if re.search("d", opt):
            dualaudio = 1
        if re.search(u"\[二\]", pout):
            dualaudio = 1
        elif re.search(u'（二）', pout):
            dualaudio = 1
        elif re.search(u'\(二\)', pout):
            dualaudio = 1
        if dualaudio == 1:
            dualaudiots2avi(aviin, tsout + ".sa.avi")
        if pentaaudio == 1:
            dualaudiots2avi(aviin, tsout + ".sa.avi")
    except Exception, inst:
        print "Error happend in b252ts in tv2avi"
        print type(inst)
        print inst
    status.changeB25Decoding(-1)
def timetv2avi(pout, chtxt, btime, etime, opt):
    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tnow = datetime.datetime.now()
    wt = bt-tnow
    waitt = wt.seconds-5
    time.sleep(waitt)
    tnow = datetime.datetime.now()
    dt = et-tnow
    rectime = dt.seconds-10
    rectime = str(rectime)
    #recdblist.printutf8(tsout+".ts,"+chdb.chtxtsearch(chtxt)['ch']+","+chdb.chtxtsearch(chtxt)['csch']+","+rectime)
    tv2ts.tv2ts(tsout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'], rectime)
    aviin = tsout + ".ts"
    dualaudio = 0
    pentaaudio = 0
    if re.search("5", opt):
        pentaaudio = 1
    if re.search("d", opt):
        dualaudio = 1
    if re.search(u"\[二\]", pout):
        dualaudio = 1
    elif re.search(u'（二）', pout):
        dualaudio = 1
    elif re.search(u'\(二\)', pout):
        dualaudio = 1
    if opt == "":
        opts = ""
        if chdb.chtxtsearch(chtxt)['bctype'] == 'cs':
            opts = opts + "S2"
            if chtxt == "disch":
                ""
            elif chtxt == "hisch":
                ""
            else:
                opts = opts + "a"
        else:
            opts = opts + "Ha2"
    else:
        opts = opt
    if dualaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
    if pentaaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
def ts2avi(pin, pout, opt):
    status.changeEncoding(1)
    #status.setEncoding(status.getEncoding() + 1)
    try:
        ts2x264.ts2x264(pin, pout, opt)
    except Exception, inst:
        print "error occures in tv2avi.py tv2avi"
        print type(inst)
        print inst
    status.changeEncoding(-1)
    #status.setEncoding(status.getEncoding()-1)
def tv2avi(pout, chtxt, btime, etime, opt):
    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
    dt = et-bt
    time = dt.seconds-10
    time = str(time)
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tv2ts.tv2ts(tsout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'], time)
    aviin = tsout + ".ts"
    dualaudio = 0
    pentaaudio = 0 
    if re.search("5", opt):
        pentaaudio = 1
    if re.search("d", opt):
        dualaudio = 1
    if re.search(u'\[二\]', pout):
        dualaudio = 1
    elif re.search(u'（二）', pout):
        dualaudio = 1
    elif re.search(u'\(二\)', pout):
        dualaudio = 1
    opts = ""
    if chdb.chtxtsearch(chtxt)['bctype'] == 'cs':
        opts = opts + "S2"
        if chtxt == "disch":
            ""
        elif chtxt == "hisch":
            ""
        else:
            opts = opts + "a"
    else:
        opts = opts + "Ha2"
    if dualaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
    if pentaaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
    ts2x264.ts2x264(aviin, pout, opts)
    #os.remove(aviin)
def b252avi(pout, chtxt, opt):
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tv2ts.b252ts(tsout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'])
    aviin = tsout + ".ts"
    dualaudio = 0
    pentaaudio = 0
    if re.search("5", opt):
        pentaaudio = 1
    if re.search("d", opt):
        dualaudio = 1
    if re.search(u'\[二\]', pout):
        dualaudio = 1
    elif re.search(u'（二）', pout):
        dualaudio = 1
    elif re.search(u'\(二\)', pout):
        dualaudio = 1
    if opt == "":
        opts = ""
        if chdb.chtxtsearch(chtxt)['bctype'] == 'cs':
            opts = opts + "S2"
            if chtxt == "disch":
                ""
            elif chtxt == "hisch":
                ""
            else:
                opts = opts + "a"
        else:
            opts = opts + "Ha2"
    else:
        opts = opt
    if dualaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
    if pentaaudio == 1:
        dualaudiots2avi(aviin, tsout + ".sa.avi")
        aviin = tsout + ".sa.avi"
    ts2x264.ts2x264(aviin, pout, opts)
def dualaudiots2avi(pin, pout):
    bontsdemux = configreader.getpath('bontsdemux')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    xvfb = configreader.getpath('xvfb-run')
    logpath=pin.replace("ts","log")
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 0 -o \"" + bonpout + "\" -start -quit"
    #recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    os.system(exe.encode('utf-8'))
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    exe = "ffmpeg -y  -i \'" + ffpin1 + "\' -i \'" + ffpin2 + "\' -r 29.97 -vsync 200 -vcodec copy -acodec libmp3lame -async 200 -ab 128k -f avi  \'" + pout + "\'"
    recdblist.printutf8(exe)
    #commands.getoutput(exe)
    os.system(exe.encode('utf-8'))
    os.remove(ffpin1)
    os.remove(ffpin2)
def dualaudio2sep(pin, pout, delay):
    """
    delay is string
    """
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    xvfb = configreader.getpath('xvfb-run')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 1 -o \"" + bonpout + "\" -start -quit"
    #recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    commands.getoutput(exe.encode('utf-8'))
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "1_delay" + delay + ".wav"
    ffpout2 = ffpin + "2_delay" + delay + ".wav"
    ffpout3 = ffpin + "_delay" + delay + ".m2v"
    shutil.move(ffpin1, ffpout1)
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 2 -encode Demux\(wav\) -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    commands.getoutput(exe.encode('utf-8'))
    #os.system(exe)
    shutil.move(ffpin1, ffpout2)
    shutil.move(ffpin2, ffpout3)
    #ffpout21=ffpout1.replace(".wav",".ogg")
    #ffpout22=ffpout2.replace(".wav",".ogg")
    #aexe1="ffmpeg -i "+ffpout1+" -vn -acodec vorbis -ar 48000 -ab 128k "+ffpout21
    #aexe2="ffmpeg -i "+ffpout2+" -vn -acodec vorbis -ar 48000 -ab 128k "+ffpout22
    aexe = "ffmpeg -i \"" + ffpout3 + "\" -i \"" + ffpout1 + "\" -i \"" + ffpout2 + "\" -r 29.97 -vsync 200 -vcodec copy -acodec copy -f avi " + pout + " -acodec copy -newaudio"
    recdblist.printutf8(aexe)
    #os.system(aexe1)
    #os.system(aexe2)
    commands.getoutput(aexe.encode('utf-8'))
    #exe = "ffmpeg -y  -i \'" + ffpin1 + "\' -i \'" + ffpin2 + "\' -r 29.97 -vsync 200 -vcodec copy -acodec libmp3lame -async 200 -ab 128k -f avi  \'" + pout + "\'"
    #recdblist.printutf8(exe)
    
    #os.remove(ffpin1)
    #os.remove(ffpin2)

def pentaaudiots2avi(pin, pout):
    bontsdemux = configreader.getpath('bontsdemux')
    bonpin = "Z:\\" + pin[1:]
    xvfb = configreader.getpath('xvfb-run')
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 3 -o \"" + bonpout + "\" -start -quit"
    #recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    #exe = 'xvfb-run -a ' + exe
    #exe='export Display=:2&&'+exe
    recdblist.printutf8(exe)
    commands.getoutput(exe.encode('utf-8'))
    #os.system(exe)
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    exe = "ffmpeg -y  -i \'" + ffpin1 + "\' -i \'" + ffpin2 + "\' -r 29.97 -vsync 200 -vcodec copy -acodec libmp3lame -async 200 -ab 128k -f avi  \'" + pout + "\'"
    recdblist.printutf8(exe)
    commands.getoutput(exe.encode('utf-8'))
    #os.system(exe)
    os.remove(ffpin1)
    os.remove(ffpin2)

