#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2011 Yukikaze
#import sys # モジュール属性 argv を取得するため
import os
import re
import time
import commands

import chdb
import configreader
import tv2ts
import recdblist

def writeEpgXML(pout, ch):
    """
    tsを取得してepgの入ったxmlとして書き出す
    """
    timet = "90"
    if re.search(u'CS', ch):
        timet = "180"
    elif len(ch)>2:
        timet = "240"
    writeEpgXMLTime(pout, ch ,timet)
def writeEpgXMLTime(pout, ch ,times):
    """
    指定された時間分tsを取得してepgの入ったxmlとして書き出す
    """
    recdblist.addCommonlogEX(u"通常","write_time(ts2epg.py)",u"Ts-EPG XML書き出し処理開始" ,u"CH:"+ch,log_level=500)
    timet = times
    if re.search(u'CS', ch):
        mode = "/CS"
    elif len(ch)>2:
        mode = "/BS"
    else:
        mode = str(chdb.searchCHFromBctype(u'te' + ch)['ch'])
    epgdump = configreader.getConfPath("epgdump")
    if os.access(pout + ".ts", os.F_OK):
        os.remove(pout + ".ts")
    time.sleep(10)
    tv2ts.tv2tsmix(pout + ".ts", ch, timet)
    exe = "export LANG=ja_JP.UTF-8 && nice -n 15 " + epgdump + " " + mode + " " + pout + ".ts " + pout
    recdblist.printutf8(exe)
    recdblist.addCommonlogEX(u"通常", "write_time(ts2epg.py)", exe,"",log_level=500)
    unicode(commands.getoutput(exe),'utf-8','ignore')
    time.sleep(10)

