// CasServer.cpp: CCasServer NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////


#include "CasServer.h"
#include "BCasCard.h"

#define FALSE 0
#define TRUE 1

CCasServer::CCasServer(ICasServerHandler *pEventHandler)
	: m_pEventHandler(pEventHandler)
	, m_hServerThread(NULL)
{

}

CCasServer::~CCasServer(void)
{
	CloseServer();
}

const BOOL CCasServer::OpenServer(const WORD wServerPort)
{
	// J[h[_݃`FbN
	CBcasCard BCasCard;
	if(!BCasCard.OpenCard())return FALSE;

	// T[o\PbgI[v
	if(!m_pSocket.Listen(wServerPort))return FALSE;

	// T[oXbhN
	pthread_create(&m_hServerThread, NULL, CCasServer::ServerThreadRaw, (LPVOID)this);
	if(!m_hServerThread){
		m_pSocket.Close();
		return FALSE;
	}

	return TRUE;
}

void CCasServer::CloseServer(void)
{
	// T[o\PbgN[Y
	m_pSocket.Close();

	// XbhnhJ
	if(m_hServerThread){
		pthread_join(m_hServerThread, NULL);
		m_hServerThread = NULL;
	}

	// SNCAgؒf
	m_Lock.Lock();
	
	for(ClientList::iterator It = m_ClientList.begin() ; It != m_ClientList.end() ; It++){
		It->first->CloseClient();
		}

	m_Lock.Unlock();
	
	// SNCAg̏I҂
	while(m_ClientList.size()) sleep(1UL);
}

const DWORD CCasServer::GetClientNum(void) const
{
	// ڑ̃NCAgԂ
	return m_ClientList.size();
}

void CCasServer::OnCasClientEvent(CCasClient *pClient, const DWORD dwEventID, PVOID pParam)
{
	CBlockLock AutoLock(&m_Lock);

	// NCAgCxg
	switch(dwEventID){
		case CCasClient::EID_CONNECTED :
			// Xgɒǉ
			m_ClientList[pClient] = pClient;
			if (m_pEventHandler) m_pEventHandler->OnCasServerEvent(this, CSEI_CONNECTED);
			break;
			
		case CCasClient::EID_DISCONNECTED :
			// Xg폜
			m_ClientList.erase(pClient);
			if (m_pEventHandler) m_pEventHandler->OnCasServerEvent(this, CSEI_DISCONNECTED);
			break;
		}
}

void CCasServer::ServerThread(void)
{
	// ANZvg[v
	CSmartSock *pNewSocket;
	
	while(pNewSocket = m_pSocket.Accept()){
		// NCAgCX^X
		new CCasClient(this, pNewSocket);
		}
}

void* CCasServer::ServerThreadRaw(LPVOID pParam)
{
	// T[oXbh
	static_cast<CCasServer *>(pParam)->ServerThread();

	return 0UL;
}
