// ProgManager.cpp: CProgManager NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TsTable.h"
#include "ProgManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// CProgManager \z/
//////////////////////////////////////////////////////////////////////

CProgManager::CProgManager(CDecoderHandler *pDecoderHandler)
	: CMediaDecoder(pDecoderHandler)
{
	// vOf[^x[XCX^X
	m_pProgDatabase = new CProgDatabase(*this);
}

CProgManager::~CProgManager()
{
	// vOf[^x[XCX^XJ
	delete m_pProgDatabase;
}

void CProgManager::Reset()
{
	// T[rXXgNA
	m_ServiceList.clear();

	// vOf[^x[XZbg
	m_pProgDatabase->Reset();

	// ʃfR[_Zbg
	CMediaDecoder::Reset();
}

const DWORD CProgManager::GetInputNum() const
{
	return 1UL;
}

const DWORD CProgManager::GetOutputNum() const
{
	return 1UL;
}

const bool CProgManager::InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex)
{
	if(dwInputIndex >= GetInputNum())return false;

	CTsPacket *pTsPacket = static_cast<CTsPacket *>(pMediaData);

	// ̓fBAf[^͌݊Ȃ
	if(!pTsPacket)return false;

	// PID[eBO
	m_PidMapManager.StorePacket(pTsPacket);

	// ̃tB^Ƀf[^n
	OutputMedia(pMediaData);

	return true;
}

const WORD CProgManager::GetServiceNum(void) const
{
	// T[rXԂ
	return m_ServiceList.size();
}

const bool CProgManager::GetServiceID(WORD *pwServiceID, const WORD wIndex) const
{
	// T[rXID擾
	if((wIndex < GetServiceNum()) && pwServiceID){
		*pwServiceID = m_ServiceList[wIndex].wServiceID;
		return true;		
		}
		
	return false;
}

const bool CProgManager::GetServiceEsPID(WORD *pwVideoPID, WORD *pwAudioPID, const WORD wIndex) const
{
	// ESPID擾
	if((wIndex < GetServiceNum()) && (pwVideoPID || pwAudioPID)){
		if(pwVideoPID)*pwVideoPID = m_ServiceList[wIndex].wVideoEsPID;
		if(pwAudioPID)*pwAudioPID = m_ServiceList[wIndex].wAudioEsPID;
		return true;
		}

	return false;
}

const DWORD CProgManager::GetServiceName(LPTSTR lpszDst, const WORD wIndex) const
{
	// T[rX擾
	if((wIndex < GetServiceNum()) && lpszDst){
		const WORD wNameLen = ::lstrlen(m_ServiceList[wIndex].szServiceName);
		if(wNameLen)::lstrcpy(lpszDst, m_ServiceList[wIndex].szServiceName);
		return wNameLen;		
		}
		
	return 0U;
}

void CProgManager::OnServiceListUpdated(void)
{
	// T[rXXgNAATCY
	m_ServiceList.clear();

	// T[rXXg\z
	for(WORD wIndex = 0U, wServiceNum = 0U ; wIndex < m_pProgDatabase->m_ServiceList.size() ; wIndex++){
		if(m_pProgDatabase->m_ServiceList[wIndex].wVideoEsPID != 0xFFFFU){
			// MPEG2f̂(ZOAf[^ȊO)
			m_ServiceList.resize(wServiceNum + 1);
			m_ServiceList[wServiceNum].wServiceID = m_pProgDatabase->m_ServiceList[wIndex].wServiceID;
			m_ServiceList[wServiceNum].wVideoEsPID = m_pProgDatabase->m_ServiceList[wIndex].wVideoEsPID;
			m_ServiceList[wServiceNum].wAudioEsPID = m_pProgDatabase->m_ServiceList[wIndex].wAudioEsPID;
			m_ServiceList[wServiceNum].szServiceName[0] = TEXT('\0');
			wServiceNum++;
			}
		}

	TRACE(TEXT("CProgManager::OnServiceListUpdated()\n"));

	SendDecoderEvent(EID_SERVICE_LIST_UPDATED);
}

void CProgManager::OnServiceInfoUpdated(void)
{
	// T[rXXV
	for(WORD wIndex = 0U, wServiceNum = 0U ; wIndex < GetServiceNum() ; wIndex++){
		const WORD wServiceIndex = m_pProgDatabase->GetServiceIndexByID(m_ServiceList[wIndex].wServiceID);

		if(wServiceIndex != 0xFFFFU){
			if(m_pProgDatabase->m_ServiceList[wIndex].szServiceName[0]){
				::lstrcpy(m_ServiceList[wIndex].szServiceName, m_pProgDatabase->m_ServiceList[wServiceIndex].szServiceName);
				}
			else{
				::wsprintf(m_ServiceList[wIndex].szServiceName, TEXT("T[rX%u"), wIndex + 1U);
				}
			}
		}

	TRACE(TEXT("CProgManager::OnServiceInfoUpdated()\n"));
	
	SendDecoderEvent(EID_SERVICE_INFO_UPDATED);
}


//////////////////////////////////////////////////////////////////////
// CProgDatabase \z/
//////////////////////////////////////////////////////////////////////

CProgManager::CProgDatabase::CProgDatabase(CProgManager &ProgManager)
	: m_ProgManager(ProgManager)
	, m_PidMapManager(ProgManager.m_PidMapManager)
	, m_wTransportStreamID(0x0000U)
{
	Reset();
}

CProgManager::CProgDatabase::~CProgDatabase()
{
	UnmapTable();
}

void CProgManager::CProgDatabase::Reset(void)
{
	// Se[uA}bv
	UnmapTable();

	// PATe[uPID}bvǉ
	m_PidMapManager.MapTarget(0x0000U, new CPatTable, CProgDatabase::OnPatUpdated, static_cast<PVOID>(this));
}

void CProgManager::CProgDatabase::UnmapTable(void)
{
	// SPMT PIDA}bv
	for(WORD wIndex = 0U ; wIndex < m_ServiceList.size() ; wIndex++){
		m_PidMapManager.UnmapTarget(m_ServiceList[wIndex].wPmtTablePID);
		}

	// T[rXXgNA
	m_ServiceList.clear();
	
	// gX|[gXg[ID
	m_wTransportStreamID = 0xFFFFU;
	
	// PATe[uZbg
	CPatTable *pPatTable = dynamic_cast<CPatTable *>(m_PidMapManager.GetMapTarget(0x0000U));
	if(pPatTable)pPatTable->Reset();
}

const WORD CProgManager::CProgDatabase::GetServiceIndexByID(const WORD wServiceID)
{
	// vOIDT[rXCfbNX
	for(WORD wIndex = 0U ; wIndex < m_ServiceList.size() ; wIndex++){
		if(m_ServiceList[wIndex].wServiceID == wServiceID)return wIndex;
		}

	// vOIDȂ
	return 0xFFFFU;
}

void CALLBACK CProgManager::CProgDatabase::OnPatUpdated(const WORD wPID, CTsPidMapTarget *pMapTarget, CTsPidMapManager *pMapManager, const PVOID pParam)
{
	// PATXVꂽ
	CProgDatabase *pThis = static_cast<CProgDatabase *>(pParam);
	CPatTable *pPatTable = dynamic_cast<CPatTable *>(pMapTarget);
		
	// gX|[gXg[IDXV
	pThis->m_wTransportStreamID = pPatTable->m_CurSection.GetTableIdExtension();

	// PMTPIDA}bv
	for(WORD wIndex = 0U ; wIndex < pThis->m_ServiceList.size() ; wIndex++){
		pMapManager->UnmapTarget(pThis->m_ServiceList[wIndex].wPmtTablePID);
		}

	// VPMTXgA
	pThis->m_ServiceList.resize(pPatTable->GetProgramNum());

	for(WORD wIndex = 0U ; wIndex < pThis->m_ServiceList.size() ; wIndex++){
		// T[rXXgXV
		pThis->m_ServiceList[wIndex].bIsUpdated = false;
		pThis->m_ServiceList[wIndex].wServiceID = pPatTable->GetProgramID(wIndex);
		pThis->m_ServiceList[wIndex].wPmtTablePID = pPatTable->GetPmtPID(wIndex);

		pThis->m_ServiceList[wIndex].wVideoEsPID = 0xFFFFU;
		pThis->m_ServiceList[wIndex].wAudioEsPID = 0xFFFFU;
		pThis->m_ServiceList[wIndex].byVideoComponentTag = 0xFFU;
		pThis->m_ServiceList[wIndex].byAudioComponentTag = 0xFFU;
		pThis->m_ServiceList[wIndex].byServiceType = 0xFFU;
		pThis->m_ServiceList[wIndex].byRunningStatus = 0xFFU;
		pThis->m_ServiceList[wIndex].bIsCaService = false;
		pThis->m_ServiceList[wIndex].szServiceName[0] = TEXT('\0');
		
		// PMTPID}bv
		pMapManager->MapTarget(pPatTable->GetPmtPID(wIndex), new CPmtTable, CProgDatabase::OnPmtUpdated, pParam);
		}
}

void CALLBACK CProgManager::CProgDatabase::OnPmtUpdated(const WORD wPID, CTsPidMapTarget *pMapTarget, CTsPidMapManager *pMapManager, const PVOID pParam)
{
	// PMTXVꂽ
	CProgDatabase *pThis = static_cast<CProgDatabase *>(pParam);
	CPmtTable *pPmtTable = dynamic_cast<CPmtTable *>(pMapTarget);

	// T[rXCfbNX
	const WORD wServiceIndex = pThis->GetServiceIndexByID(pPmtTable->m_CurSection.GetTableIdExtension());
	if(wServiceIndex == 0xFFFFU)return;

	// rfIESPIDXgA
	pThis->m_ServiceList[wServiceIndex].wVideoEsPID = 0xFFFFU;
	
	for(WORD wEsIndex = 0U ; wEsIndex < pPmtTable->GetEsInfoNum() ; wEsIndex++){
		// uITU-T Rec. H.262|ISO/IEC 13818-2 Video or ISO/IEC 11172-2ṽXg[^Cv
		if(pPmtTable->GetStreamTypeID(wEsIndex) == 0x02U){
			pThis->m_ServiceList[wServiceIndex].wVideoEsPID = pPmtTable->GetEsPID(wEsIndex);
			break;
			}		
		}

	// I[fBIESPIDXgA
	pThis->m_ServiceList[wServiceIndex].wAudioEsPID = 0xFFFFU;
	
	for(WORD wEsIndex = 0U ; wEsIndex < pPmtTable->GetEsInfoNum() ; wEsIndex++){
		// uISO/IEC 13818-7 Audio (ADTS Transport Syntax)ṽXg[^Cv
		if(pPmtTable->GetStreamTypeID(wEsIndex) == 0x0FU){
			pThis->m_ServiceList[wServiceIndex].wAudioEsPID = pPmtTable->GetEsPID(wEsIndex);
			break;
			}
		}

	// XVς݃}[N
	pThis->m_ServiceList[wServiceIndex].bIsUpdated = true;
	
/*
	ǂɂĂPATɊ܂܂T[rXSĂPMT𗬂ĂȂꍇB
@@(xnhĂяôh~邽ߑSĂ̏񂪂iKŌĂяo)

	// PMT̍XV󋵂𒲂ׂ
	for(WORD wIndex = 0U ; wIndex < pThis->m_ServiceList.size() ; wIndex++){
		if(!pThis->m_ServiceList[wIndex].bIsUpdated)return;
		}
*/

	// SDTe[uă}bv
	pMapManager->MapTarget(0x0011U, new CSdtTable, CProgDatabase::OnSdtUpdated, pParam);
	
	// CxgnhĂяo
	pThis->m_ProgManager.OnServiceListUpdated();
}

void CALLBACK CProgManager::CProgDatabase::OnSdtUpdated(const WORD wPID, CTsPidMapTarget *pMapTarget, CTsPidMapManager *pMapManager, const PVOID pParam)
{
	// SDTXVꂽ
	CProgDatabase *pThis = static_cast<CProgDatabase *>(pParam);
	CSdtTable *pSdtTable = dynamic_cast<CSdtTable *>(pMapTarget);

	for(WORD wSdtIndex = 0U ; wSdtIndex < pSdtTable->GetServiceNum() ; wSdtIndex++){
		// T[rXID
		const WORD wServiceIndex = pThis->GetServiceIndexByID(pSdtTable->GetServiceID(wSdtIndex));
		if(wServiceIndex == 0xFFFFU)continue;

		// T[rXXV
		pThis->m_ServiceList[wServiceIndex].byRunningStatus = pSdtTable->GetRunningStatus(wSdtIndex);
		pThis->m_ServiceList[wServiceIndex].bIsCaService = pSdtTable->GetFreeCaMode(wSdtIndex);
		
		// T[rXXV
		pThis->m_ServiceList[wServiceIndex].szServiceName[0] = TEXT('\0');

		const CDescBlock *pDescBlock = pSdtTable->GetItemDesc(wSdtIndex);
		const CServiceDesc *pServiceDesc = dynamic_cast<const CServiceDesc *>(pDescBlock->GetDescByTag(CServiceDesc::DESC_TAG));

		if(pServiceDesc){
			pServiceDesc->GetServiceName(pThis->m_ServiceList[wServiceIndex].szServiceName);
			pThis->m_ServiceList[wServiceIndex].byServiceType = pServiceDesc->GetServiceType();
			}
		}

	// CxgnhĂяo
	pThis->m_ProgManager.OnServiceInfoUpdated();
}
