# Game_PartyĒ`
# Authors:: fukuyama
# Date:: 2011/12/26
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

class Game_Party
  include Backpack_Module
  # ACeIuWFNg̔z擾
  def items
    @backpack.find_all_items(Game_Item)
  end

  # IuWFNg̔z擾
  def weapons
    @backpack.find_all_items(Game_Weapon)
  end

  # hIuWFNg̔z擾
  def armors
    @backpack.find_all_items(Game_Armor)
  end

  # SĂ̑iIuWFNg̔z擾
  def equip_items
    # XXX: ԂASo[̂ȂƂ߂
    weapons + armors
  end

  # SẴACeIuWFNg̔z擾
  def all_items
    # XXX: ԂASo[̂ȂƂ߂
    @backpack.find_all_items()
  end

  # X^bNACe̔z擾
  def stack_items
    @backpack.stack_items()
  end

  # ACẽNXɑΉReiIuWFNg擾
  def item_container(item_class)
    # XXX: ԂȂ
  end

  # ACȅ擾
  # S{ӂ
  def item_number(item)
    num = self.members.inject(0){|r,a| r + a.backpack.item_number(item)}
    num += self.backpack.item_number(item)
    return num
  end

  #--------------------------------------------------------------------------
  #  ACȇij
  #     include_equip : i܂߂
  #--------------------------------------------------------------------------
  def gain_item(item, amount, include_equip = false)
    if amount > 0
      amount.times() do |i|
        # VCX^X쐬
        case item
        when RPG::Item,Game_Item
          item = Game_Item.new(item.id)
        when RPG::Weapon,Game_Weapon
          item = Game_Weapon.new(item.id)
        when RPG::Armor,Game_Armor
          item = Game_Armor.new(item.id)
        end
        result = false
        # o[̃obNpbNɋ󂫂Γ
        self.members.each do |a|
          result = a.backpack.add_item(item)
          break if result
        end
        # 󂫂ꍇ̓p[eB̃obNpbNɓ
        if not result
          @backpack.add_item(item)
        end
      end
    end
    if amount < 0
      # ACẽ^Cv擾
      case item
      when RPG::Item,Game_Item
        type = Game_Item
      when RPG::Weapon,Game_Weapon
        type = Game_Weapon
      when RPG::Armor,Game_Armor
        type = Game_Armor
      end
      amount.abs.times() do |i|
        # o[̒
        result = self.members.any? do |a|
          # ĂACeȊO
          items = a.backpack.find_all_items(type,item.id) - a.equips
          # P폜
          items.any? {|item1| a.backpack.remove_item(item1)}
        end
        # 폜ĂȂꍇ
        unless result
          # p[eB̃obNpbN폜
          result = @backpack.remove_item(item)
        end
        # 폜ĂȂꍇi܂ޏꍇ
        if not result and include_equip
          # o[̒
          result = self.members.any? do |a|
            # i܂ރACe
            items = a.backpack.find_all_items(type,item.id)
            # P폜
            items.any? {|item1| a.backpack.remove_item(item1)}
          end
        end
      end
    end
    $game_map.need_refresh = true
  end

  # ACě
  def lose_item(item, amount, include_equip = false)
    gain_item(item, -amount, include_equip)
  end

  # ACȅ
  def consume_item(item)
    lose_item(item, 1) if (item.is_a?(RPG::Item) or item.is_a?(Game_Item)) and item.consumable
  end

  # ACe̎gp
  # {̓AN^[ɂȂ\bh
  def use_item(item)
    if (item.is_a?(RPG::Item) or item.is_a?(Game_Item)) and item.consumable
      if not @backpack.nil?
        @backpack.remove_item(item)
      end
    end
    item.effects.each {|effect| item_global_effect_apply(effect) }
  end

  # gpΏۈȊOɑ΂gpʂ̓Kp
  # {̓AN^[ɂȂ\bh
  def item_global_effect_apply(effect)
    if effect.code == ::Game_Battler::EFFECT_COMMON_EVENT
      $game_temp.reserve_common_event(effect.data_id)
    end
  end

end
