# ACeEBhE
# Authors:: fukuyama
# Date:: 2011/12/27
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # ACeEBhẼwvs
  WINDOW_ITEM_HELP_LINE_NUMBER = 8 if not defined? WINDOW_ITEM_HELP_LINE_NUMBER
  # ACeEBhE
  class Window_Item < ::DQ::Window_Item_Base
    # 
    def initialize(parent,help=true)
      super(parent,parent.right,parent.top_window.top)
      self.unselect
      self.deactivate
      # wvEBhE쐬
      if help
        gold_window = find_window(Window_Gold)
        help_window = Window_Help.new(WINDOW_ITEM_HELP_LINE_NUMBER)
        help_window.width = gold_window.right - self.right
        help_window.create_contents
        help_window.top = gold_window.bottom
        help_window.left = self.right
        help_window.hide
        add_child(help_window)
        self.help_window = help_window
      end
    end

    # EBhE̕
    def window_width
      gold_window = find_window(Window_Gold)
      return gold_window.left - self.parent.right
    end

    # ACȇI
    def select_item
      window = Window_Item_Menu.new(self)
      self.active_window = window.class
    end

    # wvEBhE̍XV
    def update_help
      if not self.help_window.disposed?
        if not self.help_window.visible
          self.help_window.show
        end
        text = item ? item.description : ''
        text += make_item_status_description
        self.help_window.set_text(text)
      end
    end

    # ǉwveLXg
    def make_item_status_description
      return '' if actor.nil?
      return '' if not actor.is_a?(Game_Actor)
      return '' if item.is_a?(Game_Item)
      text = '\\bottom'
      if actor.equippable?(item)
        case item
        when Game_Weapon
          (a,b) = actor.equip_new_param(item,2)
        when Game_Armor
          (a,b) = actor.equip_new_param(item,3)
        end
        text << "\\left[#{a}]"
        text << "\\center_left[]"
        text << "\\center_right[ #{b}]"
      else
        text << "\\left[тłȂ]"
      end
      return text
    end

    # LZ
    def cancel
      self.help_window.hide
      self.unselect
      self.active_window = self.parent.class
    end

  end
end
