# ACej[EBhE
# Authors:: fukuyama
# Date:: 2011/12/28
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # ACej[EBhE
  class Window_Item_Menu < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Window_Command_Title_Module
    include Menu_Log_Item_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuItemTitle
      super(parent,0,0)

      # ʒu̐ݒ
      self.screen_bottom(16 + 32)
      self.right = self.parent.left
    end

    # j[̕
    def menu_width
      CHARA_WIDTH * 5
    end

    # R}hXg̍쐬
    def make_command_list
      actor = find_window(Window_Actor_Menu_Item).actor
      item = find_window(Window_Item).item
      add_command(Vocab::MenuItemUse,:use_item)
      add_command(Vocab::MenuItemTrade,:trade_item)
      if actor.is_a?(Game_Actor)
        if actor.equips.include?(item)
          add_command(Vocab::MenuItemRemoveEquip,:remove_equip_item)
        else
          add_command(Vocab::MenuItemEquip,:equip_item)
        end
      end
      add_command(Vocab::MenuItemThrow,:throw_item)
      add_command(Vocab::MenuCancel,:exit_window)
    end

    # 
    def use_item
      user = find_window(Window_Actor_Menu_Item).actor
      owner = find_window(Window_Actor_Menu_Item).owner
      item_org = find_window(Window_Item).item
      item = Item_Facade.get_use_item(item_org)
      # ACegȂԂ̏ꍇ
      if not user.nil? and not user.movable?
        menu_log_use_item_miss_user(item_org,user)
        return
      end
      # ȂACeꍇ
      if item.nil? or item.for_opponent? or not item.menu_ok?
        menu_log_use_item_miss(item_org,[owner])
        return
      end
      # ʔ͈͂ŚA{l̂݁Ŏg[U[܂Ăꍇ
      if item.for_all? or (item.for_user? and not user.nil?)
        # ACe܂gꍇ̎gAN^[I
        if user.nil?
          user = $game_party.movable_members.max_by {|member| member.pha }
        end
        if item.for_all?
          targets = $game_party.members
        else
          targets = [user]
        end
        used = false
        targets.each() do |target|
          target.item_apply(user, item)
          used |= target.result.used
        end
        if used
          # ʂ
          # XXX: hit ׂ݂H
          Sound.play_use_item
          owner.use_item(item)
          menu_log_use_item(item,user,$game_party.members)
          # RCxg\񔻒
          SceneManager.goto(Scene_Map) if $game_temp.common_event_reserved?
          # Q[I[o[
          SceneManager.goto(Scene_Gameover) if $game_party.all_dead?
        else
          # ʂȂ
          menu_log_use_item_miss(item,[owner])
        end
      elsif item.for_one? # ΏۂP̂̏ꍇ
        window = Window_Actor_Menu_Item_Use.new(self)
        self.active_window = window.class
      else
        menu_log_use_item_miss(item,[owner])
      end
    end

    # 킽
    def trade_item
      owner = find_window(Window_Actor_Menu_Item).owner
      item = find_window(Window_Item).item
      # ύX̉\
      if Item_Facade.equip_fix?(owner,item)
        # Œ肳Ăꍇ
        menu_log_trade_item_fix(owner,item)
        return
      end
      window = Window_Actor_Menu_Item_Trade.new(self)
      self.active_window = window.class
    end

    # 
    def equip_item
      actor = find_window(Window_Actor_Menu_Item).actor
      item = find_window(Window_Item).item
      menu_log_equip_item(actor,item)
    end

    # ͂
    def remove_equip_item
      actor = find_window(Window_Actor_Menu_Item).actor
      item = find_window(Window_Item).item
      menu_log_remove_equip_item(actor,item)
    end

    # Ă
    def throw_item
      owner = find_window(Window_Actor_Menu_Item).owner
      item = find_window(Window_Item).item
      menu_log_throw_item(owner,item)
    end

    # ߂
    def exit_window
      w = top_window
      w.close if not w.close?
    end
  end

end
