# JX^rbg}bv
# Authors:: fukuyama
# Date:: 2011/12/28
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License
#
# tH[}bg
# 1,2,3,4,5,6,7,8,9,10
# 1,2,3,4,5,6,7,8,9,10,11
# 1,2,3,4,5,6,7,8,9,10,11,12,13,14
# 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
#
#  1. folder      tH_
#  2. name        t@CigqȂj
#  3. width       쐬rbg}bv̕
#  4. height      쐬rbg}bv̍
#  5. src_folder  fރtH_
#  6. src_name    fރt@C
#
# src_rect
#  7. src_x       fރrbg}bv̓]wW
#  8. src_y       fރrbg}bv̓]xW
#  9. src_width   fރrbg}bv̓]
# 10. src_height  fރrbg}bv̓]
#
# 11. opacity     쐬rbg}bvւ̓]sx 0 ` 255
#
# dest_rect
# 11. dest_x      쐬rbg}bvւ̓]wW
# 12. dest_y      쐬rbg}bvւ̓]xW
# 13. dest_width  쐬rbg}bvւ̓]敝
# 14. dest_height 쐬rbg}bvւ̓]捂
#
# 15. opacity     쐬rbg}bvւ̓]sx 0 ` 255
#
# 擪Ɂu#vRgs
# 擪Ɂu*v_~[t@C쐬
#
# Bitmap.method (new \)
#  5. method_name
#  6. args
#
# base
#  5. base
#

module Cache
  # rbg}bv̓ǂݍ
  # load_bitmap
  def self.load_bitmap(folder_name, filename, hue = 0)
    path = folder_name + filename
    @cache ||= {}
    if filename.empty?
      empty_bitmap
    elsif custom_bitmap_path?(path)
      custom_bitmap(path)
    elsif hue == 0
      normal_bitmap(path)
    else
      hue_changed_bitmap(path, hue)
    end
  end

  # JX^rbg}bv
  def self.custom_bitmap_path?(path)
    return Custom_Bitmap.include?(path)
  end

  def self.custom_bitmap(path)
    @cache[path] = Custom_Bitmap.create(path) unless include?(path)
    @cache[path]
  end
end

module Custom_Bitmap
  CUSTOM_BITMAP_CSV_PATH = ['./','csv/','Data/','Data/csv/'] if not defined? CUSTOM_BITMAP_CSV_PATH
  DEFAULT_CUSTOM_BITMAP_FILE_NAME = "CustomBitmap" if not defined? DEFAULT_CUSTOM_BITMAP_FILE_NAME

  class Custom_Bitmap_Info
    def initialize()
      @folder = ""
      @name = ""
      @width = 32
      @height = 32

      @src_folder = nil
      @src_name = nil

      @src = nil
      @dest = nil

      @opacity = 255

      @method_name = nil
      @method_args = []
    end
    attr_accessor :folder
    attr_accessor :name
    attr_accessor :width
    attr_accessor :height

    attr_accessor :src_folder
    attr_accessor :src_name

    attr_accessor :src_rect
    attr_accessor :dest_rect

    attr_accessor :opacity

    attr_accessor :method_name
    attr_accessor :method_args
  end

  # JX^rbg}bvf[^
  @data_custom_bitmap = {}

  # JX^rbg}bvH
  def self.include?(path)
    return @data_custom_bitmap.include?(path)
  end

  # JX^rbg}bvf[^ǉ
  def self.add_custom_bitmap(info)
    path = 'Graphics/' + info.folder + info.name
    unless @data_custom_bitmap.include? path
      @data_custom_bitmap[path] = []
    end
    @data_custom_bitmap[path].push info
    return info
  end

  def self.add_custom_bitmap_info(folder, name,
    width,height,
    src_folder, src_name,
    src_rect = Rect.new(0,0,32,32),dest_rect = nil,opacity = 255)
    info = Custom_Bitmap_Info.new
    info.folder = folder + '/'
    info.name = name
    info.width = width
    info.height = height
    info.src_folder = src_folder + '/'
    info.src_name = src_name
    info.src_rect = src_rect
    info.dest_rect = dest_rect
    info.opacity = opacity
    return add_custom_bitmap(info)
  end

  def self.add_custom_bitmap_method(folder, name,
    width,height,
    method_name,method_args)
    info = Custom_Bitmap_Info.new
    info.folder = folder + '/'
    info.name = name
    info.width = width
    info.height = height
    info.method_name = method_name
    info.method_args = []
    while not method_args.empty?
      argv = method_args.shift
      if argv =~ /^\-?[0-9]+$/
        info.method_args.push argv.to_i
      elsif argv.downcase == "color"
        r = method_args.shift.to_i
        g = method_args.shift.to_i
        b = method_args.shift.to_i
        a = method_args.shift.to_i
        color = Color.new(r,g,b,a)
        info.method_args.push color
      else
        info.method_args.push argv
      end
    end
    return add_custom_bitmap(info)
  end

  # JX^rbg}bv쐬
  def self.compile_custom_bitmap_info(csv_filename)
    return unless FileTest.exist?(csv_filename)
    IO.foreach(csv_filename) do |line|
      next if line =~ /^#/
      next if line =~ /^$/
      dummy_file = false
      if line =~ /^\*/
        line[/^\*/] = ''
        dummy_file = true
      end
      param = line.split(/,/).collect {|t|t.strip}
      if param.size < 5
        next
      end
      folder     = param[0]
      name       = param[1]
      width      = param[2].to_i
      height     = param[3].to_i

      if Bitmap.method_defined?(param[4])
        # Method
        method_name = param[4]
        method_args = param[5 ... param.size]
        info = self.add_custom_bitmap_method(folder,name,
        width,height,
        method_name,
        method_args)
      elsif param[4] == "base"
        # Copy
        info = self.add_custom_bitmap_method(folder,name,
        width,height,
        'base',[])
      else
        # Normal
        if param.size < 10
          next
        end
        src_folder = param[4]
        src_name   = param[5]

        src = Rect.new(param[6].to_i,
        param[7].to_i,
        param[8].to_i,
        param[9].to_i)
        dest = nil
        opacity = 255
        if param.size == 11
          opacity = param[10].to_i
        end
        if param.size > 13
          dest = Rect.new(param[10].to_i,
          param[11].to_i,
          param[12].to_i,
          param[13].to_i)
        end
        if param.size == 15
          opacity = param[14].to_i
        end
        info = self.add_custom_bitmap_info(folder,name,
        width,height,
        src_folder,src_name,
        src,
        dest,
        opacity)
      end
      if dummy_file
        unless FileTest.exist?('Graphics/' + info.folder + info.name + '.png')
          File.open('Graphics/' + info.folder + info.name + '.png','w+').close()
        end
      end
    end
  end

  # JX^rbg}bvf[^ǂݍ݁RpC
  # filename ɂ́AgqȂBtH_w͉\B
  def self.load_custom_bitmap(filename=DEFAULT_CUSTOM_BITMAP_FILE_NAME)
    rvdata2_filename = "Data/#{File.basename(filename)}.rvdata2"
    # fobN̏ꍇ́Acsvrvdata2փRpC
    if $TEST
      @data_custom_bitmap.clear
      csv_folder = CUSTOM_BITMAP_CSV_PATH.find {|folder| FileTest.exist?(folder + filename + ".csv")}
      if not csv_folder.nil?
        compile_custom_bitmap_info(csv_folder + filename + ".csv")
      end
      save_data(@data_custom_bitmap,rvdata2_filename)
    end
    @data_custom_bitmap = load_data(rvdata2_filename)
  end

  # JX^rbg}bv쐬
  def self.create(path)
    infolist = @data_custom_bitmap[path]
    width = infolist.collect {|info|info.width}.max
    height = infolist.collect {|info|info.height}.max
    bmp = Bitmap.new(width, height)
    infolist.each do |info|
      if not info.method_name.nil?
        if info.method_name == "base"
          bmp = Bitmap.new(path)
        elsif info.method_name == "new"
          bmp = Bitmap.new(width, height)
        else
          bmp.method(info.method_name).call(*info.method_args)
        end
      else
        src_bmp = Cache::load_bitmap('Graphics/'+info.src_folder,info.src_name)
        dest_rect = info.dest_rect
        if dest_rect.nil?
          dest_rect = bmp.rect
        end
        bmp.stretch_blt(dest_rect, src_bmp, info.src_rect, info.opacity)
      end
    end
    return bmp
  end

end

System_Event.add_init_handler() do
  Custom_Bitmap.load_custom_bitmap()
end
