# ֘ÃObZ[W
# Authors:: fukuyama
# Date:: 2012/01/11
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  module Menu_Log_Item_Module
    # O쐬
    def create_menu_log_use_item(name,item,targets=nil)
      if targets.nil? or targets.size > 1 or name == targets[0].name
        return "#{name}́A#{item.name}B"
      else
        return "#{name}́@#{targets[0].name}Ɂ@#{item.name}B"
      end
    end

    # O
    def menu_log_use_item(item,owner,targets)
      if owner.is_a?(Game_Actor)
        name = owner.name
      else
        name = $game_party.smooth_target(0).name
      end
      e = Script_Event.new
      e.message(create_menu_log_use_item(name,item,targets))

      #      if not item.properties['menu_log_use_item'].nil?
      #        for target in targets
      #          # }[NAbvł̂́AƌEȂĉŁAƂ肠Oϊ
      #          log = item.properties['menu_log_use_item'].dup
      #
      #          # \item.name
      #          log[/\\item\.name/] = item.name if log =~ /\\item\.name/
      #
      #          # \target.name
      #          log[/\\target\.name/] = target.name if log =~ /\\target\.name/
      #
      #          e.message(log)
      #        end
      #      end
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ȂO
    def menu_log_use_item_miss(item,owner,targets=nil)
      if owner.is_a?(Game_Actor)
        name = owner.name
      else
        name = $game_party.smooth_target(0).name
      end
      e = Script_Event.new
      e.message(create_menu_log_use_item(name,item,targets.nil? ? nil : targets))
      e.message("AȂɂȂB")
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ACegԂȂꍇ̃O
    def menu_log_use_item_miss_user(item,user)
      e = Script_Event.new
      e.message("#{user.name}́A#{item.name}AƂłȂB")
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # т͂ꍇ̃O
    def menu_log_remove_equip_item(actor,item)
      # Œ肳Ăꍇ
      if Item_Facade.equip_fix?(actor,item)
        menu_log_remove_equip_item_fix(actor,item)
      else
        # O
        Item_Facade.remove_equip_item(actor,item)
        # SE
        Sound.play_equip
        # O
        e = Script_Event.new
        # łꍇ̏
        if actor.dead?
          alive_owner = $game_party.smooth_target(0)
          e.message("#{alive_owner.name}́A#{actor.name}\n#{item.name}A͂B")
        else
          e.message("#{actor.name}́A#{item.name}\n͂B")
        end
        e.method_call(find_window(Window_Item).method(:refresh))
        e.method_call(find_window(Window_Item_Menu).method(:close))
        e.blank
        SceneManager.scene.interpreter.setup(e.event_commands)
      end
    end

    # ͂ACeŒ肳Ăꍇ̃O
    def menu_log_remove_equip_item_fix(actor,item)
      e = Script_Event.new
      e.message("#{actor.name}#{item.name}\n͂ƂłȂB")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # AN^[ACe󂯎ꍇɑΘbCxg
    def menu_log_receive_item_actor_equip_event(e,actor,item)
      # Œ肳Ă
      if Item_Facade.equip_fix?(actor,item)
        return
      end
      # łȂ
      if not actor.equippable?(item)
        return
      end
      # AN^[SĂ
      if actor.dead?
        return
      end
      e.message("#{item.name}@܂H")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.message(create_menu_log_equip_item(actor,item))
      e.method_call(Sound.method(:play_equip))
      e.method_call(Item_Facade.method(:equip_item),actor,item)
      e.branch_end
    end

    # тꍇ̃O
    def create_menu_log_equip_item(actor,item)
      # łꍇ̏
      if actor.dead?
        alive_owner = $game_party.smooth_target(0)
        return "#{alive_owner.name}́A#{item.name}\n#{actor.name}ɁAB"
      else
        return "#{actor.name}́A#{item.name}\nB"
      end
    end

    # 킽̃O
    def menu_log_trade_item(from_owner,from_item,to_owner,to_item=nil)
      case to_owner
      when Game_Actor
        case from_owner
        when Game_Actor
          if to_item.nil?
            menu_log_hand_item_owner(from_owner,from_item,to_owner)
          else
            menu_log_trade_item_owner(from_owner,from_item,to_owner,to_item)
          end
        when Game_Party
          if to_item.nil?
            menu_log_hand_item_party(from_item,to_owner)
          else
            menu_log_trade_item_party(from_item,to_owner,to_item)
          end
        end
      when Game_Party
        case from_owner
        when Game_Actor
          menu_log_hand_item_backpack(from_owner,from_item)
        when Game_Party
          menu_log_trade_item_backpack(from_item)
        end
      end
    end

    # g[hACeŒ肳Ăꍇ̃O
    def menu_log_trade_item_fix(actor,item)
      e = Script_Event.new
      e.message("#{actor.name}#{item.name}\n͂ƂłȂB")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # AN^[AN^[ɃACenꍇ̃O
    def menu_log_hand_item_owner(from_owner,from_item,to_owner)
      msg = ''
      if from_owner == to_owner
        if from_owner.dead?
          alive_owner = $game_party.smooth_target(0)
          msg << "#{alive_owner.name}́@#{from_owner.name}\n"
          msg << "#{from_item.name}@ꂩB"
        else
          msg << "#{from_owner.name}\n"
          msg << "#{from_item.name}@ꂩB"
        end
      elsif from_owner.dead? and to_owner.dead?
        alive_owner = $game_party.smooth_target(0)
        msg << "#{alive_owner.name}́@#{from_owner.name}\n"
        msg << "#{from_item.name}@Ƃ肾\n"
        msg << "#{to_owner.name}Ɂ@B"
      elsif from_owner.dead?
        msg << "#{to_owner.name}́@#{from_owner.name}\n"
        msg << "#{from_item.name}@Ƃ肾B"
      elsif to_owner.dead?
        msg << "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{to_owner.name}Ɂ@B"
      else
        msg << "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{to_owner.name}Ɂ@킽B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,to_owner,from_item)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # AN^[ƃAN^[ACeꍇ̃O
    def menu_log_trade_item_owner(from_owner,from_item,to_owner,to_item)
      msg = ''
      if from_owner == to_owner
        if from_owner.dead?
          alive_owner = $game_party.smooth_target(0)
          msg << "#{alive_owner.name}́@#{from_owner.name}\n"
          msg << "#{from_item.name}Ɓ@#{to_item.name} ꂩB"
        else
          msg << "#{from_owner.name}\n"
          msg << "#{from_item.name}Ɓ@#{to_item.name} ꂩB"
        end
      elsif from_owner.dead? and to_owner.dead?
        alive_owner = $game_party.smooth_target(0)
        msg << "#{alive_owner.name}\n"
        msg << "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{to_owner.name}́@#{to_item.name}B"
      elsif from_owner.dead?
        msg << "#{to_owner.name}́@#{to_item.name}\n"
        msg << "#{from_owner.name}́@#{from_item.name}ƌB"
      elsif to_owner.dead?
        msg << "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{to_owner.name}́@#{to_item.name}ƌB"
      else
        msg  = "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{to_owner.name}́@#{to_item.name}ƌB"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,to_owner,from_item)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ӂ납AN^[ACeoꍇ̃O
    def menu_log_hand_item_party(from_item,to_owner)
      msg = ''
      if to_owner.dead?
        alive_owner = $game_party.smooth_target(0)
        msg  = "#{alive_owner.name}́@ӂ납\n"
        msg << "#{from_item.name}@Ƃ肾\n"
        msg << "#{to_owner.name}Ɂ@B"
      else
        msg  = "#{to_owner.name}́@ӂ납\n"
        msg << "#{from_item.name}@Ƃ肾B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,to_owner,from_item)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ӂ̃ACeƃAN^[̃ACeꍇ̃O
    def menu_log_trade_item_party(from_item,to_owner,to_item)
      msg = ''
      if to_owner.dead?
        alive_owner = $game_party.smooth_target(0)
        msg  = "#{alive_owner.name}́@ӂ́@#{from_item.name}\n"
        msg << "#{to_owner.name}́@#{to_item.name}B"
      else
        msg  = "ӂ́@#{from_item.name}\n"
        msg << "#{to_owner.name}́@#{to_item.name}B"
      end
      e = Script_Event.new
      e.message(msg)
      menu_log_receive_item_actor_equip_event(e,to_owner,from_item)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # AN^[̃ACeӂɓꍇ̃O
    def menu_log_hand_item_backpack(from_owner,from_item)
      msg = ''
      if from_owner.dead?
        alive_owner = $game_party.smooth_target(0)
        msg  = "#{alive_owner.name}\n"
        msg << "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{Vocab::BackpackName}Ɂ@ꂽB"
      else
        msg  = "#{from_owner.name}́@#{from_item.name}\n"
        msg << "#{Vocab::BackpackName}Ɂ@ꂽB"
      end
      e = Script_Event.new
      e.message(msg)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ӂ뒆̃ACeꍇ̃O
    def menu_log_trade_item_backpack(from_item)
      alive_owner = $game_party.smooth_target(0)
      msg  = "#{alive_owner.name}́@#{Vocab::BackpackName}\n"
      msg << "#{from_item.name}ꂩB"
      e = Script_Event.new
      e.message(msg)
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ACeO
    def menu_log_equip_item(actor,item)
      if Item_Facade.equip_fix?(actor,item)
        # Œ肳Ăꍇ
        menu_log_equip_item_fix(actor,item)
      elsif item.is_a?(Game_Item)
        # ACeȂꍇ
        menu_log_equip_item_error(item)
      elsif not actor.equippable?(item)
        # oȂꍇ
        menu_log_equip_item_actor_error(actor,item)
      else
        # 
        Item_Facade.equip_item(actor,item)
        # SE
        Sound.play_equip
        # O
        e = Script_Event.new
        e.message(create_menu_log_equip_item(actor,item))
        e.method_call(find_window(Window_Item).method(:refresh))
        e.method_call(find_window(Window_Item_Menu).method(:close))
        e.blank
        SceneManager.scene.interpreter.setup(e.event_commands)
      end
    end

    # тłȂACȅꍇ̃O
    def menu_log_equip_item_error(item)
      e = Script_Event.new
      e.message("#{item.name}\n邱Ƃ́@ł܂B")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # уACeŒ肳Ăꍇ̃O
    def menu_log_equip_item_fix(actor,item)
      e = Script_Event.new
      # ӏ̊mF
      slot_id = actor.empty_slot(item.etype_id)
      equip_item = actor.equips[slot_id]
      e.message("#{actor.name}́@#{equip_item.name}\n͂ƂłȂB")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # тłȂAN^[̏ꍇ̃O
    def menu_log_equip_item_actor_error(actor,item)
      e = Script_Event.new
      e.message("#{actor.name}́@#{item.name}\n邱ƂłȂB")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ACeĂ郍O
    def menu_log_throw_item(owner,item)
      # ύX̉\
      if Item_Facade.equip_fix?(owner,item)
        # Œ肳Ăꍇ
        menu_log_throw_item_fix(owner,item)
      elsif Item_Facade.throw_item?(owner,item)
        case owner
        when Game_Actor
          menu_log_throw_item_actor(owner,item)
        when Game_Party
          menu_log_throw_item_party(owner,item)
        end
      else
        menu_log_throw_item_error(owner,item)
      end
    end

    # AN^[ACeĂꍇ̃O
    def menu_log_throw_item_actor(actor,item)
      e = Script_Event.new
      e.message("#{item.name}\n̂ĂĂłH")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(Item_Facade.method(:throw_item),actor,item)
      if actor.dead?
        alive_owner = $game_party.smooth_target(0)
        e.message("#{alive_owner.name}́@#{actor.name}\n#{item.name}@ȂĂB")
      else
        e.message("#{actor.name}́@#{item.name}@ȂĂB")
      end
      e.branch_end
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ӂ납ACeĂꍇ̃O
    def menu_log_throw_item_party(owner,item)
      e = Script_Event.new
      e.message("#{item.name}\n̂ĂĂłH\n")
      e.branch_start(['͂',''],2)
      e.branch_item(0)
      e.method_call(Item_Facade.method(:throw_item),owner,item)
      e.message("#{item.name}ȂĂB")
      e.branch_end
      e.method_call(find_window(Window_Item).method(:refresh))
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ĂȂACeĂꍇ̃O
    def menu_log_throw_item_error(owner,item)
      e = Script_Event.new
      e.message("@̂ĂȂā@ƂłȂI")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end

    # ĂACeŒ肳Ăꍇ̃O
    def menu_log_throw_item_fix(owner,item)
      e = Script_Event.new
      e.message("#{actor.name}#{item.name}\n͂ƂłȂB")
      e.method_call(find_window(Window_Item_Menu).method(:close))
      e.blank
      SceneManager.scene.interpreter.setup(e.event_commands)
    end
  end
end
