# og[x[X̉
# Authors:: fukuyama
# Date:: 2012/03/05
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module Game_BattlerBase_Module
  @@_item_node_cache = {}

  # g`FbN
  def memo_conditions_met?(item)
    result = true
    if @@_item_node_cache.include?(item.note)
      args = @@_item_node_cache[item.note]
    else
      # RCxgƃx擾
      note = item.note.gsub(/\r?\n/,'')
      if note =~ /\[gp:(.+?)\]/
        (name,label,*params)=$1.split(/,/).collect(){|s|s.strip}
        op = {
          :default => result
        }
        op[:params] = params.collect(){|o|o.to_i} unless params.empty?
        args = {
          :name => name,
          :label => label,
          :op => op
        }
        @@_item_node_cache[item.note] = args
      else
        @@_item_node_cache[item.note] = nil
        args = nil
      end
    end
    return result if args.nil?
    if $game_party.in_battle
      args[:op][:battler] = BattleManager.actor
    else
      args[:op][:battler] = self
    end
    return Common_Event_Condition.exec(args[:name],args[:label],args[:op])
  end
end

class Game_BattlerBase
  include Game_BattlerBase_Module
  # XL^ACe̋ʎgp\`FbN
  def usable_item_conditions_met?(item)
    movable? && occasion_ok?(item) && memo_conditions_met?(item)
  end
end
