# vpeBC^tF[XW[
# Authors:: fukuyama
# Date:: 2012/01/28
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module Properties_Interface_Module
  # ftHgvpeB
  def default_properties
    return {}
  end

  # vpeBANZT
  def properties
    # ANZX̂݃ftHgvpeBŏ
    @properties = default_properties if @properties.nil?
    return @properties
  end

  # vpeB[h\bh
  def self.load_properties(array,id,filename,flag=false)
    # vpeBf[^[h
    data_properties = nil
    begin
      data_properties = load_data(filename)
    rescue Errno::ENOENT
      #if $DEBUG
      # O Errno::ENOENT ⑫
      # t@CI[vłȂꍇAbZ[W\ďI
      #filename = $!.message.sub("No such file or directory - ", "")
      #print("t@C #{filename} ܂Bǂݍ܂Ɏs܂B")
      #end
      return
    end
    for object in array
      next if object.nil?
      # f[^z̎w肳ꂽIDL[ɃvpeB擾
      properties = data_properties[object.method(id).call.to_s]
      next if properties.nil?
      if flag
        # f[^}[W
        object.properties.update(properties) {|key, self_val, other_val| self_val}
      else
        object.properties.update(properties)
      end
    end
  end

  # vpeBt@CRpC\bh
  # BASE_DIR (['./','csv/','Data/','Data/csv/'])
  #  filename TāAdata_filename  rxdata ɕϊ
  def self.compile_properties(filename,data_filename=nil)
    # fobNł͖ꍇ́ARpCȂ
    return if not $DEBUG
    if data_filename.nil?
      filename = File.basename(filename,".*")
      data_filename = "Data/#{filename}.rxdata"
      filename = filename + '.csv'
    end
    # f[^vpeB
    data_properties = {}
    if not FileTest.file?(data_filename)
      save_data(data_properties,data_filename)
    end
    # x[XfBNg
    base_dir = ['./','csv/','Data/','Data/csv/']
    base_dir = BASE_DIR if defined? BASE_DIR
    # brut@CpX쐬
    csv_folder = base_dir.find {|folder| FileTest.exist?(folder + filename)}
    return if csv_folder.nil?
    csv_filename = csv_folder + filename
    # t@Cꍇ́ARpCȂ
    if not FileTest.file?(csv_filename)
      return
    end
    # bruǂݍ
    File.open(csv_filename) do |file|
      # sڂvpeBiځj
      while not file.eof?
        line = file.gets
        next if line =~ /^#/
        next if line =~ /^$/
        keys = line.chop.split(/,/).collect {|k| k.strip}
        break
      end
      # ȍ~f[^vpeB
      while not file.eof?
        line = file.gets
        next if line =~ /^#/
        next if line =~ /^$/
        values = line.chop.split(/,/,keys.size).collect {|v| v.strip}
        # Jf[^vpeB̃L[
        id = values[0]
        data_properties[id] = {}
        # vpeBiځj
        for key in keys
          # ԂɎ擾
          value = values.shift
          if (not value.nil?) and (not value.empty?)
            # ^ϊ
            (key_name,key_type) = key.split(/:/)
            case key_type
            when 'n'
              value = value.to_i
            when 'b'
              value = value.casecmp("true")
            end
            # lݒ
            data_properties[id][key_name] = value
          end
        end
      end
    end
    # f[^ۑ
    save_data(data_properties,data_filename)
    return data_properties
  end
end
