# AN^[ڍ׃Xe[^X
# Authors:: fukuyama
# Date:: 2012/01/29
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  # ڍ׃Xe[^XEBhE
  class Window_Status_Detail < ::Window_Base
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent)
      window_actor_summary = parent.find_window(Window_Status_Summary)
      x = window_actor_summary.right
      y = window_actor_summary.top
      w = CHARA_WIDTH * 10 + standard_padding * 2 + 6
      h = fitting_height(10)
      super(parent,x,y,w,h)
      @value_width = self.contents.text_size('00000').width
    end

    # AN^[̐ݒ
    def actor=(actor)
      if @actor != actor
        @actor = actor
        refresh
      end
    end

    # `p\bh
    def draw_parameter(x,y,wk,wv,key,val,ak=2,av=2)
      change_color(system_color)
      draw_text(x, y, wk, line_height, key, ak)
      change_color(normal_color)
      draw_text(x + wk, y, wv, line_height, val, av)
    end

    def draw_actor_param(x,y,key,val)
      wk = self.contents.width - @value_width
      wv = @value_width
      draw_parameter(x,y,wk,wv,key,val)
    end

    def draw_actor_param_id(x,y,param_id)
      draw_actor_param(x,y,Vocab::param(param_id)+':',@actor.param(param_id))
    end

    def draw_actor_exp(x,y,key,val)
      key += ':'
      wk = text_size(key).width + 4
      wv = self.contents.width - wk
      draw_parameter(x,y,wk,wv,key,val,1,2)
    end

    # tbV
    def refresh
      self.contents.clear
      return if @actor.nil?
      (x,y) = 0,0
      #      draw_actor_face(@actor, x, y)
      6.times do |i|
        draw_actor_param_id(x, y, i + 2)
        y += line_height
      end
      draw_actor_param(x,y,"ő#{Vocab::hp_a}:",@actor.mhp)
      y += line_height
      draw_actor_param(x,y,"ő#{Vocab::mp_a}:",@actor.mmp)
      y += line_height
      draw_actor_exp(x,y,'Ex',@actor.exp.to_s)
      y += line_height
      draw_actor_exp(x,y,'Next',(@actor.next_level_exp - @actor.exp).to_s)
    end
  end

end
