# XLXe[^XEBhE
# Authors:: fukuyama
# Date:: 2012/02/06
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  class Window_Status_Skill < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Window_Command_Title_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuSkillStatusTitle
      self.title_align = 1
      super(parent,parent.top_window.left + 32,parent.top_window.top)
      self.unselect()
    end

    # ڂ̑I𖳌
    def select(index)
    end

    # ڂ̗L true
    def current_item_enabled?
      true
    end

    # EBhE̕
    def window_width
      gold_window = find_window(Window_Gold)
      return gold_window.right - (top_window.left + 32) - 32
    end

    # j[J
    def col_max
      return 2
    end

    # AN^[̎擾
    def actor
      self.parent.actor
    end

    # R}hXg̍쐬
    # AN^[XL̍XV
    def make_command_list
      skills = self.actor.class.learnings.collect() {|l| $data_skills[l.skill_id]}
      skills.each do |skill|
        add_command(skill.name, :ok, true, skill)
      end
    end

    # 菈
    def ok
      learnings = self.actor.class.learnings
      if learnings.collect() {|l|$data_skills[l.skill_id]}.any?(){|s|s.menu_ok?}
        window = Window_Status_Normal_Skill.new(self)
        self.active_window = window.class
      else
        close
      end
    end

    # ڂ̕`
    def draw_item(index)
      skill = @list[index][:ext]
      if self.actor.skill_learn?(skill)
        change_color(normal_color)
        draw_text(item_rect_for_text(index), command_name(index), alignment)
      end
    end

  end

end
