# AN^[ȈՃXe[^X
# Authors:: fukuyama
# Date:: 2012/01/28
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  unless defined? STATUS_SUMMARY_PROPERTIES
    STATUS_SUMMARY_PROPERTIES = [
      {:key=>Game_Actor::PROPERTY_SEX,:display=>'ׂ:',:default=>'HHH'}
    ]
  end

  class Window_Status_Summary < ::Window_Base
    include Window_Tree_Module
    # IuWFNg
    def initialize(parent)
      property_size = STATUS_SUMMARY_PROPERTIES.size
      x = parent.right
      y = parent.top_window.top
      w = CHARA_WIDTH * 8 + standard_padding * 2 + 8
      h = fitting_height(3 + property_size)
      super(parent,x,y,w,h)
    end

    # AN^[̐ݒ
    def actor=(actor)
      if @actor != actor
        @actor = actor
        refresh
      end
    end

    # tbV
    def refresh
      self.contents.clear
      return if @actor.nil?

      (x,y) = 0,0
      width = self.contents.width

      change_color(normal_color)
      contents.draw_text(x,y,width,line_height,@actor.name,1)
      y += line_height
      job_name = @actor.properties[Game_Actor::PROPERTY_JOB]
      contents.draw_text(x,y,width,line_height,job_name,1)
      y += line_height

      (x,y,display_width) = refresh_properties(x,y,contents)

      change_color(system_color)
      contents.draw_text(x,y,display_width,line_height,'x:',2)
      change_color(normal_color)
      contents.draw_text(x + display_width,y,width - display_width,line_height,@actor.level.to_s,1)

    end

    def refresh_properties(x,y,contents)
      width = self.contents.width

      display_width = STATUS_SUMMARY_PROPERTIES.collect(){|data| contents.text_size(data[:display]).width }.max + 4

      STATUS_SUMMARY_PROPERTIES.each do |data|
        change_color(system_color)
        contents.draw_text(x,y,display_width,line_height,data[:display],2)
        change_color(normal_color)
        if @actor.properties.member?(data[:key])
          contents.draw_text(x + display_width,y,width - display_width,line_height,@actor.properties[data[:key]],1)
        else
          contents.draw_text(x + display_width,y,width - display_width,line_height,data[:default],1)
        end
        y += line_height
      end
      return x,y,display_width
    end
  end

end
